<?php
/**
 * Sistema Médico - Clase de Autenticación
 * Manejo de login, logout y verificación de sesión
 */

class Auth {
    private $conn;
    private $table_name = "usuarios";

    public function __construct($db) {
        $this->conn = $db;
    }

    /**
     * Iniciar sesión
     */
    public function login($usuario, $contrasena) {
        $query = "SELECT id, usuario, contrasena, nombre_completo, rol 
                  FROM " . $this->table_name . " 
                  WHERE usuario = :usuario AND activo = 1 
                  LIMIT 1";

        $stmt = $this->conn->prepare($query);
        $stmt->bindParam(':usuario', $usuario);
        $stmt->execute();

        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch();
            
            // Verificar contraseña
            if (password_verify($contrasena, $row['contrasena'])) {
                // Iniciar sesión
                $_SESSION['user_id'] = $row['id'];
                $_SESSION['usuario'] = $row['usuario'];
                $_SESSION['nombre_completo'] = $row['nombre_completo'];
                $_SESSION['rol'] = $row['rol'];
                $_SESSION['logged_in'] = true;
                
                return true;
            }
        }

        return false;
    }

    /**
     * Cerrar sesión
     */
    public function logout() {
        session_unset();
        session_destroy();
        return true;
    }

    /**
     * Verificar si el usuario está autenticado
     */
    public static function isLoggedIn() {
        return isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true;
    }

    /**
     * Obtener información del usuario actual
     */
    public static function getCurrentUser() {
        if (self::isLoggedIn()) {
            return [
                'id' => $_SESSION['user_id'],
                'usuario' => $_SESSION['usuario'],
                'nombre_completo' => $_SESSION['nombre_completo'],
                'rol' => $_SESSION['rol']
            ];
        }
        return null;
    }

    /**
     * Redirigir si no está autenticado
     */
    public static function requireLogin() {
        if (!self::isLoggedIn()) {
            header('Location: login.php');
            exit();
        }
    }
}
?>

