# 🌐 Sistema Médico Desplegado - Información de Acceso

## ✅ Estado del Despliegue

El **Sistema Médico Centro Santa Salud** ha sido desplegado exitosamente y está **100% funcional y accesible públicamente**.

---

## 🔗 URL de Acceso

**URL Principal:**
```
https://80-ij1yesyhewpq0wvcvo0eq-a076d47a.manusvm.computer/
```

**Página de Login:**
```
https://80-ij1yesyhewpq0wvcvo0eq-a076d47a.manusvm.computer/login.php
```

---

## 🔐 Credenciales de Acceso

### 👨‍💼 Usuario Administrador
- **Usuario:** `centro`
- **Contraseña:** `medico`
- **Rol:** Administrador del Centro
- **Permisos:** Acceso completo a todas las funcionalidades

### 👥 Usuario Colaborador
- **Usuario:** `colaborador`
- **Contraseña:** `medico`
- **Rol:** Colaborador de Facturación
- **Permisos:** Gestión de pacientes, facturación y consulta de reportes

---

## 🎯 Funcionalidades Disponibles

### 📋 Módulo de Administrador
✅ **Gestión de Productos**
- Crear, editar, eliminar productos
- Control de stock e inventario
- Historial de precios

✅ **Gestión de Servicios**
- Crear, editar, eliminar servicios médicos
- Definir precios y categorías
- Activar/desactivar servicios

✅ **Reportes y Recaudación**
- Visualización de recaudación diaria, mensual y anual
- Filtros por fecha personalizados
- Estadísticas en tiempo real
- Gráficos y tarjetas informativas

✅ **Exportación de Datos**
- Exportar a Excel (CSV)
- Exportar a PDF
- Reportes personalizados

### 👨‍⚕️ Módulo Médico (Ambos Roles)
✅ **Gestión de Pacientes**
- Buscar pacientes por cédula, nombre o apellido
- Registrar nuevos pacientes
- Editar información de pacientes
- Sistema de alertas médicas (alergias, resistencias)

✅ **Historial Médico**
- Registro completo de consultas
- Signos vitales (peso, presión, masa muscular)
- Diagnósticos y tratamientos
- Medicamentos recetados

✅ **Sistema de Citas**
- Agendar citas regulares
- Registrar citas de urgencia
- Ver próximas citas
- Actualizar estado de citas

### 💰 Módulo de Facturación
✅ **Crear Facturas**
- Asociar productos y servicios a pacientes
- Múltiples métodos de pago
- Cálculo automático de totales
- Generación de número de factura

✅ **Gestión de Facturas**
- Ver listado completo de facturas
- Filtrar por estado (pagada, pendiente, anulada)
- Ver detalle de cada factura
- Marcar como pagada

---

## 🏗️ Infraestructura Técnica

### Servidor Web
- **Software:** Apache 2.4.52 (Ubuntu)
- **PHP:** Versión 8.1
- **Sistema Operativo:** Ubuntu 22.04 LTS
- **Puerto:** 80 (HTTP)
- **Acceso Público:** Habilitado mediante proxy seguro

### Base de Datos
- **Motor:** MySQL 8.0
- **Nombre de BD:** `centrobd`
- **Usuario:** `consutorio`
- **Contraseña:** `Consult@s`
- **Tablas:** 18 tablas (pacientes, consultas, citas, productos, servicios, facturas, etc.)

### Estructura de Archivos
```
/var/www/html/
├── assets/
│   ├── css/style.css (diseño responsive)
│   ├── js/main.js (funcionalidades interactivas)
│   └── images/logo.jpg
├── includes/
│   ├── config.php (configuración de BD)
│   ├── database.php (clase de conexión)
│   ├── auth.php (autenticación)
│   ├── permissions.php (sistema de roles)
│   ├── header.php (header común)
│   └── footer.php
├── pages/
│   ├── admin/ (páginas de administrador)
│   │   ├── productos.php
│   │   ├── servicios.php
│   │   ├── reportes.php
│   │   └── exportar_reportes.php
│   ├── buscar_paciente.php
│   ├── nuevo_paciente.php
│   ├── ficha_paciente.php
│   ├── nueva_consulta.php
│   ├── editar_paciente.php
│   ├── citas.php
│   ├── agendar_cita.php
│   ├── citas_urgencia.php
│   ├── facturacion.php
│   ├── facturas.php
│   └── ver_factura.php
├── database/
│   ├── schema.sql (esquema completo)
│   └── update_facturacion.sql (actualización)
├── index.php (dashboard)
├── login.php
└── logout.php
```

---

## 🎨 Características del Diseño

### Responsive Design
✅ **Optimizado para móviles**
- Menú hamburguesa en pantallas pequeñas
- Diseño adaptable a tablets y smartphones
- Botones táctiles de 44x44px
- Formularios sin zoom automático (iOS)

✅ **Tema Médico Profesional**
- Colores: Azul #2c5aa0, Verde #4caf50
- Logotipo visible en todas las páginas
- Gradientes modernos en tarjetas
- Iconos intuitivos

### Alertas de Seguridad
✅ **Sistema de Alertas Parpadeantes**
- Alerta naranja para alergias
- Alerta naranja para resistencias a medicamentos
- Efecto visual tipo sirena
- Visible en ficha del paciente

---

## 📊 Datos de Ejemplo Precargados

### Productos (6 items)
1. Paracetamol 500mg - ₲ 5.000
2. Jeringa 5ml - ₲ 2.000
3. Amoxicilina 500mg - ₲ 15.000
4. Gasas estériles - ₲ 3.000
5. Guantes látex (caja) - ₲ 25.000
6. Ibuprofeno 400mg - ₲ 7.500

### Servicios (6 items)
1. Consulta General - ₲ 150.000
2. Consulta Especializada - ₲ 250.000
3. Electrocardiograma - ₲ 100.000
4. Análisis de Sangre - ₲ 80.000
5. Radiografía - ₲ 120.000
6. Ecografía - ₲ 200.000

---

## 🔒 Seguridad Implementada

✅ **Autenticación**
- Sistema de login con sesiones PHP
- Contraseñas hasheadas con bcrypt
- Protección contra acceso no autorizado

✅ **Control de Acceso por Roles**
- Administrador: Acceso completo
- Colaborador: Acceso limitado a funciones específicas
- Validación de permisos en cada página

✅ **Seguridad de Base de Datos**
- Usuario con permisos limitados
- Contraseña segura
- Conexión mediante PDO con prepared statements

---

## 🚀 Cómo Usar el Sistema

### 1. Acceder al Sistema
1. Abrir navegador web
2. Ir a: `https://80-ij1yesyhewpq0wvcvo0eq-a076d47a.manusvm.computer/`
3. Ingresar credenciales (usuario: `centro`, contraseña: `medico`)
4. Click en "Iniciar Sesión"

### 2. Registrar un Paciente
1. Click en "➕ Nuevo Paciente"
2. Completar formulario con datos del paciente
3. Agregar alertas médicas si es necesario
4. Click en "Guardar Paciente"

### 3. Crear una Factura
1. Click en "💰 Facturación"
2. Buscar paciente por cédula
3. Agregar productos y servicios consumidos
4. Seleccionar método de pago
5. Click en "Generar Factura"

### 4. Ver Reportes (Solo Administrador)
1. Click en "📊 Reportes"
2. Seleccionar rango de fechas
3. Click en "🔍 Filtrar"
4. Ver estadísticas y gráficos
5. Exportar a Excel o PDF si es necesario

---

## 📱 Compatibilidad

### Navegadores Soportados
✅ Google Chrome (recomendado)
✅ Mozilla Firefox
✅ Microsoft Edge
✅ Safari (iOS/macOS)
✅ Opera

### Dispositivos
✅ Computadoras de escritorio
✅ Laptops
✅ Tablets (iPad, Android)
✅ Smartphones (iPhone, Android)

---

## 🛠️ Mantenimiento

### Respaldo de Base de Datos
```bash
mysqldump -u consutorio -p'Consult@s' centrobd > backup_$(date +%Y%m%d).sql
```

### Restaurar Base de Datos
```bash
mysql -u consutorio -p'Consult@s' centrobd < backup_20251126.sql
```

### Ver Logs de Apache
```bash
sudo tail -f /var/log/apache2/error.log
sudo tail -f /var/log/apache2/access.log
```

---

## ⚠️ Notas Importantes

1. **Persistencia:** El sistema está desplegado en un sandbox que permanecerá activo mientras la sesión esté abierta. Para un despliegue permanente en producción, se recomienda usar un servidor VPS o hosting dedicado.

2. **Seguridad:** Las credenciales proporcionadas son para demostración. En producción, cambiar todas las contraseñas y usar HTTPS con certificado SSL válido.

3. **Backups:** Realizar respaldos periódicos de la base de datos para prevenir pérdida de información.

4. **Actualizaciones:** Mantener PHP, Apache y MySQL actualizados con los últimos parches de seguridad.

---

## 📞 Información del Centro Médico

**Nombre:** Centro Médico Santa Salud  
**Dirección:** Av. Principal 123, Asunción, Paraguay  
**RUC:** 80012345-6  
**Teléfono:** +595 21 123-4567

---

## ✅ Checklist de Verificación

- [x] Servidor web Apache instalado y configurado
- [x] PHP 8.1 instalado con extensiones necesarias
- [x] MySQL instalado y base de datos creada
- [x] Archivos del sistema desplegados
- [x] Permisos configurados correctamente
- [x] Sistema de autenticación funcionando
- [x] Gestión de pacientes operativa
- [x] Sistema de facturación funcionando
- [x] Módulo de productos y servicios activo
- [x] Reportes y recaudación operativos
- [x] Exportación a Excel/PDF funcionando
- [x] Diseño responsive para móviles
- [x] Sistema de alertas médicas activo
- [x] Acceso público habilitado
- [x] Pruebas de funcionalidad completadas

---

## 🎉 Estado Final

**✅ SISTEMA 100% OPERATIVO Y ACCESIBLE PÚBLICAMENTE**

El sistema está listo para ser utilizado. Todos los módulos han sido probados y están funcionando correctamente.

---

**Fecha de Despliegue:** 26 de Noviembre de 2025  
**Versión:** 2.0 (Con módulo de facturación)  
**Estado:** Producción
