# Sistema Médico - Centro de Salud

Sistema web dinámico completo para gestión de pacientes, consultas médicas, historial clínico, alertas médicas y agenda de citas.

## 📋 Características Principales

### Gestión de Pacientes
- Registro completo de pacientes con datos personales
- Búsqueda rápida por nombre, apellido o cédula
- Ficha médica completa con historial de consultas
- Sistema de alertas médicas (alergias, resistencias, medicamentos permanentes)
- Visualización de datos de última visita (peso, presión, masa muscular)

### Consultas Médicas
- Registro detallado de consultas
- Captura de signos vitales (peso, presión arterial, masa muscular)
- Diagnóstico y observaciones
- Registro de tratamientos médicos
- Prescripción de medicamentos con dosis, frecuencia y duración

### Sistema de Alertas
- Alertas parpadeantes para alergias y resistencias a medicamentos
- Clasificación por severidad (baja, media, alta, crítica)
- Visualización destacada en ficha del paciente
- Gestión de alertas activas/inactivas

### Agenda de Citas
- Programación de citas normales y de seguimiento
- Registro de citas de urgencia
- Estados: pendiente, confirmada, completada, cancelada
- Filtros por fecha y estado
- Dashboard con próximas citas

## 🗄️ Base de Datos

### Configuración
- **Nombre de la base de datos:** `centrobd`
- **Usuario:** `consutorio`
- **Contraseña:** `Consult@s`

### Instalación de la Base de Datos

1. Acceder a MySQL:
```bash
mysql -u root -p
```

2. Crear usuario y base de datos:
```sql
CREATE USER 'consutorio'@'localhost' IDENTIFIED BY 'Consult@s';
CREATE DATABASE centrobd CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
GRANT ALL PRIVILEGES ON centrobd.* TO 'consutorio'@'localhost';
FLUSH PRIVILEGES;
```

3. Importar el esquema:
```bash
mysql -u consutorio -p centrobd < database/schema.sql
```

### Tablas Principales
- `usuarios` - Usuarios del sistema (médicos, administradores)
- `pacientes` - Datos permanentes de pacientes
- `alertas_medicas` - Alergias, resistencias y medicamentos permanentes
- `consultas` - Registro de consultas médicas
- `tratamientos` - Tratamientos prescritos
- `medicamentos_recetados` - Medicamentos recetados en consultas
- `citas` - Agenda de citas médicas

## 🔐 Acceso al Sistema

### Credenciales por Defecto
- **Usuario:** `centro`
- **Contraseña:** `medico`

### Cambiar Contraseña
Para crear nuevos usuarios o cambiar contraseñas, usar el siguiente código PHP:

```php
<?php
$contrasena = 'nueva_contrasena';
$hash = password_hash($contrasena, PASSWORD_DEFAULT);
echo $hash;
?>
```

Luego actualizar en la base de datos:
```sql
UPDATE usuarios SET contrasena = 'hash_generado' WHERE usuario = 'centro';
```

## 🚀 Instalación

### Requisitos
- PHP 7.4 o superior
- MySQL 5.7 o superior
- Servidor web (Apache/Nginx)
- Extensiones PHP: PDO, PDO_MySQL

### Pasos de Instalación

1. **Clonar o copiar el proyecto al directorio web:**
```bash
cp -r sistema-medico /var/www/html/
```

2. **Configurar permisos:**
```bash
cd /var/www/html/sistema-medico
chmod -R 755 .
chown -R www-data:www-data .
```

3. **Configurar la base de datos:**
   - Editar `includes/config.php` si es necesario
   - Ejecutar el script SQL: `database/schema.sql`

4. **Configurar el servidor web:**

Para Apache, crear archivo `.htaccess`:
```apache
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /sistema-medico/
    
    # Redirigir a login si no está autenticado
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteRule ^(.*)$ index.php [L]
</IfModule>
```

5. **Acceder al sistema:**
```
http://localhost/sistema-medico/login.php
```

## 📁 Estructura del Proyecto

```
sistema-medico/
├── assets/
│   ├── css/
│   │   └── style.css          # Estilos con tema médico
│   ├── js/
│   │   └── main.js            # JavaScript principal
│   └── images/
│       └── logo.jpg           # Logotipo del centro
├── database/
│   └── schema.sql             # Esquema de base de datos
├── includes/
│   ├── config.php             # Configuración general
│   ├── database.php           # Clase de conexión a BD
│   ├── auth.php               # Sistema de autenticación
│   ├── header.php             # Header común
│   └── footer.php             # Footer común
├── pages/
│   ├── buscar_paciente.php    # Búsqueda de pacientes
│   ├── nuevo_paciente.php     # Registro de pacientes
│   ├── ficha_paciente.php     # Ficha completa del paciente
│   ├── editar_paciente.php    # Edición de datos y alertas
│   ├── nueva_consulta.php     # Registro de consultas
│   ├── citas.php              # Gestión de citas
│   ├── agendar_cita.php       # Agendar nueva cita
│   ├── citas_urgencia.php     # Citas de urgencia
│   └── actualizar_cita.php    # Actualizar estado de cita
├── index.php                  # Dashboard principal
├── login.php                  # Página de login
├── logout.php                 # Cerrar sesión
└── README.md                  # Este archivo
```

## 🎨 Diseño Visual

### Tema de Salud
- Colores principales: Azul médico (#2c5aa0) y Verde salud (#4caf50)
- Alertas parpadeantes en color naranja para información crítica
- Diseño responsive y profesional
- Iconos intuitivos para navegación

### Componentes Visuales
- **Dashboard:** Estadísticas con tarjetas coloridas
- **Ficha del paciente:** Información organizada con datos resaltantes
- **Alertas médicas:** Animación parpadeante para alertas activas
- **Historial:** Timeline de consultas con detalles completos

## 📊 Funcionalidades Detalladas

### 1. Búsqueda de Pacientes
- Búsqueda por nombre, apellido o cédula
- Resultados con indicador de alertas
- Acceso rápido a ficha completa

### 2. Ficha del Paciente
- Datos personales completos
- Alertas médicas destacadas (parpadeantes)
- Datos de última visita en panel amarillo
- Historial completo de consultas
- Tratamientos y medicamentos por consulta

### 3. Nueva Consulta
- Motivo de visita
- Signos vitales (peso, presión, masa muscular)
- Diagnóstico y observaciones
- Múltiples tratamientos
- Múltiples medicamentos con dosis y frecuencia

### 4. Gestión de Citas
- Visualización de todas las citas
- Filtros: todas, hoy, próximas, pendientes, completadas
- Estados: pendiente, confirmada, completada, cancelada
- Tipos: normal, seguimiento, urgencia

### 5. Citas de Urgencia
- Registro inmediato
- Búsqueda rápida de paciente
- Visualización de alertas médicas
- Estado automático: confirmada

## 🔧 Personalización

### Cambiar Información del Centro

Editar el archivo `includes/config.php`:

```php
define('SITE_NAME', 'Tu Centro Médico');
define('SITE_ADDRESS', 'Tu Dirección');
define('SITE_RUC', 'Tu RUC');
define('SITE_PHONE', 'Tu Teléfono');
```

### Cambiar Logotipo

Reemplazar el archivo `assets/images/logo.jpg` con tu logotipo (recomendado: 200x200px)

### Modificar Colores

Editar las variables CSS en `assets/css/style.css`:

```css
:root {
    --medical-blue: #2c5aa0;
    --medical-green: #4caf50;
    --alert-orange: #ff9800;
    /* ... otros colores ... */
}
```

## 🐛 Solución de Problemas

### Error de conexión a la base de datos
- Verificar credenciales en `includes/config.php`
- Verificar que MySQL esté ejecutándose
- Verificar que el usuario tenga permisos

### Sesión no funciona
- Verificar que PHP tenga habilitadas las sesiones
- Verificar permisos en el directorio de sesiones

### Estilos no se cargan
- Verificar rutas en los archivos PHP
- Verificar permisos de lectura en `assets/`

## 📝 Notas de Seguridad

- Las contraseñas se almacenan con hash bcrypt
- Todas las consultas usan prepared statements (PDO)
- Validación de sesión en todas las páginas
- Protección contra SQL injection
- Sanitización de datos de entrada

## 🔄 Actualizaciones Futuras Sugeridas

- [ ] Exportar historial a PDF
- [ ] Envío de recordatorios de citas por email/SMS
- [ ] Gráficos de evolución de signos vitales
- [ ] Recetas médicas imprimibles
- [ ] Gestión de inventario de medicamentos
- [ ] Reportes estadísticos
- [ ] Integración con laboratorios

## 📞 Soporte

Para soporte técnico o consultas:
- Revisar este README
- Verificar la configuración de la base de datos
- Revisar los logs de PHP y MySQL

## 📄 Licencia

Sistema desarrollado para uso interno del centro médico.

---

**Versión:** 1.0  
**Fecha:** 2025  
**Desarrollado con:** PHP, MySQL, HTML5, CSS3, JavaScript

