/**
 * Script de Interactividad - Tutorial Agua Mineral
 */

// Navegación entre secciones
document.querySelectorAll('.nav-link').forEach(link => {
    link.addEventListener('click', (e) => {
        e.preventDefault();
        const section = link.getAttribute('data-section');
        navigateToSection(section);
    });
});

function navigateToSection(sectionId) {
    // Ocultar todas las secciones
    document.querySelectorAll('.section').forEach(section => {
        section.classList.remove('active');
    });

    // Mostrar la sección seleccionada
    const selectedSection = document.getElementById(sectionId);
    if (selectedSection) {
        selectedSection.classList.add('active');
    }

    // Actualizar el enlace activo en la navbar
    document.querySelectorAll('.nav-link').forEach(link => {
        link.classList.remove('active');
    });
    document.querySelector(`[data-section="${sectionId}"]`).classList.add('active');

    // Scroll al inicio
    window.scrollTo(0, 0);
}

// Toggle para abrir/cerrar pasos del tutorial
function toggleStep(headerElement) {
    const step = headerElement.closest('.step');
    step.classList.toggle('open');
}

// Toggle para abrir/cerrar preguntas FAQ
function toggleFAQ(questionElement) {
    const faqItem = questionElement.closest('.faq-item');
    faqItem.classList.toggle('open');
}

// Cerrar otros pasos cuando se abre uno nuevo (opcional)
document.querySelectorAll('.step-header').forEach(header => {
    header.addEventListener('click', function() {
        const currentSection = this.closest('.section');
        const allSteps = currentSection.querySelectorAll('.step');
        
        // Descomenta la siguiente línea si deseas que solo un paso esté abierto a la vez
        // allSteps.forEach(step => {
        //     if (step !== this.closest('.step')) {
        //         step.classList.remove('open');
        //     }
        // });
    });
});

// Cerrar otros FAQs cuando se abre uno nuevo (opcional)
document.querySelectorAll('.faq-question').forEach(question => {
    question.addEventListener('click', function() {
        const allFAQs = document.querySelectorAll('.faq-item');
        
        // Descomenta la siguiente línea si deseas que solo un FAQ esté abierto a la vez
        // allFAQs.forEach(faq => {
        //     if (faq !== this.closest('.faq-item')) {
        //         faq.classList.remove('open');
        //     }
        // });
    });
});

// Abrir automáticamente el primer paso de cada sección
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.section').forEach(section => {
        const firstStep = section.querySelector('.step');
        if (firstStep) {
            firstStep.classList.add('open');
        }
    });

    // Agregar animación de scroll suave
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth'
                });
            }
        });
    });
});

// Función para resaltar código (si es necesario)
function highlightCode() {
    document.querySelectorAll('code').forEach(block => {
        block.style.backgroundColor = '#f4f4f4';
        block.style.padding = '2px 6px';
        block.style.borderRadius = '3px';
        block.style.fontFamily = 'monospace';
    });
}

// Llamar a la función de resaltado
highlightCode();

// Agregar soporte para teclado (navegación con flechas)
document.addEventListener('keydown', function(event) {
    if (event.key === 'ArrowRight') {
        const nextLink = document.querySelector('.nav-link.active').parentElement.nextElementSibling;
        if (nextLink) {
            const nextSection = nextLink.querySelector('.nav-link');
            if (nextSection) {
                nextSection.click();
            }
        }
    } else if (event.key === 'ArrowLeft') {
        const prevLink = document.querySelector('.nav-link.active').parentElement.previousElementSibling;
        if (prevLink) {
            const prevSection = prevLink.querySelector('.nav-link');
            if (prevSection) {
                prevSection.click();
            }
        }
    }
});

// Función para imprimir la página
function printTutorial() {
    window.print();
}

// Función para compartir en redes sociales (opcional)
function shareOnSocial(platform) {
    const url = window.location.href;
    const title = 'Tutorial Interactivo - Sistema de Gestión de Agua Mineral';
    
    let shareUrl = '';
    
    switch(platform) {
        case 'facebook':
            shareUrl = `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`;
            break;
        case 'twitter':
            shareUrl = `https://twitter.com/intent/tweet?url=${encodeURIComponent(url)}&text=${encodeURIComponent(title)}`;
            break;
        case 'whatsapp':
            shareUrl = `https://wa.me/?text=${encodeURIComponent(title + ' ' + url)}`;
            break;
    }
    
    if (shareUrl) {
        window.open(shareUrl, '_blank');
    }
}

// Agregar efecto de carga
window.addEventListener('load', function() {
    document.body.style.opacity = '1';
});

// Inicializar la página
console.log('Tutorial Interactivo - Sistema de Gestión de Agua Mineral cargado exitosamente');
