<?php
/**
 * Endpoint para Exportaciones
 * Sistema de Gestión de Agua Mineral
 */

require_once '../../includes/init.php';
require_once '../../includes/ExcelExporter.php';

// Verificar que sea administrador
checkPermission('administrador');

// Obtener parámetros
$tipo = $_GET['tipo'] ?? '';
$formato = $_GET['formato'] ?? 'excel';
$fechaInicio = $_GET['fecha_inicio'] ?? date('Y-m-01');
$fechaFin = $_GET['fecha_fin'] ?? date('Y-m-t');
$vendedorId = $_GET['vendedor_id'] ?? '';
$clienteId = $_GET['cliente_id'] ?? '';

// Log de actividad
logActivity($_SESSION['user_id'], 'export_report', "Exportación: $tipo ($formato)");

try {
    switch ($tipo) {
        case 'ventas_detalle':
            if ($formato === 'excel') {
                ExcelExporter::exportVentasDetalle($fechaInicio, $fechaFin, $vendedorId, $clienteId);
            }
            break;
            
        case 'ventas_por_cliente':
            if ($formato === 'excel') {
                ExcelExporter::exportVentasPorCliente($fechaInicio, $fechaFin, $vendedorId);
            }
            break;
            
        case 'saldos_clientes':
            if ($formato === 'excel') {
                ExcelExporter::exportSaldosClientes($vendedorId);
            }
            break;
            
        default:
            throw new Exception('Tipo de reporte no válido');
    }
    
} catch (Exception $e) {
    // En caso de error, redirigir con mensaje
    setFlashMessage('Error al generar la exportación: ' . $e->getMessage(), 'error');
    redirect('reportes.php');
}
?>
