# Tutorial Interactivo - Sistema de Administración de Veterinaria

## 📚 Descripción

Este es un **tutorial interactivo completo** en HTML/CSS/JavaScript que guía a los usuarios a través de todas las funcionalidades del sistema de administración de veterinaria. El tutorial está diseñado para ser fácil de usar, visualmente atractivo y completamente autónomo.

## 🎯 Características

- ✅ **Tres módulos principales**: Administrador, Colaborador y Paciente
- ✅ **Diseño responsivo**: Funciona en desktop, tablet y móvil
- ✅ **Simulaciones interactivas**: Formularios de ejemplo para cada módulo
- ✅ **Navegación fluida**: Tabs, botones y enlaces intuitivos
- ✅ **Sin dependencias externas**: Solo HTML, CSS y JavaScript puro
- ✅ **Paleta de colores personalizada**: Diseño "Huellas Digitales" con colores pastel

## 📁 Estructura de Archivos

```
tutorial_html/
├── index.html                    # Página principal
├── css/
│   └── style.css                # Estilos globales
├── js/
│   └── script.js                # Funcionalidad interactiva
├── pages/
│   ├── modulo-admin.html        # Módulo Administrador
│   ├── modulo-colaborador.html  # Módulo Colaborador
│   └── modulo-paciente.html     # Módulo Paciente
├── images/
│   └── (imágenes del tutorial)
└── README.md                     # Este archivo
```

## 🚀 Cómo Usar

### Opción 1: Abrir directamente en el navegador
1. Descargue y extraiga el archivo `tutorial_html.zip`
2. Haga doble clic en `index.html` para abrir en su navegador predeterminado
3. ¡Listo! El tutorial se cargará completamente

### Opción 2: Usar un servidor local (recomendado)

**Con Python 3:**
```bash
cd tutorial_html
python -m http.server 8000
```
Luego abra `http://localhost:8000` en su navegador

**Con PHP:**
```bash
cd tutorial_html
php -S localhost:8000
```
Luego abra `http://localhost:8000` en su navegador

**Con Node.js (http-server):**
```bash
npm install -g http-server
cd tutorial_html
http-server
```

## 📖 Contenido del Tutorial

### 🏠 Página Principal (index.html)
- Bienvenida y descripción general
- Tres tarjetas interactivas de módulos
- Tabs con características principales
- Llamada a la acción para comenzar

### 👤 Módulo Administrador (modulo-admin.html)
- Gestión de colaboradores
- Catálogos (tratamientos y medicamentos)
- Creación de promociones
- Sistema de reportes
- Simulación interactiva para crear promociones

### 🧑‍⚕️ Módulo Colaborador (modulo-colaborador.html)
- Flujo de trabajo recomendado
- Gestión de dueños y mascotas
- Registro de visitas
- Generación de documentos
- Simulaciones para crear dueño, mascota y visita

### ❤️ Módulo Paciente (modulo-paciente.html)
- Acceso al portal
- Visualización de mascotas
- Historial de vacunas
- Próximas citas
- Promociones disponibles

## 🎨 Diseño Visual

El tutorial utiliza la paleta de colores "Huellas Digitales":
- **Verde Menta** (#A7F3D0): Color primario
- **Azul Cielo** (#BAE6FD): Color secundario
- **Coral** (#FDA4AF): Color de acento
- **Gris Oscuro** (#1F2937): Texto principal
- **Gris Claro** (#F9FAFB): Fondo

## 💻 Funcionalidades Interactivas

### Tabs
Haga clic en los botones de tab para cambiar entre secciones sin recargar la página.

### Simulaciones de Formularios
Pruebe los formularios interactivos sin guardar datos reales:
- Crear Dueño
- Crear Mascota
- Nueva Visita
- Crear Promoción

### Navegación Suave
Todos los enlaces internos usan scroll suave para una experiencia más agradable.

## 🔧 Personalización

Puede personalizar fácilmente el tutorial editando los siguientes archivos:

### Cambiar colores
Edite las variables CSS en `css/style.css`:
```css
:root {
  --primary: #A7F3D0;      /* Cambiar color primario */
  --secondary: #BAE6FD;    /* Cambiar color secundario */
  --accent: #FDA4AF;       /* Cambiar color de acento */
}
```

### Cambiar contenido
Edite el HTML en cualquiera de las páginas `.html` para actualizar el contenido del tutorial.

### Agregar imágenes
Coloque las imágenes en la carpeta `images/` y referenciarlas en el HTML:
```html
<img src="images/nombre-imagen.png" alt="Descripción">
```

## 📱 Compatibilidad

- ✅ Chrome/Chromium
- ✅ Firefox
- ✅ Safari
- ✅ Edge
- ✅ Navegadores móviles

## 🌐 Integración con el Sistema Real

Este tutorial puede integrarse fácilmente con el sistema real de veterinaria:

1. **Copie la carpeta** `tutorial_html` a la raíz de su servidor web
2. **Agregue un enlace** en el menú principal: `<a href="/tutorial_html/">Tutorial</a>`
3. **Actualice los datos** en el tutorial si el sistema cambia

## 📝 Notas Importantes

- El tutorial es **completamente estático** y no requiere base de datos
- Las simulaciones de formularios **no guardan datos reales**
- Todos los datos se muestran solo como **ejemplos educativos**
- El tutorial es **totalmente personalizable** según sus necesidades

## 🎓 Cómo Usar el Tutorial

### Para Administradores
1. Abra el tutorial
2. Haga clic en "Módulo Administrador"
3. Siga los pasos para aprender a gestionar colaboradores, catálogos y promociones
4. Pruebe las simulaciones interactivas

### Para Colaboradores
1. Abra el tutorial
2. Haga clic en "Módulo Colaborador"
3. Siga el flujo de trabajo recomendado
4. Pruebe las simulaciones para crear dueños, mascotas y visitas

### Para Pacientes
1. Abra el tutorial
2. Haga clic en "Módulo Paciente"
3. Vea cómo acceder al portal y consultar información
4. Explore las diferentes secciones disponibles

## 📞 Soporte

Si tiene preguntas sobre el tutorial o necesita personalizaciones adicionales, contacte al equipo de desarrollo.

## 📄 Licencia

Este tutorial es parte del Sistema de Administración de Veterinaria v1.4.1

---

**Versión**: 1.0  
**Última actualización**: Enero 2026  
**Desarrollado por**: Manus AI
