# Guía de Usuario - Sistema de Rendición de Cuentas ONG

## Introducción

Este sistema permite gestionar de forma transparente los fondos asignados en organizaciones civiles (ONG's), manteniendo un control detallado de ingresos y egresos con comprobantes fotográficos.

## Acceso al Sistema

### Iniciar Sesión

1. Acceder a la URL del sistema en su navegador
2. Ingresar su **usuario** y **contraseña**
3. Hacer clic en **Iniciar Sesión**

**Credenciales por defecto del Administrador:**
- Usuario: `Rendicion`
- Contraseña: `cuentas2025`

> ⚠️ **Importante**: Cambiar la contraseña después del primer acceso.

## Roles y Permisos

### Administrador

El Administrador tiene acceso completo al sistema:

#### Gestión de Usuarios
- **Crear usuarios**: Puede crear Supervisores y Operativos
- **Asignar roles**: Define el rol de cada usuario
- **Desactivar usuarios**: Puede desactivar usuarios cuando sea necesario

**Pasos para crear un usuario:**
1. Ir a **Usuarios** en el menú lateral
2. Hacer clic en **Nuevo Usuario**
3. Completar los datos requeridos:
   - Usuario (nombre de acceso)
   - Contraseña
   - Nombre completo
   - Cédula/RUC/Pasaporte
   - Teléfono, Ciudad, Dirección
   - Rol (Administrador, Supervisor u Operativo)
   - Supervisor (solo para Operativos)
4. Hacer clic en **Guardar Usuario**

#### Asignación de Fondos
- **Asignar fondos a Supervisores**: Define el presupuesto de cada supervisor
- **Asignar fondos a Operativos**: Asigna directamente a operativos si es necesario

**Pasos para asignar fondos:**
1. Ir a **Asignar Fondos** en el menú lateral
2. Seleccionar el usuario destinatario
3. Ingresar el monto en Guaraníes (sin puntos ni comas)
4. Agregar una descripción (opcional)
5. Hacer clic en **Asignar Fondos**

#### Gestión de Categorías
- **Crear categorías**: Define categorías de Ingreso y Egreso
- **Desactivar categorías**: Oculta categorías que no se usan

**Pasos para crear una categoría:**
1. Ir a **Categorías** en el menú lateral
2. Hacer clic en **Nueva Categoría**
3. Ingresar nombre, tipo (Ingreso/Egreso) y descripción
4. Hacer clic en **Guardar Categoría**

#### Reportes y Exportación
- **Ver todos los movimientos**: Acceso completo al historial
- **Filtrar por fecha, usuario y tipo**: Búsqueda avanzada
- **Exportar a Excel**: Descarga en formato CSV compatible con Excel
- **Exportar a PDF**: Genera reporte en PDF

**Pasos para generar un reporte:**
1. Ir a **Reportes** en el menú lateral
2. Seleccionar filtros:
   - Fecha desde/hasta
   - Usuario específico (opcional)
   - Tipo de movimiento (opcional)
3. Hacer clic en el botón de búsqueda
4. Para exportar, hacer clic en **Exportar Excel** o **Exportar PDF**

### Supervisor

El Supervisor gestiona su equipo de operativos:

#### Gestión de Operativos
- **Crear usuarios Operativos**: Puede crear operativos bajo su supervisión
- **Asignar fondos a Operativos**: Distribuye su presupuesto entre operativos

**Pasos para crear un operativo:**
1. Ir a **Mis Operativos** en el menú lateral
2. Hacer clic en **Nuevo Operativo**
3. Completar los datos del operativo
4. El sistema automáticamente asigna al supervisor actual

**Pasos para asignar fondos a un operativo:**
1. Ir a **Asignar Fondos** en el menú lateral
2. Seleccionar el operativo
3. Ingresar el monto (debe ser menor o igual al saldo disponible)
4. Hacer clic en **Asignar Fondos**

#### Visualización
- **Dashboard**: Muestra su fondo asignado y saldo disponible
- **Movimientos**: Ve los movimientos de sus operativos
- **Reportes**: Genera reportes de su equipo

> 📊 **Nota**: El supervisor NO puede ver los fondos de otros supervisores.

### Operativo

El Operativo registra sus gastos:

#### Registrar Movimientos
- **Crear egresos**: Registra gastos con comprobantes
- **Adjuntar fotos**: Sube foto del comprobante desde cámara o galería

**Pasos para registrar un gasto:**
1. Ir a **Nuevo Movimiento** en el menú lateral
2. Seleccionar la **Categoría** del gasto
3. Ingresar la **Fecha** del gasto
4. Ingresar el **Monto** (solo números, el sistema agregará los separadores)
5. Escribir una **Descripción** detallada
6. **Adjuntar comprobante**:
   - En móvil: Tomar foto directamente
   - En computadora: Seleccionar archivo de imagen
7. Hacer clic en **Registrar Movimiento**

> ⚠️ **Importante**: 
> - El monto no puede superar el saldo disponible
> - Los movimientos NO se pueden modificar después de registrados
> - Siempre adjuntar comprobante fotográfico

#### Consultar Saldo
- **Dashboard**: Muestra fondo asignado, saldo disponible y total gastado
- **Mis Movimientos**: Historial completo de movimientos

**Visualización del saldo:**
- **Fondo Asignado**: Total recibido del supervisor
- **Saldo Disponible**: Monto que puede gastar
- **Total Gastado**: Suma de todos los egresos

> 📱 **Nota**: El operativo NO puede ver los fondos de otros operativos.

## Uso en Dispositivos Móviles

El sistema está optimizado para uso en teléfonos móviles:

### Características Móviles
- **Diseño responsive**: Se adapta automáticamente al tamaño de pantalla
- **Captura de fotos**: Acceso directo a la cámara del dispositivo
- **Navegación táctil**: Menús y botones optimizados para touch
- **Formato de números**: Separadores de miles para mejor lectura

### Consejos para Móviles
1. **Fotos de comprobantes**: 
   - Asegurar buena iluminación
   - Enfocar el documento completo
   - Evitar fotos borrosas
2. **Ingreso de montos**: 
   - Ingresar solo números
   - El sistema agregará puntos separadores automáticamente
3. **Conexión**: 
   - Preferir conexión WiFi para subir fotos
   - Guardar datos antes de perder conexión

## Moneda y Formato

El sistema utiliza **Guaraníes (Gs.)** como moneda:

### Formato de Números
- **Separador de miles**: Punto (.)
- **Ejemplos**:
  - 1.000 Gs.
  - 50.000 Gs.
  - 1.500.000 Gs.

### Ingreso de Montos
Al ingresar montos, escribir solo números:
- ✅ Correcto: `50000` → Se mostrará como `50.000`
- ❌ Incorrecto: `50.000` (no usar puntos al ingresar)

## Seguridad

### Buenas Prácticas
1. **Contraseñas seguras**: 
   - Mínimo 8 caracteres
   - Combinar letras, números y símbolos
2. **Cerrar sesión**: 
   - Siempre cerrar sesión al terminar
   - Especialmente en dispositivos compartidos
3. **Comprobantes**: 
   - Guardar comprobantes físicos
   - Fotos claras y legibles

### Protección de Datos
- Las contraseñas están encriptadas
- Solo usuarios autorizados acceden a la información
- Sistema de logs registra todas las acciones

## Solución de Problemas

### No puedo iniciar sesión
- Verificar usuario y contraseña
- Verificar que la cuenta esté activa
- Contactar al administrador

### No puedo registrar un movimiento
- Verificar que tenga saldo disponible
- Verificar que el monto sea válido
- Verificar que la imagen no sea muy pesada (máx. 10MB)

### No veo mis movimientos
- Actualizar la página (F5)
- Verificar que esté en la sección correcta
- Verificar conexión a internet

### La foto no se sube
- Verificar tamaño de archivo (máx. 10MB)
- Verificar formato (JPG, PNG, GIF)
- Verificar conexión a internet

## Contacto y Soporte

Para asistencia técnica o consultas:
- Contactar al Administrador del sistema
- Revisar la documentación técnica (README.md)

---

**Versión**: 1.0  
**Última actualización**: 2025  
**Sistema desarrollado para**: ONG's Paraguay

