<?php
/**
 * Página de confirmación de compra finalizada
 * Sistema de Supermercados y Tiendas V3.0
 */

require_once '../config/database.php';
require_once '../config/functions.php';

iniciarSesion();

if (!estaAutenticadoCliente()) {
    redirigir('../index.php');
}

$compraId = $_GET['compra_id'] ?? 0;
$cliente = obtenerClienteActual();

if (empty($compraId)) {
    redirigir('dashboard.php');
}

try {
    $db = getDB();
    
    // Obtener datos de la compra
    $stmt = $db->prepare("
        SELECT * 
        FROM compras 
        WHERE id = ? AND cliente_id = ? AND estado = 'finalizada'
    ");
    $stmt->execute([$compraId, $cliente['id']]);
    $compra = $stmt->fetch();
    
    if (!$compra) {
        redirigir('dashboard.php');
    }
    
    // Obtener items de la compra
    $stmt = $db->prepare("
        SELECT 
            dc.*,
            p.nombre,
            p.descripcion,
            p.imagen
        FROM detalle_compras dc
        INNER JOIN productos p ON dc.producto_id = p.id
        WHERE dc.compra_id = ?
        ORDER BY dc.id DESC
    ");
    $stmt->execute([$compraId]);
    $items = $stmt->fetchAll();
    
} catch (PDOException $e) {
    redirigir('dashboard.php');
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Compra Finalizada - Sistema de Tiendas V3.0</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body class="compra-finalizada-page">
    <div class="compra-finalizada-container">
        <div class="compra-finalizada-card">
            <div class="success-icon">✓</div>
            
            <h1>¡Compra Finalizada!</h1>
            <p class="mensaje-principal">Gracias por su compra, <?php echo htmlspecialchars($cliente['nombre']); ?></p>
            
            <div class="compra-resumen">
                <div class="resumen-header">
                    <h2>Resumen de Compra</h2>
                    <p class="fecha">
                        Fecha: <?php echo date('d/m/Y H:i', strtotime($compra['fecha_compra'])); ?>
                    </p>
                    <p class="compra-id">
                        ID de Compra: #<?php echo str_pad($compra['id'], 6, '0', STR_PAD_LEFT); ?>
                    </p>
                </div>
                
                <div class="items-lista">
                    <table class="tabla-compra">
                        <thead>
                            <tr>
                                <th>Producto</th>
                                <th>Cantidad</th>
                                <th>Precio Unit.</th>
                                <th>Subtotal</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($items as $item): ?>
                                <tr>
                                    <td>
                                        <div class="producto-nombre">
                                            <?php echo htmlspecialchars($item['nombre']); ?>
                                        </div>
                                    </td>
                                    <td class="text-center"><?php echo $item['cantidad']; ?></td>
                                    <td class="text-right"><?php echo formatearGuaranies($item['precio_unitario']); ?></td>
                                    <td class="text-right"><strong><?php echo formatearGuaranies($item['subtotal']); ?></strong></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr class="total-row">
                                <td colspan="3"><strong>TOTAL:</strong></td>
                                <td class="text-right"><strong class="total-monto"><?php echo formatearGuaranies($compra['total']); ?></strong></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
            
            <div class="instrucciones">
                <h3>Instrucciones</h3>
                <p>Por favor, diríjase a la caja con este resumen para completar el pago.</p>
                <p class="nota">Guarde esta información para cualquier consulta o controversia.</p>
            </div>
            
            <div class="acciones">
                <button class="btn btn-secondary" onclick="window.print()">
                    🖨️ Imprimir Ticket
                </button>
                <a href="dashboard.php" class="btn btn-primary btn-lg">
                    Nueva Compra
                </a>
            </div>
        </div>
    </div>
    
    <script src="../assets/js/main.js"></script>
    <style>
        @media print {
            .acciones, .dashboard-header {
                display: none !important;
            }
            .compra-finalizada-card {
                box-shadow: none !important;
                border: 1px solid #000 !important;
            }
        }
    </style>
</body>
</html>
