<?php
/**
 * API: Vaciar carrito completo
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$input = json_decode(file_get_contents('php://input'), true);
$compraId = $input['compra_id'] ?? 0;

if (empty($compraId)) {
    responderJSON(['success' => false, 'message' => 'ID de compra requerido'], 400);
}

try {
    $db = getDB();
    
    // Verificar que la compra pertenece al cliente
    $cliente = obtenerClienteActual();
    $stmt = $db->prepare("SELECT id FROM compras WHERE id = ? AND cliente_id = ? AND estado = 'activa'");
    $stmt->execute([$compraId, $cliente['id']]);
    
    if (!$stmt->fetch()) {
        responderJSON(['success' => false, 'message' => 'Compra no encontrada'], 404);
    }
    
    // Eliminar todos los items
    $stmt = $db->prepare("DELETE FROM detalle_compras WHERE compra_id = ?");
    $stmt->execute([$compraId]);
    
    // Actualizar total a 0
    $stmt = $db->prepare("UPDATE compras SET total = 0 WHERE id = ?");
    $stmt->execute([$compraId]);
    
    responderJSON([
        'success' => true,
        'message' => 'Carrito vaciado'
    ]);
    
} catch (PDOException $e) {
    responderJSON([
        'success' => false,
        'message' => 'Error al vaciar carrito'
    ], 500);
}
?>
