<?php
/**
 * API: Obtener última compra finalizada
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

try {
    $db = getDB();
    $cliente = obtenerClienteActual();
    
    // Obtener última compra finalizada
    $stmt = $db->prepare("
        SELECT * 
        FROM compras 
        WHERE cliente_id = ? AND estado = 'finalizada'
        ORDER BY fecha_compra DESC
        LIMIT 1
    ");
    $stmt->execute([$cliente['id']]);
    $compra = $stmt->fetch();
    
    if (!$compra) {
        responderJSON(['success' => false, 'message' => 'No hay compras anteriores'], 404);
    }
    
    // Obtener items de la compra
    $stmt = $db->prepare("
        SELECT 
            dc.*,
            p.nombre,
            p.descripcion
        FROM detalle_compras dc
        INNER JOIN productos p ON dc.producto_id = p.id
        WHERE dc.compra_id = ?
        ORDER BY dc.id DESC
    ");
    $stmt->execute([$compra['id']]);
    $items = $stmt->fetchAll();
    
    responderJSON([
        'success' => true,
        'compra' => $compra,
        'items' => $items
    ]);
    
} catch (PDOException $e) {
    responderJSON([
        'success' => false,
        'message' => 'Error al obtener última compra'
    ], 500);
}
?>
