<?php
/**
 * API: Finalizar compra
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$input = json_decode(file_get_contents('php://input'), true);
$compraId = $input['compra_id'] ?? 0;

if (empty($compraId)) {
    responderJSON(['success' => false, 'message' => 'ID de compra requerido'], 400);
}

try {
    $db = getDB();
    
    // Verificar que la compra pertenece al cliente
    $cliente = obtenerClienteActual();
    $stmt = $db->prepare("
        SELECT c.*, COUNT(dc.id) as total_items
        FROM compras c
        LEFT JOIN detalle_compras dc ON c.id = dc.compra_id
        WHERE c.id = ? AND c.cliente_id = ? AND c.estado = 'activa'
        GROUP BY c.id
    ");
    $stmt->execute([$compraId, $cliente['id']]);
    $compra = $stmt->fetch();
    
    if (!$compra) {
        responderJSON(['success' => false, 'message' => 'Compra no encontrada'], 404);
    }
    
    if ($compra['total_items'] == 0) {
        responderJSON(['success' => false, 'message' => 'El carrito está vacío'], 400);
    }
    
    // Cambiar estado de la compra a finalizada
    $stmt = $db->prepare("UPDATE compras SET estado = 'finalizada' WHERE id = ?");
    $stmt->execute([$compraId]);
    
    responderJSON([
        'success' => true,
        'message' => 'Compra finalizada exitosamente',
        'compra_id' => $compraId
    ]);
    
} catch (PDOException $e) {
    responderJSON([
        'success' => false,
        'message' => 'Error al finalizar compra'
    ], 500);
}
?>
