<?php
/**
 * API: Eliminar item del carrito
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$input = json_decode(file_get_contents('php://input'), true);
$detalleId = $input['detalle_id'] ?? 0;

if (empty($detalleId)) {
    responderJSON(['success' => false, 'message' => 'ID de detalle requerido'], 400);
}

try {
    $db = getDB();
    
    // Verificar que el item pertenece al cliente
    $stmt = $db->prepare("
        SELECT dc.compra_id, c.cliente_id
        FROM detalle_compras dc
        INNER JOIN compras c ON dc.compra_id = c.id
        WHERE dc.id = ? AND c.estado = 'activa'
    ");
    $stmt->execute([$detalleId]);
    $detalle = $stmt->fetch();
    
    if (!$detalle) {
        responderJSON(['success' => false, 'message' => 'Item no encontrado'], 404);
    }
    
    $cliente = obtenerClienteActual();
    if ($detalle['cliente_id'] != $cliente['id']) {
        responderJSON(['success' => false, 'message' => 'No autorizado'], 403);
    }
    
    // Eliminar el item
    $stmt = $db->prepare("DELETE FROM detalle_compras WHERE id = ?");
    $stmt->execute([$detalleId]);
    
    // Actualizar total de la compra
    $stmt = $db->prepare("
        UPDATE compras 
        SET total = (
            SELECT COALESCE(SUM(subtotal), 0) 
            FROM detalle_compras 
            WHERE compra_id = ?
        )
        WHERE id = ?
    ");
    $stmt->execute([$detalle['compra_id'], $detalle['compra_id']]);
    
    responderJSON([
        'success' => true,
        'message' => 'Item eliminado'
    ]);
    
} catch (PDOException $e) {
    responderJSON([
        'success' => false,
        'message' => 'Error al eliminar item'
    ], 500);
}
?>
