<?php
/**
 * API: Buscar producto por código de barras
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoCliente()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$input = json_decode(file_get_contents('php://input'), true);
$codigoBarras = $input['codigo_barras'] ?? '';

if (empty($codigoBarras)) {
    responderJSON(['success' => false, 'message' => 'Código de barras requerido'], 400);
}

try {
    $db = getDB();
    $stmt = $db->prepare("
        SELECT id, codigo_barras, nombre, descripcion, precio, stock, imagen, categoria
        FROM productos 
        WHERE codigo_barras = ? AND activo = 1
    ");
    $stmt->execute([$codigoBarras]);
    $producto = $stmt->fetch();
    
    if ($producto) {
        responderJSON([
            'success' => true,
            'producto' => $producto
        ]);
    } else {
        responderJSON([
            'success' => false,
            'message' => 'Producto no encontrado'
        ], 404);
    }
} catch (PDOException $e) {
    // Log del error para debugging
    error_log("Error en buscar_producto.php: " . $e->getMessage());
    
    responderJSON([
        'success' => false,
        'message' => 'Error al buscar producto: ' . $e->getMessage(),
        'error_details' => $e->getMessage()
    ], 500);
} catch (Exception $e) {
    error_log("Error general en buscar_producto.php: " . $e->getMessage());
    
    responderJSON([
        'success' => false,
        'message' => 'Error general: ' . $e->getMessage()
    ], 500);
}
?>
