<?php
/**
 * API: Guardar usuario administrativo
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$admin = obtenerAdminActual();
if ($admin['rol'] !== 'administrador') {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$id = $_POST['id'] ?? null;
$username = sanitizar($_POST['username'] ?? '');
$nombre = sanitizar($_POST['nombre'] ?? '');
$password = $_POST['password'] ?? '';
$rol = sanitizar($_POST['rol'] ?? 'colaborador');
$activo = $_POST['activo'] ?? 1;

if (empty($username) || empty($nombre)) {
    responderJSON(['success' => false, 'message' => 'Campos requeridos'], 400);
}

try {
    $db = getDB();
    
    if ($id) {
        // Actualizar
        if (!empty($password)) {
            $passwordHash = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $db->prepare("
                UPDATE usuarios_admin 
                SET username = ?, nombre = ?, password = ?, rol = ?, activo = ?
                WHERE id = ?
            ");
            $stmt->execute([$username, $nombre, $passwordHash, $rol, $activo, $id]);
        } else {
            $stmt = $db->prepare("
                UPDATE usuarios_admin 
                SET username = ?, nombre = ?, rol = ?, activo = ?
                WHERE id = ?
            ");
            $stmt->execute([$username, $nombre, $rol, $activo, $id]);
        }
    } else {
        // Crear
        if (empty($password)) {
            responderJSON(['success' => false, 'message' => 'Contraseña requerida'], 400);
        }
        
        $stmt = $db->prepare("SELECT id FROM usuarios_admin WHERE username = ?");
        $stmt->execute([$username]);
        if ($stmt->fetch()) {
            responderJSON(['success' => false, 'message' => 'Usuario ya existe'], 400);
        }
        
        $passwordHash = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $db->prepare("
            INSERT INTO usuarios_admin (username, nombre, password, rol, activo)
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$username, $nombre, $passwordHash, $rol, $activo]);
    }
    
    responderJSON(['success' => true, 'message' => 'Usuario guardado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al guardar'], 500);
}
?>
