<?php
/**
 * API: Guardar promoción
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

if (!tienePermiso('gestionar_promociones')) {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$admin = obtenerAdminActual();
$id = $_POST['id'] ?? null;
$titulo = sanitizar($_POST['titulo'] ?? '');
$descripcion = sanitizar($_POST['descripcion'] ?? '');
$fecha_inicio = $_POST['fecha_inicio'] ?? date('Y-m-d H:i:s');
$fecha_fin = $_POST['fecha_fin'] ?? null;
$activo = $_POST['activo'] ?? 1;

if (empty($titulo)) {
    responderJSON(['success' => false, 'message' => 'Título requerido'], 400);
}

try {
    $db = getDB();
    
    $rutaImagen = null;
    if (isset($_FILES['imagen']) && $_FILES['imagen']['error'] === UPLOAD_ERR_OK) {
        $resultado = subirImagen($_FILES['imagen'], 'uploads/promociones/');
        if (isset($resultado['success'])) {
            $rutaImagen = $resultado['ruta'];
        }
    }
    
    if ($id) {
        $sql = "UPDATE promociones SET titulo = ?, descripcion = ?, fecha_inicio = ?, fecha_fin = ?, activo = ?";
        $params = [$titulo, $descripcion, $fecha_inicio, $fecha_fin, $activo];
        
        if ($rutaImagen) {
            $sql .= ", imagen = ?";
            $params[] = $rutaImagen;
        }
        
        $sql .= " WHERE id = ?";
        $params[] = $id;
        
        $stmt = $db->prepare($sql);
        $stmt->execute($params);
    } else {
        $stmt = $db->prepare("
            INSERT INTO promociones (titulo, descripcion, imagen, fecha_inicio, fecha_fin, activo, creado_por)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$titulo, $descripcion, $rutaImagen, $fecha_inicio, $fecha_fin, $activo, $admin['id']]);
    }
    
    responderJSON(['success' => true, 'message' => 'Promoción guardada']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al guardar'], 500);
}
?>
