<?php
/**
 * API: Guardar cliente (actualizar)
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

if (!tienePermiso('gestionar_clientes')) {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? 0;
$nombre = sanitizar($input['nombre'] ?? '');
$apellido = sanitizar($input['apellido'] ?? '');
$telefono = sanitizar($input['telefono'] ?? '');
$ciudad = sanitizar($input['ciudad'] ?? '');

if (empty($id) || empty($nombre) || empty($apellido)) {
    responderJSON(['success' => false, 'message' => 'Campos requeridos incompletos'], 400);
}

try {
    $db = getDB();
    
    $stmt = $db->prepare("
        UPDATE clientes 
        SET nombre = ?, apellido = ?, telefono = ?, ciudad = ?
        WHERE id = ?
    ");
    
    $stmt->execute([$nombre, $apellido, $telefono, $ciudad, $id]);
    
    responderJSON(['success' => true, 'message' => 'Cliente actualizado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al actualizar cliente'], 500);
}
?>
