<?php
/**
 * API: Eliminar usuario administrativo
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

$admin = obtenerAdminActual();
if ($admin['rol'] !== 'administrador') {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? 0;

if (empty($id)) {
    responderJSON(['success' => false, 'message' => 'ID requerido'], 400);
}

if ($id == $admin['id']) {
    responderJSON(['success' => false, 'message' => 'No puede eliminarse a sí mismo'], 400);
}

try {
    $db = getDB();
    
    $stmt = $db->prepare("DELETE FROM usuarios_admin WHERE id = ?");
    $stmt->execute([$id]);
    
    responderJSON(['success' => true, 'message' => 'Usuario eliminado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al eliminar'], 500);
}
?>
