<?php
/**
 * API: Eliminar producto
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

if (!tienePermiso('eliminar')) {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? 0;

if (empty($id)) {
    responderJSON(['success' => false, 'message' => 'ID requerido'], 400);
}

try {
    $db = getDB();
    
    // Verificar que el producto existe
    $stmt = $db->prepare("SELECT id FROM productos WHERE id = ?");
    $stmt->execute([$id]);
    if (!$stmt->fetch()) {
        responderJSON(['success' => false, 'message' => 'Producto no encontrado'], 404);
    }
    
    // Eliminar producto
    $stmt = $db->prepare("DELETE FROM productos WHERE id = ?");
    $stmt->execute([$id]);
    
    responderJSON(['success' => true, 'message' => 'Producto eliminado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al eliminar producto'], 500);
}
?>
