<?php
/**
 * API: Eliminar cliente
 */

require_once '../../config/database.php';
require_once '../../config/functions.php';

header('Content-Type: application/json; charset=utf-8');

iniciarSesion();

if (!estaAutenticadoAdmin()) {
    responderJSON(['success' => false, 'message' => 'No autenticado'], 401);
}

if (!tienePermiso('eliminar')) {
    responderJSON(['success' => false, 'message' => 'No tiene permisos'], 403);
}

$input = json_decode(file_get_contents('php://input'), true);
$id = $input['id'] ?? 0;

if (empty($id)) {
    responderJSON(['success' => false, 'message' => 'ID requerido'], 400);
}

try {
    $db = getDB();
    
    $stmt = $db->prepare("SELECT id FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    if (!$stmt->fetch()) {
        responderJSON(['success' => false, 'message' => 'Cliente no encontrado'], 404);
    }
    
    $stmt = $db->prepare("DELETE FROM clientes WHERE id = ?");
    $stmt->execute([$id]);
    
    responderJSON(['success' => true, 'message' => 'Cliente eliminado']);
    
} catch (PDOException $e) {
    responderJSON(['success' => false, 'message' => 'Error al eliminar cliente'], 500);
}
?>
