# Solución al Error de Apache: "client denied by server configuration"

## 🔴 Error Identificado

```
AH01797: client denied by server configuration: /var/www/vhosts/distec.com.py/httpdocs/
```

Este error indica que Apache está **bloqueando el acceso** al directorio del proyecto.

---

## ✅ Soluciones (en orden de prioridad)

### Solución 1: Agregar archivo .htaccess

He creado un archivo `.htaccess` en el proyecto que permite el acceso. 

**Pasos:**
1. Copiar el archivo `.htaccess` incluido en el proyecto
2. Colocarlo en el directorio raíz: `/var/www/vhosts/distec.com.py/httpdocs/`
3. Verificar que Apache tenga permisos de lectura:
   ```bash
   chmod 644 /var/www/vhosts/distec.com.py/httpdocs/.htaccess
   ```

---

### Solución 2: Modificar configuración del VirtualHost

Editar el archivo de configuración del VirtualHost de Apache.

**Ubicación típica:**
- `/etc/apache2/sites-available/distec.com.py.conf`
- `/etc/httpd/conf.d/vhost_distec.com.py.conf`
- En Plesk: Panel de control → Dominios → Configuración de Apache

**Configuración correcta:**

```apache
<VirtualHost *:80>
    ServerName distec.com.py
    ServerAlias www.distec.com.py
    DocumentRoot /var/www/vhosts/distec.com.py/httpdocs
    
    <Directory /var/www/vhosts/distec.com.py/httpdocs>
        # Apache 2.4+
        Require all granted
        
        # Apache 2.2 (si usas versión antigua)
        # Order allow,deny
        # Allow from all
        
        AllowOverride All
        Options -Indexes +FollowSymLinks
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/distec.com.py-error.log
    CustomLog ${APACHE_LOG_DIR}/distec.com.py-access.log combined
</VirtualHost>
```

**Aplicar cambios:**
```bash
sudo systemctl restart apache2
# o en CentOS/RHEL:
sudo systemctl restart httpd
```

---

### Solución 3: Verificar permisos de archivos

**Permisos correctos:**

```bash
# Cambiar propietario (reemplazar 'www-data' por tu usuario de Apache)
sudo chown -R www-data:www-data /var/www/vhosts/distec.com.py/httpdocs/

# Permisos de directorios
sudo find /var/www/vhosts/distec.com.py/httpdocs/ -type d -exec chmod 755 {} \;

# Permisos de archivos
sudo find /var/www/vhosts/distec.com.py/httpdocs/ -type f -exec chmod 644 {} \;

# Permisos especiales para directorios de escritura
sudo chmod -R 775 /var/www/vhosts/distec.com.py/httpdocs/uploads/
sudo chmod -R 775 /var/www/vhosts/distec.com.py/httpdocs/logs/
```

**En CentOS/RHEL (usuario httpd):**
```bash
sudo chown -R apache:apache /var/www/vhosts/distec.com.py/httpdocs/
```

---

### Solución 4: Verificar SELinux (solo CentOS/RHEL)

Si usas CentOS/RHEL, SELinux puede estar bloqueando:

```bash
# Verificar estado de SELinux
getenforce

# Si está en "Enforcing", configurar contexto correcto:
sudo chcon -R -t httpd_sys_content_t /var/www/vhosts/distec.com.py/httpdocs/
sudo chcon -R -t httpd_sys_rw_content_t /var/www/vhosts/distec.com.py/httpdocs/uploads/
sudo chcon -R -t httpd_sys_rw_content_t /var/www/vhosts/distec.com.py/httpdocs/logs/

# Permitir conexiones de red (si usas MySQL remoto)
sudo setsebool -P httpd_can_network_connect_db 1
```

---

### Solución 5: Configuración para Plesk

Si usas **Plesk**, sigue estos pasos:

1. **Acceder al panel de Plesk**
2. **Dominios** → Seleccionar `distec.com.py`
3. **Configuración de Apache y nginx**
4. **Directivas adicionales de Apache**:

```apache
<Directory /var/www/vhosts/distec.com.py/httpdocs>
    Require all granted
    AllowOverride All
    Options -Indexes +FollowSymLinks
</Directory>
```

5. **Aplicar cambios**
6. **Reiniciar servicios web**

---

## 🔍 Verificar la Solución

Después de aplicar cualquiera de las soluciones:

```bash
# Ver logs de error de Apache
sudo tail -f /var/log/apache2/error.log
# o
sudo tail -f /var/log/httpd/error_log

# Verificar configuración de Apache
sudo apache2ctl configtest
# o
sudo httpd -t

# Reiniciar Apache
sudo systemctl restart apache2
# o
sudo systemctl restart httpd
```

---

## 📋 Checklist de Verificación

- [ ] Archivo `.htaccess` copiado al directorio raíz
- [ ] Permisos de archivos correctos (755 para directorios, 644 para archivos)
- [ ] Propietario correcto (www-data o apache)
- [ ] Configuración de VirtualHost actualizada
- [ ] `AllowOverride All` habilitado
- [ ] `Require all granted` en la configuración
- [ ] SELinux configurado (si aplica)
- [ ] Apache reiniciado
- [ ] Sin errores en logs

---

## 🆘 Si el Problema Persiste

**Verificar módulos de Apache necesarios:**

```bash
# Habilitar mod_rewrite
sudo a2enmod rewrite

# Habilitar mod_headers
sudo a2enmod headers

# Reiniciar Apache
sudo systemctl restart apache2
```

**Verificar configuración global de Apache:**

Editar `/etc/apache2/apache2.conf` (o `/etc/httpd/conf/httpd.conf`):

```apache
<Directory /var/www/>
    Options Indexes FollowSymLinks
    AllowOverride All
    Require all granted
</Directory>
```

---

## 📞 Soporte Adicional

Si después de aplicar estas soluciones el problema persiste:

1. **Verificar logs completos**:
   ```bash
   sudo tail -100 /var/log/apache2/error.log
   ```

2. **Verificar versión de Apache**:
   ```bash
   apache2 -v
   # o
   httpd -v
   ```

3. **Verificar configuración activa**:
   ```bash
   apache2ctl -S
   # o
   httpd -S
   ```

---

## ✅ Configuración Recomendada Final

**Estructura de directorios:**
```
/var/www/vhosts/distec.com.py/
├── httpdocs/                    (DocumentRoot)
│   ├── .htaccess               (Require all granted)
│   ├── index.php
│   ├── admin/
│   ├── cliente/
│   ├── config/
│   ├── assets/
│   ├── uploads/                (775 permisos)
│   └── logs/                   (775 permisos)
```

**Permisos finales:**
- Directorios: `755` (drwxr-xr-x)
- Archivos PHP: `644` (-rw-r--r--)
- Uploads/Logs: `775` (drwxrwxr-x)
- Propietario: `www-data:www-data` (o `apache:apache`)

---

¡Con estas soluciones deberías poder resolver el error de Apache! 🎉
