# Sistema de Supermercados y Tiendas V3.0

Sistema completo de autoservicio para supermercados y tiendas con lector de código de barras, carrito de compras y panel de administración con roles diferenciados.

## Características Principales

### Módulo de Cliente

- **Autenticación por Cédula/RUC**: Sistema de identificación rápida de clientes
- **Registro Automático**: Formulario de registro para nuevos clientes
- **Dashboard Interactivo**: Interfaz dividida en dos paneles (productos y carrito)
- **Lector de Código de Barras**: Integración con cámara para escaneo de productos
- **Carrito de Compras Dinámico**: Gestión completa de productos (agregar, modificar cantidad, eliminar)
- **Historial de Compras**: Visualización de compras anteriores
- **Promociones Rotativas**: Anuncios que se actualizan cada 10 segundos
- **Feedback Sonoro**: Sonido al agregar productos al carrito
- **Responsive Design**: Optimizado para tablets y móviles

### Panel de Administración

- **Dashboard con Gráficos**: Visualización de estadísticas y métricas de ventas
- **Sistema de Roles**: Tres niveles de acceso (Administrador, Comercial, Colaborador)
- **Gestión de Productos**: CRUD completo con código de barras
- **Gestión de Clientes**: Administración de base de datos de clientes
- **Gestión de Promociones**: Creación y administración de ofertas
- **Mensajes Emergentes**: Sistema de notificaciones para clientes
- **Reportes**: Análisis de ventas y productos más vendidos
- **Interfaz Moderna**: Diseño agradable con gráficos interactivos

## Requisitos del Sistema

### Servidor

- PHP 7.4 o superior
- MySQL 8.0 o superior
- Apache 2.4 o Nginx
- Extensiones PHP: pdo, pdo_mysql, mbstring, gd

### Cliente

- Navegador moderno (Chrome, Firefox, Safari, Edge)
- Cámara web o cámara de dispositivo móvil (para lector de código de barras)
- JavaScript habilitado

## Instalación

### 1. Configurar Base de Datos

```bash
# Ejecutar el script SQL de inicialización
mysql -u root -p < database_setup.sql
```

### 2. Configurar Permisos

```bash
# Dar permisos de escritura a directorios de uploads y logs
chmod 755 uploads/
chmod 755 logs/
chmod 644 logs/sistema.log
```

### 3. Configurar Apache/Nginx

#### Apache

```apache
<VirtualHost *:80>
    ServerName tiendas.local
    DocumentRoot /ruta/a/tiendas_v3
    
    <Directory /ruta/a/tiendas_v3>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

#### Nginx

```nginx
server {
    listen 80;
    server_name tiendas.local;
    root /ruta/a/tiendas_v3;
    index index.php;
    
    location / {
        try_files $uri $uri/ /index.php?$query_string;
    }
    
    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php/php8.1-fpm.sock;
        fastcgi_index index.php;
        include fastcgi_params;
    }
}
```

### 4. Configurar Hosts (Opcional)

```bash
# Agregar al archivo /etc/hosts
127.0.0.1 tiendas.local
```

## Credenciales por Defecto

### Panel de Administración

- **Usuario**: Tiendas
- **Contraseña**: 2025

### Base de Datos

- **Nombre**: tiendabd
- **Usuario**: tiendas2025
- **Contraseña**: product@s.py

## Estructura de Directorios

```
tiendas_v3/
├── admin/                  # Panel de administración
│   ├── api/               # APIs del admin
│   ├── includes/          # Componentes reutilizables
│   ├── dashboard.php      # Dashboard principal
│   ├── productos.php      # Gestión de productos
│   ├── clientes.php       # Gestión de clientes
│   ├── promociones.php    # Gestión de promociones
│   └── login.php          # Login de administradores
├── cliente/               # Módulo de clientes
│   ├── api/              # APIs del cliente
│   ├── dashboard.php     # Dashboard del cliente
│   ├── registro.php      # Registro de nuevos clientes
│   ├── bienvenida.php    # Pantalla de bienvenida
│   └── logout.php        # Cerrar sesión
├── config/               # Configuración
│   ├── database.php      # Conexión a base de datos
│   └── functions.php     # Funciones auxiliares
├── assets/               # Recursos estáticos
│   ├── css/             # Hojas de estilo
│   ├── js/              # JavaScript
│   ├── images/          # Imágenes
│   └── sounds/          # Sonidos
├── uploads/             # Archivos subidos
│   ├── productos/       # Imágenes de productos
│   └── promociones/     # Imágenes de promociones
├── logs/                # Logs del sistema
├── index.php            # Página principal
└── README.md            # Este archivo
```

## Roles y Permisos

### Administrador

- Acceso completo al sistema
- Crear, modificar y eliminar cualquier contenido
- Gestionar usuarios administrativos
- Gestionar clientes
- Ver todos los reportes

### Comercial

- Gestionar productos (crear, modificar, eliminar)
- Gestionar promociones
- Enviar mensajes emergentes
- Ver reportes de ventas
- No puede gestionar usuarios

### Colaborador

- Solo cargar productos nuevos
- No puede modificar ni eliminar productos
- Acceso limitado a reportes

## Uso del Sistema

### Para Clientes

1. **Ingreso**: Ingresar cédula o RUC en la pantalla principal
2. **Registro** (si es nuevo): Completar formulario de registro
3. **Escaneo**: Usar el botón para activar el lector de código de barras
4. **Agregar Productos**: Escanear productos y seleccionar cantidad
5. **Gestionar Carrito**: Ajustar cantidades o eliminar productos
6. **Finalizar**: Confirmar compra y dirigirse a caja

### Para Administradores

1. **Login**: Acceder con usuario y contraseña
2. **Dashboard**: Ver estadísticas y métricas
3. **Gestión**: Usar el menú lateral para acceder a diferentes módulos
4. **Productos**: Agregar productos manualmente o por código de barras
5. **Promociones**: Crear ofertas que se mostrarán a los clientes
6. **Reportes**: Analizar ventas y rendimiento

## Funcionalidades Técnicas

### Seguridad

- Contraseñas hasheadas con `password_hash()`
- Prepared statements para prevenir SQL injection
- Sanitización de inputs
- Validación de permisos por rol
- Protección CSRF (implementable)

### Performance

- Caché de consultas frecuentes
- Índices en base de datos
- Compresión de imágenes
- Lazy loading de contenido

### Responsive Design

- CSS Grid y Flexbox
- Media queries para diferentes tamaños
- Touch-friendly para tablets
- Optimización para móviles

## API Endpoints

### Cliente

- `POST /cliente/api/buscar_producto.php` - Buscar producto por código de barras
- `POST /cliente/api/agregar_carrito.php` - Agregar producto al carrito
- `GET /cliente/api/obtener_carrito.php` - Obtener contenido del carrito
- `POST /cliente/api/actualizar_cantidad.php` - Actualizar cantidad de producto
- `POST /cliente/api/eliminar_item.php` - Eliminar item del carrito
- `POST /cliente/api/vaciar_carrito.php` - Vaciar carrito completo
- `POST /cliente/api/finalizar_compra.php` - Finalizar compra
- `GET /cliente/api/obtener_ultima_compra.php` - Obtener última compra

### Admin

- `POST /admin/api/guardar_producto.php` - Crear/actualizar producto
- `POST /admin/api/eliminar_producto.php` - Eliminar producto
- (Más endpoints según módulos implementados)

## Solución de Problemas

### Error de conexión a base de datos

- Verificar credenciales en `config/database.php`
- Asegurar que MySQL esté ejecutándose
- Verificar que el usuario tenga permisos

### El lector de código de barras no funciona

- Verificar permisos de cámara en el navegador
- Usar HTTPS (requerido para acceso a cámara)
- Probar con diferentes navegadores

### Las imágenes no se suben

- Verificar permisos de escritura en `uploads/`
- Verificar tamaño máximo de archivo en php.ini
- Revisar logs en `logs/sistema.log`

## Mantenimiento

### Backup de Base de Datos

```bash
mysqldump -u tiendas2025 -p tiendabd > backup_$(date +%Y%m%d).sql
```

### Limpiar Logs

```bash
> logs/sistema.log
```

### Optimizar Base de Datos

```sql
OPTIMIZE TABLE productos;
OPTIMIZE TABLE compras;
OPTIMIZE TABLE detalle_compras;
```

## Actualizaciones Futuras

- [ ] Integración con sistemas de pago
- [ ] Reportes avanzados en PDF
- [ ] Notificaciones push
- [ ] App móvil nativa
- [ ] Integración con facturación electrónica
- [ ] Sistema de fidelización de clientes
- [ ] Gestión de inventario avanzada
- [ ] Múltiples sucursales

## Soporte

Para soporte técnico o consultas:
- Email: soporte@tiendas.com
- Teléfono: +595 XXX XXX XXX

## Licencia

Copyright © 2025 Sistema de Tiendas V3.0
Todos los derechos reservados.

## Changelog

### Versión 3.0 (2025-10-29)

- Lanzamiento inicial del sistema completo
- Módulo de clientes con lector de código de barras
- Panel de administración con roles
- Dashboard con gráficos
- Sistema de promociones
- Responsive design para tablets y móviles
