# Guía de Instalación y Uso
## Sistema de Supermercados y Tiendas V3.0

---

## 📋 Contenido

1. [Requisitos Previos](#requisitos-previos)
2. [Instalación Paso a Paso](#instalación-paso-a-paso)
3. [Configuración Inicial](#configuración-inicial)
4. [Primer Uso](#primer-uso)
5. [Guía de Usuario](#guía-de-usuario)
6. [Solución de Problemas](#solución-de-problemas)

---

## Requisitos Previos

### Servidor

- **Sistema Operativo**: Ubuntu 20.04+ / Debian 10+ / CentOS 7+
- **PHP**: Versión 7.4 o superior
- **MySQL**: Versión 8.0 o superior
- **Servidor Web**: Apache 2.4 o Nginx
- **Espacio en Disco**: Mínimo 500 MB
- **RAM**: Mínimo 512 MB

### Extensiones PHP Requeridas

```bash
php-mysql
php-pdo
php-mbstring
php-gd
php-curl
php-xml
```

---

## Instalación Paso a Paso

### 1. Instalar Dependencias

#### En Ubuntu/Debian:

```bash
# Actualizar repositorios
sudo apt update

# Instalar Apache, PHP y MySQL
sudo apt install -y apache2 php php-mysql php-mbstring php-gd php-curl php-xml mysql-server

# Iniciar servicios
sudo systemctl start apache2
sudo systemctl start mysql
sudo systemctl enable apache2
sudo systemctl enable mysql
```

#### En CentOS/RHEL:

```bash
# Instalar Apache, PHP y MySQL
sudo yum install -y httpd php php-mysql php-mbstring php-gd php-curl php-xml mariadb-server

# Iniciar servicios
sudo systemctl start httpd
sudo systemctl start mariadb
sudo systemctl enable httpd
sudo systemctl enable mariadb
```

### 2. Configurar MySQL

```bash
# Ejecutar script de seguridad
sudo mysql_secure_installation

# Ingresar a MySQL
sudo mysql -u root -p
```

### 3. Crear Base de Datos

```sql
-- Crear base de datos
CREATE DATABASE tiendabd CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

-- Crear usuario
CREATE USER 'tiendas2025'@'localhost' IDENTIFIED BY 'product@s.py';

-- Otorgar permisos
GRANT ALL PRIVILEGES ON tiendabd.* TO 'tiendas2025'@'localhost';
FLUSH PRIVILEGES;

-- Salir
EXIT;
```

### 4. Importar Estructura de Base de Datos

```bash
# Navegar al directorio del proyecto
cd /ruta/a/tiendas_v3

# Importar SQL
mysql -u tiendas2025 -p tiendabd < database_setup.sql
```

### 5. Configurar Apache

```bash
# Copiar archivos del proyecto al directorio web
sudo cp -r /ruta/a/tiendas_v3 /var/www/html/

# Crear configuración de VirtualHost
sudo nano /etc/apache2/sites-available/tiendas.conf
```

Agregar el siguiente contenido:

```apache
<VirtualHost *:80>
    ServerName tiendas.local
    ServerAlias www.tiendas.local
    DocumentRoot /var/www/html/tiendas_v3
    
    <Directory /var/www/html/tiendas_v3>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
    
    ErrorLog ${APACHE_LOG_DIR}/tiendas_error.log
    CustomLog ${APACHE_LOG_DIR}/tiendas_access.log combined
</VirtualHost>
```

```bash
# Activar sitio
sudo a2ensite tiendas
sudo a2dissite 000-default

# Reiniciar Apache
sudo systemctl restart apache2
```

### 6. Configurar Permisos

```bash
# Dar permisos al servidor web
sudo chown -R www-data:www-data /var/www/html/tiendas_v3
sudo chmod -R 755 /var/www/html/tiendas_v3

# Permisos especiales para uploads y logs
sudo chmod -R 775 /var/www/html/tiendas_v3/uploads
sudo chmod -R 775 /var/www/html/tiendas_v3/logs
```

### 7. Configurar Hosts (Opcional para desarrollo local)

```bash
# Editar archivo hosts
sudo nano /etc/hosts

# Agregar línea
127.0.0.1 tiendas.local
```

---

## Configuración Inicial

### 1. Verificar Conexión a Base de Datos

Abrir en navegador: `http://tiendas.local/test.php`

Si aparece información de PHP, la instalación es correcta.

### 2. Credenciales por Defecto

#### Panel de Administración

- **URL**: `http://tiendas.local/admin/login.php`
- **Usuario**: `Tiendas`
- **Contraseña**: `2025`

**⚠️ IMPORTANTE**: Cambiar estas credenciales después del primer acceso.

### 3. Cambiar Contraseña de Administrador

```sql
-- Conectarse a MySQL
mysql -u tiendas2025 -p tiendabd

-- Generar nueva contraseña hasheada (usar PHP)
-- En terminal PHP:
php -r "echo password_hash('nueva_contraseña', PASSWORD_DEFAULT);"

-- Actualizar en base de datos
UPDATE usuarios_admin 
SET password = 'hash_generado' 
WHERE username = 'Tiendas';
```

---

## Primer Uso

### Para Administradores

#### 1. Acceder al Panel

1. Abrir navegador
2. Ir a `http://tiendas.local/admin/login.php`
3. Ingresar credenciales
4. Explorar el dashboard

#### 2. Agregar Productos

1. Ir a **Productos** en el menú lateral
2. Clic en **Nuevo Producto**
3. Completar formulario:
   - Código de barras
   - Nombre
   - Descripción
   - Precio
   - Stock
   - Categoría
   - Imagen (opcional)
4. Guardar

#### 3. Crear Promociones

1. Ir a **Promociones**
2. Clic en **Nueva Promoción**
3. Completar:
   - Título
   - Descripción
   - Imagen (opcional)
   - Fecha de inicio y fin
4. Activar y guardar

#### 4. Crear Usuarios Administrativos

1. Ir a **Usuarios Admin** (solo Administrador)
2. Clic en **Nuevo Usuario**
3. Seleccionar rol:
   - **Administrador**: Acceso total
   - **Comercial**: Gestión de productos y promociones
   - **Colaborador**: Solo agregar productos
4. Guardar

### Para Clientes

#### 1. Primer Ingreso

1. Abrir `http://tiendas.local`
2. Ingresar cédula o RUC
3. Si es nuevo cliente:
   - Completar formulario de registro
   - Ver pantalla de bienvenida (7 segundos)
4. Acceder al dashboard

#### 2. Realizar Compra

1. **Escanear Productos**:
   - Clic en botón "APRIETE EL BOTON PARA LEER EL CODIGO"
   - Permitir acceso a cámara
   - Apuntar a código de barras del producto
   - Esperar confirmación

2. **Agregar al Carrito**:
   - Ver producto escaneado
   - Opciones:
     - "No quiero": Rechazar producto
     - "Si quiero": Agregar 1 unidad
     - "Este quiero mas": Seleccionar cantidad

3. **Gestionar Carrito**:
   - Ver productos en panel derecho
   - Usar botones +/- para ajustar cantidad
   - Clic en 🗑️ para eliminar producto
   - Ver total actualizado en tiempo real

4. **Finalizar Compra**:
   - Revisar productos y total
   - Clic en "Finalizar Compra"
   - Confirmar
   - Ver resumen de compra
   - Imprimir ticket (opcional)
   - Dirigirse a caja para pagar

---

## Guía de Usuario

### Módulo de Cliente

#### Funcionalidades Principales

**Lector de Código de Barras**
- Usa la cámara del dispositivo
- Compatible con códigos EAN-13, UPC-A, etc.
- Funciona en tablets y móviles

**Carrito de Compras**
- Actualización en tiempo real
- Formato de moneda en Guaraníes
- Separadores de miles
- Sonido al agregar productos

**Historial**
- Ver última compra realizada
- Detalle de productos y precios
- Total gastado

**Promociones**
- Rotación automática cada 10 segundos
- Visualización de ofertas activas
- Imágenes y descripciones

#### Atajos de Teclado

- `Enter` en campo de código: Buscar producto
- `Esc`: Cerrar modales

### Panel de Administración

#### Dashboard

**Métricas Principales**
- Total de clientes registrados
- Productos activos
- Compras realizadas
- Ventas totales

**Gráficos**
- Ventas de últimos 7 días (línea)
- Productos más vendidos (barras)
- Actualización automática

**Tabla de Compras**
- Últimas 10 compras
- Filtros por fecha
- Exportar a CSV

#### Gestión de Productos

**Crear Producto**
1. Código de barras único
2. Nombre descriptivo
3. Precio en Guaraníes
4. Stock inicial
5. Categoría
6. Imagen (opcional, máx 5MB)

**Editar Producto**
- Colaboradores: Solo sus productos
- Comerciales: Todos los productos
- Administradores: Acceso total

**Eliminar Producto**
- Solo Administradores y Comerciales
- Confirmación requerida

#### Gestión de Clientes

**Ver Información**
- Datos personales
- Historial de compras
- Total gastado

**Editar Cliente**
- Actualizar datos de contacto
- Modificar dirección

**Eliminar Cliente**
- Solo Administradores
- Elimina también su historial

#### Promociones

**Crear Promoción**
- Título llamativo
- Descripción detallada
- Imagen atractiva
- Fecha de inicio y fin
- Estado (activa/inactiva)

**Gestión**
- Activar/desactivar
- Editar contenido
- Eliminar

#### Mensajes Emergentes

**Crear Mensaje**
- Texto del mensaje
- Tipo (oferta, promoción, anuncio)
- Fecha de expiración
- Estado activo

**Uso**
- Notificaciones urgentes
- Ofertas por tiempo limitado
- Anuncios importantes

---

## Solución de Problemas

### Error: "No se puede conectar a la base de datos"

**Solución**:
```bash
# Verificar que MySQL esté ejecutándose
sudo systemctl status mysql

# Si no está activo
sudo systemctl start mysql

# Verificar credenciales en config/database.php
```

### Error: "Permiso denegado al subir imagen"

**Solución**:
```bash
# Dar permisos correctos
sudo chmod -R 775 /var/www/html/tiendas_v3/uploads
sudo chown -R www-data:www-data /var/www/html/tiendas_v3/uploads
```

### Error: "El lector de código de barras no funciona"

**Causas comunes**:
1. **Permisos de cámara**: Permitir en navegador
2. **HTTPS requerido**: Usar certificado SSL
3. **Navegador incompatible**: Usar Chrome/Firefox actualizado

**Solución HTTPS**:
```bash
# Instalar certbot
sudo apt install certbot python3-certbot-apache

# Obtener certificado
sudo certbot --apache -d tiendas.local
```

### Error: "Página en blanco"

**Solución**:
```bash
# Ver logs de error
sudo tail -f /var/log/apache2/tiendas_error.log

# Verificar errores PHP
sudo tail -f /var/log/apache2/error.log

# Habilitar display_errors (solo desarrollo)
sudo nano /etc/php/8.1/apache2/php.ini
# Cambiar: display_errors = On
sudo systemctl restart apache2
```

### Error: "Session already started"

**Solución**:
```bash
# Limpiar sesiones
sudo rm -rf /var/lib/php/sessions/*
sudo systemctl restart apache2
```

### Productos no aparecen en búsqueda

**Verificar**:
1. Producto está activo
2. Código de barras es correcto
3. Base de datos tiene datos

```sql
-- Verificar productos
SELECT * FROM productos WHERE activo = 1;
```

---

## Mantenimiento

### Backup Diario

```bash
#!/bin/bash
# Script de backup automático
fecha=$(date +%Y%m%d)
mysqldump -u tiendas2025 -p'product@s.py' tiendabd > /backups/tiendabd_$fecha.sql
tar -czf /backups/uploads_$fecha.tar.gz /var/www/html/tiendas_v3/uploads
```

### Limpiar Logs

```bash
# Limpiar logs antiguos (más de 30 días)
find /var/www/html/tiendas_v3/logs -name "*.log" -mtime +30 -delete
```

### Optimizar Base de Datos

```sql
-- Ejecutar mensualmente
OPTIMIZE TABLE productos;
OPTIMIZE TABLE compras;
OPTIMIZE TABLE detalle_compras;
OPTIMIZE TABLE clientes;
```

---

## Soporte y Contacto

Para asistencia técnica:
- **Email**: soporte@tiendas.com
- **Teléfono**: +595 XXX XXX XXX
- **Horario**: Lunes a Viernes, 8:00 - 18:00

---

## Notas Finales

- **Seguridad**: Cambiar contraseñas por defecto
- **Backups**: Realizar copias de seguridad regulares
- **Actualizaciones**: Mantener PHP y MySQL actualizados
- **SSL**: Usar HTTPS en producción
- **Firewall**: Configurar reglas apropiadas

---

**Versión**: 3.0  
**Fecha**: Octubre 2025  
**Autor**: Sistema de Tiendas V3.0
