# 🔧 Solución Error Apache en Plesk - Paso a Paso

## Error: "client denied by server configuration"

---

## ✅ SOLUCIÓN 1: Configurar Apache en Plesk (RECOMENDADO)

### Paso 1: Acceder a la Configuración de Apache

1. **Inicia sesión en Plesk** (https://tu-servidor:8443)
2. Ve a **"Sitios web y dominios"**
3. Busca y haz clic en **"distec.com.py"**
4. Haz clic en **"Configuración de Apache y nginx"**

### Paso 2: Agregar Directivas de Apache

En la sección **"Directivas adicionales de Apache"**, agrega este código:

```apache
<Directory /var/www/vhosts/distec.com.py/httpdocs>
    Require all granted
    AllowOverride All
    Options -Indexes +FollowSymLinks +MultiViews
    
    <IfModule mod_rewrite.c>
        RewriteEngine On
    </IfModule>
</Directory>

<Directory /var/www/vhosts/distec.com.py/httpdocs/uploads>
    Require all granted
    Options -Indexes
</Directory>

<Directory /var/www/vhosts/distec.com.py/httpdocs/admin>
    Require all granted
</Directory>

<Directory /var/www/vhosts/distec.com.py/httpdocs/cliente>
    Require all granted
</Directory>
```

### Paso 3: Aplicar Cambios

1. Haz clic en **"Aceptar"** o **"Aplicar"**
2. Espera a que Plesk reconfigure Apache (puede tardar unos segundos)
3. **NO es necesario reiniciar Apache manualmente**, Plesk lo hace automáticamente

---

## ✅ SOLUCIÓN 2: Verificar Permisos de Archivos en Plesk

### Opción A: Desde el Administrador de Archivos de Plesk

1. Ve a **"Sitios web y dominios"**
2. Haz clic en **"Administrador de archivos"**
3. Navega a **"httpdocs"**
4. Selecciona todos los archivos y carpetas
5. Haz clic en **"Cambiar permisos"**
6. Configura:
   - **Carpetas**: `755` (rwxr-xr-x)
   - **Archivos**: `644` (rw-r--r--)
7. Marca **"Aplicar a subcarpetas"**
8. Haz clic en **"Aceptar"**

### Opción B: Desde SSH (si tienes acceso)

```bash
cd /var/www/vhosts/distec.com.py/httpdocs/

# Permisos de directorios
find . -type d -exec chmod 755 {} \;

# Permisos de archivos
find . -type f -exec chmod 644 {} \;

# Permisos especiales para uploads y logs
chmod -R 775 uploads/
chmod -R 775 logs/

# Cambiar propietario (usuario de Plesk)
chown -R distec_user:psacln .
```

**Nota**: Reemplaza `distec_user` por tu usuario FTP de Plesk.

---

## ✅ SOLUCIÓN 3: Verificar Configuración de PHP

En Plesk, asegúrate de que PHP esté configurado correctamente:

1. Ve a **"Sitios web y dominios"** → **"distec.com.py"**
2. Haz clic en **"Configuración de PHP"**
3. Verifica que esté seleccionado:
   - **Versión de PHP**: 7.4 o superior (recomendado 8.0+)
   - **Modo de ejecución**: FPM o FastCGI
4. Haz clic en **"Aceptar"**

---

## ✅ SOLUCIÓN 4: Subir archivo .htaccess

Si las soluciones anteriores no funcionan, sube el archivo `.htaccess`:

1. Ve a **"Administrador de archivos"** en Plesk
2. Navega a **"httpdocs"**
3. Haz clic en **"Subir archivos"**
4. Sube el archivo `.htaccess` que te proporcioné
5. Verifica que el archivo se llame exactamente `.htaccess` (con el punto al inicio)
6. Cambia los permisos del archivo a `644`

**Contenido del .htaccess:**

```apache
<IfModule mod_authz_core.c>
    Require all granted
</IfModule>

<IfModule !mod_authz_core.c>
    Order allow,deny
    Allow from all
</IfModule>

<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteBase /
</IfModule>
```

---

## ✅ SOLUCIÓN 5: Verificar Restricciones de IP

En Plesk, verifica que no haya restricciones de IP:

1. Ve a **"Sitios web y dominios"** → **"distec.com.py"**
2. Busca **"Protección de directorios con contraseña"**
3. Asegúrate de que **"httpdocs"** NO esté protegido
4. Si está protegido, elimina la protección

---

## 🔍 Verificar que Funcionó

Después de aplicar las soluciones:

1. **Abre tu navegador**
2. Visita: `http://distec.com.py` o `https://distec.com.py`
3. Deberías ver la página de inicio del sistema

Si aún ves el error:

1. Ve a **"Sitios web y dominios"** → **"Registros"**
2. Haz clic en **"error_log"**
3. Busca la última línea con el error
4. Copia el error completo y envíamelo

---

## 📋 Checklist de Verificación

- [ ] Directivas de Apache agregadas en Plesk
- [ ] Cambios aplicados (botón "Aceptar")
- [ ] Permisos de archivos configurados (755/644)
- [ ] Archivo .htaccess subido
- [ ] PHP configurado correctamente
- [ ] Sin restricciones de IP
- [ ] Sin protección de directorios
- [ ] Sitio accesible en el navegador

---

## 🆘 Si el Problema Persiste

Si después de seguir todos estos pasos el error continúa:

### Opción 1: Reiniciar Servicios Web en Plesk

1. Ve a **"Herramientas y configuración"**
2. Haz clic en **"Servicios"**
3. Busca **"Apache"**
4. Haz clic en **"Reiniciar"**

### Opción 2: Verificar Logs Completos

1. Ve a **"Sitios web y dominios"** → **"Registros"**
2. Descarga **"error_log"**
3. Busca todas las líneas con "AH01797"
4. Envíame las últimas 20 líneas

### Opción 3: Contactar Soporte de Plesk

Si nada funciona, puede ser un problema de configuración global de Plesk que requiere acceso root.

---

## ✅ Configuración Final Recomendada

Una vez que funcione, tu configuración en Plesk debería verse así:

**Apache y nginx:**
- ✅ Directivas adicionales configuradas
- ✅ `Require all granted` presente

**Permisos:**
- ✅ Directorios: 755
- ✅ Archivos: 644
- ✅ uploads/: 775
- ✅ logs/: 775

**PHP:**
- ✅ Versión 7.4 o superior
- ✅ Modo FPM o FastCGI

---

## 📞 Necesitas Ayuda Adicional

Si después de seguir esta guía el problema persiste:

1. Toma una captura de pantalla de las **"Directivas de Apache"** en Plesk
2. Copia el contenido completo del **error_log**
3. Verifica que el archivo `.htaccess` esté en el lugar correcto
4. Envíame esa información para ayudarte mejor

---

¡Con estos pasos deberías poder solucionar el error en Plesk! 🎉
