# 🔒 Solución Error ModSecurity 403

## 🔴 Error Identificado

```
ModSecurity: Access denied with code 403 (phase 2)
Rule ID: 225170
File: /etc/httpd/conf/modsecurity.d/rules/comodo_free/26_Apps_WordPress.conf
Message: Sensitive Information Disclosure Vulnerability in WordPress 4.7
```

## ❌ Problema

**ModSecurity** (firewall de aplicaciones web) está bloqueando el acceso a tu sitio porque:

1. Tiene reglas activas para **WordPress**
2. Tu sistema **NO usa WordPress**
3. Las reglas están bloqueando peticiones legítimas de tu sistema PHP

---

## ✅ SOLUCIONES

### SOLUCIÓN 1: Desactivar ModSecurity para tu Dominio (RECOMENDADO)

Tu sistema NO usa WordPress, por lo que estas reglas no son necesarias.

#### Desde Plesk:

1. **Panel de Plesk** → **Sitios web y dominios**
2. Click en **distec.com.py**
3. Buscar **"Web Application Firewall (ModSecurity)"**
4. Seleccionar una de estas opciones:
   - **Desactivado** (más simple)
   - **Modo de detección** (solo registra, no bloquea)
5. Click en **Aplicar**

#### Desde SSH (si tienes acceso root):

```bash
# Desactivar ModSecurity para el dominio
sudo nano /etc/httpd/conf.d/vhost_distec.com.py.conf

# Agregar dentro del <VirtualHost>:
<IfModule mod_security2.c>
    SecRuleEngine Off
</IfModule>

# Reiniciar Apache
sudo systemctl restart httpd
```

---

### SOLUCIÓN 2: Desactivar Solo las Reglas de WordPress

Si quieres mantener ModSecurity activo pero desactivar solo las reglas de WordPress:

#### Desde SSH (requiere acceso root):

```bash
# Crear archivo de excepciones
sudo nano /etc/httpd/conf/modsecurity.d/rules/custom_exceptions.conf

# Agregar estas líneas:
<IfModule mod_security2.c>
    # Desactivar regla específica que causa el error
    SecRuleRemoveById 225170
    
    # Desactivar todas las reglas de WordPress
    SecRuleRemoveById 225100-225200
</IfModule>

# Reiniciar Apache
sudo systemctl restart httpd
```

---

### SOLUCIÓN 3: Crear Excepción para tu Dominio

Crear una whitelist para tu dominio específico:

```bash
# Editar configuración de ModSecurity
sudo nano /etc/httpd/conf/modsecurity.d/rules/custom_whitelist.conf

# Agregar:
<IfModule mod_security2.c>
    SecRule SERVER_NAME "@streq distec.com.py" \
        "id:1000,phase:1,pass,nolog,ctl:ruleEngine=Off"
</IfModule>

# Reiniciar Apache
sudo systemctl restart httpd
```

---

### SOLUCIÓN 4: Configurar en .htaccess (Más Simple)

Si no tienes acceso root, agregar en el archivo `.htaccess`:

```apache
# Desactivar ModSecurity para este directorio
<IfModule mod_security2.c>
    SecRuleEngine Off
</IfModule>
```

Ubicación del archivo:
```
/var/www/vhosts/distec.com.py/httpdocs/.htaccess
```

---

## 🎯 Recomendación

**Para tu caso específico:**

### ✅ USAR SOLUCIÓN 1 (Desactivar ModSecurity desde Plesk)

**Por qué:**
- ✅ Tu sistema NO usa WordPress
- ✅ No necesitas las reglas de WordPress
- ✅ Es la solución más simple
- ✅ No requiere acceso SSH
- ✅ Se configura desde el panel de Plesk

**Pasos:**
1. Plesk → Sitios web y dominios → distec.com.py
2. Web Application Firewall (ModSecurity)
3. Seleccionar: **Desactivado** o **Modo de detección**
4. Aplicar

---

## 🔍 Verificar que Funcionó

Después de aplicar la solución:

1. **Limpiar cache del navegador** (Ctrl+Shift+Delete)
2. **Acceder al sitio**: https://distec.com.py
3. **Verificar**:
   - ✅ No aparece error 403
   - ✅ Página de login carga correctamente
   - ✅ Puedes ingresar con cédula/RUC
   - ✅ Dashboard funciona

---

## 📋 Información Técnica del Error

### Detalles del Error:

| Campo | Valor |
|-------|-------|
| **Código de error** | 403 Forbidden |
| **Regla ID** | 225170 |
| **Archivo de regla** | 26_Apps_WordPress.conf |
| **Severidad** | CRITICAL |
| **CVE** | CVE-2017-5487 |
| **URI bloqueada** | /wp-json/wp/v2/users |
| **Referrer** | http://distec.com.py/wp-login.php |

### ¿Por qué ocurre?

1. **ModSecurity** tiene reglas para proteger WordPress
2. La regla **225170** bloquea acceso a `/wp-json/wp/v2/users`
3. Alguien intentó acceder a rutas de WordPress
4. Tu sistema **NO tiene WordPress**, pero ModSecurity lo bloquea igual

---

## 🛡️ Alternativa: Mantener ModSecurity Activo

Si quieres mantener la seguridad de ModSecurity pero sin bloqueos falsos:

### Configurar Modo de Detección:

```apache
<IfModule mod_security2.c>
    # Cambiar a modo de detección (solo registra, no bloquea)
    SecRuleEngine DetectionOnly
</IfModule>
```

**Ventajas:**
- ✅ ModSecurity sigue monitoreando
- ✅ Registra intentos de ataque
- ✅ NO bloquea tráfico legítimo

---

## 🔧 Si el Error Persiste

### Verificar Logs de ModSecurity:

```bash
# Ver logs recientes
sudo tail -100 /var/log/httpd/modsec_audit.log

# Buscar errores específicos
sudo grep "225170" /var/log/httpd/modsec_audit.log
```

### Verificar Configuración de Apache:

```bash
# Verificar configuración
sudo httpd -t

# Ver configuración de ModSecurity
sudo grep -r "SecRuleEngine" /etc/httpd/conf/
```

---

## 📞 Contactar Soporte del Hosting

Si no tienes acceso para hacer estos cambios:

**Información para enviar al soporte:**

```
Asunto: Desactivar ModSecurity o regla 225170 para distec.com.py

Mensaje:
Hola,

Necesito desactivar ModSecurity o la regla ID 225170 para mi dominio distec.com.py.

El error que recibo es:
"ModSecurity: Access denied with code 403 (phase 2). Rule ID: 225170"

Mi sitio NO usa WordPress, por lo que las reglas de WordPress están bloqueando 
tráfico legítimo de mi aplicación PHP personalizada.

Por favor:
1. Desactivar ModSecurity para distec.com.py, O
2. Desactivar la regla 225170, O
3. Configurar ModSecurity en modo "DetectionOnly"

Gracias.
```

---

## ✅ Checklist de Solución

- [ ] Acceder a Plesk
- [ ] Ir a Web Application Firewall (ModSecurity)
- [ ] Seleccionar "Desactivado" o "Modo de detección"
- [ ] Aplicar cambios
- [ ] Limpiar cache del navegador
- [ ] Verificar que el sitio carga
- [ ] Probar login de clientes
- [ ] Probar panel admin

---

## 🎉 Resultado Esperado

Después de aplicar la solución:

```
ANTES:
❌ Error 403 Forbidden
❌ ModSecurity bloquea acceso
❌ Sitio no accesible

DESPUÉS:
✅ Sitio accesible
✅ Sin errores 403
✅ Login funciona
✅ Dashboard carga correctamente
```

---

## 💡 Prevención Futura

Para evitar este problema en el futuro:

1. **No instalar WordPress** en el mismo dominio
2. **Mantener ModSecurity desactivado** para este dominio
3. **Usar reglas personalizadas** si necesitas firewall
4. **Monitorear logs** regularmente

---

## 🔒 Seguridad Alternativa

Si desactivas ModSecurity, puedes mantener seguridad con:

1. **Firewall de servidor** (iptables, UFW)
2. **Cloudflare** (protección DDoS, firewall)
3. **Fail2Ban** (bloqueo de IPs maliciosas)
4. **SSL/TLS** (HTTPS)
5. **Actualizaciones** regulares de PHP y MySQL

---

¡Con esta solución tu sitio debería funcionar correctamente! 🚀
