# Manual de Usuario Completo
## Sistema de Tiendas V3.0

**Versión**: 3.0  
**Fecha**: Diciembre 2025  
**Autor**: Manus AI

---

# Tabla de Contenidos

1. [Introducción General](#1-introducción-general)
2. [Módulo Cliente](#2-módulo-cliente)
3. [Panel de Administración](#3-panel-de-administración)
4. [Guía de Inicio Rápido](#4-guía-de-inicio-rápido)
5. [Solución de Problemas](#5-solución-de-problemas)
6. [Preguntas Frecuentes](#6-preguntas-frecuentes)

---

# 1. Introducción General

El **Sistema de Tiendas V3.0** es una plataforma web completa diseñada para facilitar las compras en supermercados y tiendas mediante el uso de tecnología moderna. El sistema permite a los clientes escanear productos con sus dispositivos móviles, gestionar un carrito de compras en tiempo real y finalizar sus compras de manera rápida y eficiente.

## 1.1. Características Principales

El sistema se divide en dos módulos principales que trabajan de manera integrada:

**Módulo de Cliente** permite a los usuarios finales realizar compras de forma autónoma. Los clientes pueden autenticarse usando su número de cédula o RUC, escanear productos mediante la cámara de su dispositivo móvil, agregar items al carrito, modificar cantidades y finalizar sus compras. El sistema también muestra promociones y mensajes emergentes configurados por los administradores.

**Panel de Administración** proporciona herramientas completas para gestionar el sistema. Los administradores pueden agregar y modificar productos, gestionar clientes, crear promociones, enviar mensajes emergentes, revisar compras en tiempo real y generar reportes detallados. El panel cuenta con un sistema de roles que permite asignar diferentes niveles de acceso a los usuarios administrativos.

## 1.2. Tecnología Utilizada

El sistema está construido con tecnologías web modernas que garantizan compatibilidad con la mayoría de dispositivos y navegadores. Utiliza **PHP** para el backend, **MySQL** para la base de datos, y **HTML5, CSS3 y JavaScript** para el frontend. La interfaz es completamente responsive, adaptándose automáticamente a pantallas de escritorio, tablets y dispositivos móviles.

## 1.3. Requisitos del Sistema

Para utilizar el sistema como cliente, se necesita un dispositivo con navegador web moderno (Chrome, Firefox, Safari o Edge) y conexión a internet. Para usar el scanner de códigos de barras, el dispositivo debe tener cámara funcional y el navegador debe tener permisos para acceder a ella.

Para administradores, se recomienda utilizar un navegador de escritorio actualizado para aprovechar todas las funcionalidades del panel de administración, aunque el sistema también funciona en tablets.

---

# 2. Módulo Cliente

El módulo de cliente está diseñado para proporcionar una experiencia de compra intuitiva y eficiente. A continuación se detallan todas las funcionalidades disponibles.

## 2.1. Acceso al Sistema

Para comenzar a utilizar el sistema, el cliente debe acceder a través de un navegador web a la URL proporcionada por el establecimiento.

### 2.1.1. Pantalla de Login

La pantalla inicial solicita el número de cédula o RUC del cliente. Este proceso de autenticación es simple y rápido, diseñado para minimizar las barreras de entrada. El cliente debe ingresar su número de identificación en el campo correspondiente. El sistema acepta tanto cédulas (generalmente de 6 a 7 dígitos) como RUC (de 8 a 9 dígitos), con o sin guión separador.

El sistema ha sido optimizado para eliminar automáticamente cualquier espacio que el usuario pueda ingresar accidentalmente, evitando errores comunes. Una vez ingresado el número, el cliente hace click en el botón **"Ingresar"** y el sistema verifica si el número existe en la base de datos.

### 2.1.2. Proceso de Registro

Si el sistema no encuentra el número de cédula o RUC en la base de datos, automáticamente redirige al cliente a un formulario de registro. Este formulario es breve y solo solicita información esencial para completar el perfil del cliente.

Los campos requeridos son **Nombre**, **Apellido** y **Ciudad**. El campo de teléfono es opcional y puede dejarse en blanco si el cliente lo prefiere. Una vez completado el formulario, el cliente hace click en **"Registrarse"** y el sistema crea su cuenta automáticamente, permitiéndole acceder inmediatamente al dashboard.

Este diseño de registro bajo demanda reduce la fricción inicial y permite que los clientes comiencen a comprar lo más rápido posible.

## 2.2. Dashboard del Cliente

El dashboard es la pantalla principal donde el cliente interactúa con el sistema. Está dividido en dos secciones principales que trabajan de manera coordinada.

### 2.2.1. Estructura del Dashboard

La pantalla se divide en dos paneles. En dispositivos de escritorio y tablets en orientación horizontal, ambos paneles se muestran lado a lado. El **Panel Principal** ocupa aproximadamente el 60% del ancho y contiene el scanner de productos y el área de promociones. El **Panel del Carrito** ocupa el 40% restante y muestra todos los productos agregados con sus controles.

En dispositivos móviles, los paneles se apilan verticalmente para facilitar la navegación. El panel principal aparece arriba, permitiendo al cliente escanear y agregar productos, mientras que el carrito se muestra debajo con scroll independiente.

### 2.2.2. Encabezado

En la parte superior de la pantalla se muestra un encabezado que incluye el logo o nombre del sistema, un mensaje de bienvenida personalizado con el nombre del cliente, y un botón **"Salir"** para cerrar la sesión. Este encabezado permanece visible en todo momento, proporcionando contexto y fácil acceso a la función de logout.

## 2.3. Escaneo de Productos

La funcionalidad de escaneo es el corazón del módulo de cliente, permitiendo agregar productos de manera rápida y sin errores.

### 2.3.1. Uso del Scanner de Código de Barras

En el panel principal, el cliente verá un área destacada con el botón **"APRIETE EL BOTON PARA LEER EL CODIGO"**. Al hacer click en este botón, el sistema solicita permiso para acceder a la cámara del dispositivo. Si es la primera vez, el navegador mostrará un mensaje pidiendo autorización, que el cliente debe aceptar.

Una vez activada la cámara, aparece una vista en vivo donde el cliente debe apuntar hacia el código de barras del producto. El sistema está configurado para detectar automáticamente los formatos más comunes de códigos de barras, incluyendo **EAN-13** (el más utilizado en productos de supermercado), **EAN-8**, **UPC-A**, **UPC-E**, **CODE-128**, **CODE-39** e **ITF**.

Para obtener mejores resultados, el cliente debe mantener el código de barras en posición horizontal, asegurarse de que haya buena iluminación, y mantener una distancia de aproximadamente 15 a 20 centímetros entre la cámara y el código. El sistema detecta el código en 1 a 2 segundos y automáticamente muestra la vista previa del producto.

### 2.3.2. Entrada Manual de Código

Como alternativa al scanner, especialmente útil en dispositivos donde la cámara no funciona correctamente o en situaciones de mala iluminación, el sistema proporciona un campo de **entrada manual**. Este campo se encuentra debajo del botón del scanner.

El cliente puede simplemente escribir el número del código de barras en el campo de texto y hacer click en el botón **"Buscar"**. El sistema buscará el producto en la base de datos y mostrará la vista previa si lo encuentra. Esta opción es particularmente útil en iPhone y otros dispositivos iOS donde el scanner puede tener limitaciones.

### 2.3.3. Vista Previa del Producto

Cuando el sistema detecta o encuentra un producto, reemplaza temporalmente el área de promociones con una **vista previa** del producto. Esta vista muestra información completa que incluye la imagen del producto (si está disponible), el nombre completo, una descripción breve, y el precio en guaraníes con formato de miles para fácil lectura.

El cliente tiene tres opciones en este punto:

**"No quiero"** cancela la selección y vuelve a mostrar el área de promociones, permitiendo al cliente escanear otro producto.

**"Si quiero"** agrega automáticamente una unidad del producto al carrito. El sistema reproduce un sonido de confirmación, actualiza el carrito y vuelve al scanner para que el cliente pueda continuar agregando productos.

**"Este quiero mas"** abre un campo de entrada donde el cliente puede especificar la cantidad exacta que desea agregar. Esto es útil cuando el cliente quiere comprar múltiples unidades del mismo producto. Una vez ingresada la cantidad, el cliente confirma y los items se agregan al carrito.

## 2.4. Gestión del Carrito

El carrito de compras es dinámico y se actualiza en tiempo real conforme el cliente agrega, modifica o elimina productos.

### 2.4.1. Visualización de Items

Cada producto en el carrito se muestra en un diseño horizontal que maximiza la información visible. La presentación incluye una **imagen miniatura** del producto (60x60 píxeles en desktop, 50x50 en móvil), el **nombre del producto** en negrita, el **precio unitario** mostrado como "₲ X c/u" (por ejemplo, "₲ 12.500 c/u"), y el **subtotal** del item calculado como cantidad × precio unitario.

Los controles de cantidad están integrados en cada item, con botones **"-"** y **"+"** que permiten disminuir o aumentar la cantidad. Entre estos botones se muestra el número actual de unidades. A la derecha del item hay un botón **"×"** de color rojo que permite eliminar completamente el producto del carrito.

### 2.4.2. Modificación de Cantidades

Para cambiar la cantidad de un producto, el cliente simplemente hace click en los botones de control. El botón **"+"** aumenta la cantidad en una unidad, mientras que el botón **"-"** la disminuye. Si la cantidad llega a cero mediante el botón menos, el sistema automáticamente elimina el item del carrito.

Cada vez que se modifica una cantidad, el sistema actualiza inmediatamente el subtotal del item y el total general del carrito. Esta actualización es instantánea y no requiere recargar la página.

### 2.4.3. Eliminación de Items

Si el cliente decide que no quiere un producto, puede hacer click en el botón **"×"** ubicado en el extremo derecho del item. El sistema solicita confirmación y, al aceptar, elimina el producto del carrito y recalcula el total.

### 2.4.4. Encabezado del Carrito

En la parte superior del panel del carrito se muestra un encabezado con el icono de carrito (🛒), el título **"Mi Carrito"** y entre paréntesis el número total de items. Por ejemplo, "Mi Carrito (3 items)" indica que hay tres productos diferentes en el carrito, independientemente de las cantidades individuales.

### 2.4.5. Total General

En la parte inferior del carrito, antes de los botones de acción, se muestra el **TOTAL** en grande con el monto en guaraníes. Este total incluye todos los productos y sus cantidades, formateado con separadores de miles para fácil lectura. Por ejemplo: "TOTAL: ₲ 125.500".

## 2.5. Finalización de Compra

Una vez que el cliente ha agregado todos los productos deseados, puede proceder a finalizar su compra.

### 2.5.1. Botón Finalizar Compra

El botón **"Finalizar Compra"** se encuentra en la parte inferior del carrito, destacado en color verde. Al hacer click, el sistema procesa la compra y la registra en la base de datos con todos los detalles: productos, cantidades, precios y total.

El cliente es redirigido a una **pantalla de confirmación** que muestra un mensaje de agradecimiento, el número de compra, el total pagado y un resumen de los items adquiridos. Esta pantalla también ofrece la opción de volver al dashboard para realizar una nueva compra.

### 2.5.2. Botón Vaciar Carrito

Si el cliente decide empezar de nuevo, puede usar el botón **"Vaciar Carrito"** ubicado debajo del botón de finalizar compra. Este botón, de color rojo, elimina todos los productos del carrito después de solicitar confirmación. Es útil cuando el cliente cambia de opinión sobre su compra completa.

### 2.5.3. Ver Última Compra

El botón **"Ver Última Compra"** permite al cliente revisar su compra anterior. Al hacer click, se muestra un popup con el detalle de la última compra finalizada, incluyendo la fecha, los productos, cantidades y el total. Esta funcionalidad es útil para verificar compras recientes o recordar qué se adquirió en la visita anterior.

## 2.6. Promociones y Mensajes

El sistema incluye funcionalidades para mantener a los clientes informados sobre ofertas y novedades.

### 2.6.1. Área de Promociones

En el panel principal, debajo del scanner, se encuentra el **área de promociones**. Aquí se muestran las promociones activas configuradas por los administradores. Si hay múltiples promociones, el sistema las rota automáticamente cada 10 segundos, permitiendo que el cliente vea todas las ofertas disponibles sin necesidad de interacción.

Cada promoción puede incluir una imagen, un título destacado y una descripción. El diseño es atractivo y llamativo para captar la atención del cliente mientras escanea productos.

### 2.6.2. Mensajes Emergentes (Popups)

Al ingresar al dashboard, el sistema puede mostrar **mensajes emergentes** configurados por los administradores. Estos popups aparecen automáticamente después de 1 segundo de carga de la página y se presentan uno a la vez si hay múltiples mensajes.

Los mensajes se clasifican en cuatro tipos, cada uno con su propio diseño visual:

**Ofertas** se muestran con fondo rojo/rosa y el icono 🎁. Se utilizan para comunicar descuentos especiales y promociones de precio.

**Promociones** aparecen con fondo verde y el icono 🏷️. Son ideales para anunciar combos, ofertas 2x1, 3x2 y similares.

**Anuncios** usan fondo azul y el icono 📢. Se emplean para información general como cambios de horario, nuevos productos o eventos especiales.

**Alertas** tienen fondo naranja y el icono ⚠️. Se reservan para avisos importantes que requieren la atención del cliente.

Cada popup incluye el mensaje completo, un botón **"Entendido"** para cerrarlo manualmente, y un botón **"×"** en la esquina superior derecha. Si el cliente no cierra el popup, este se cierra automáticamente después de 10 segundos. Si hay múltiples mensajes, aparecen secuencialmente con 5 segundos de intervalo entre cada uno.

## 2.7. Salir del Sistema

Para cerrar la sesión, el cliente hace click en el botón **"Salir"** ubicado en la esquina superior derecha del encabezado. El sistema cierra la sesión de manera segura y redirige al cliente a la pantalla de login. Es importante cerrar la sesión, especialmente en dispositivos compartidos, para proteger la privacidad del cliente.

---

# 3. Panel de Administración

El panel de administración proporciona todas las herramientas necesarias para gestionar el sistema de manera eficiente. Está diseñado con una interfaz moderna, intuitiva y responsive.

## 3.1. Acceso al Panel

Los usuarios administrativos acceden al panel a través de una URL específica, generalmente `http://tu-dominio.com/admin/`.

### 3.1.1. Pantalla de Login

La pantalla de login del panel administrativo solicita un **nombre de usuario** y una **contraseña**. A diferencia del módulo de cliente que usa cédula, el panel administrativo requiere credenciales específicas que son asignadas por el administrador principal del sistema.

El sistema incluye un usuario administrador predeterminado con credenciales iniciales que deben cambiarse en la primera configuración. Las credenciales por defecto son:
- **Usuario**: `Tiendas`
- **Contraseña**: `2025`

Es altamente recomendable cambiar estas credenciales después de la instalación inicial por razones de seguridad.

### 3.1.2. Sistema de Roles

El panel de administración implementa un sistema de roles que controla el acceso a diferentes funcionalidades. Existen tres roles principales:

**Administrador** tiene acceso completo a todos los módulos y funcionalidades del sistema. Puede gestionar usuarios, clientes, productos, promociones, mensajes, compras y reportes. Es el único rol que puede crear, editar y eliminar otros usuarios administrativos.

**Comercial** tiene permisos para gestionar productos, crear y modificar promociones, enviar mensajes emergentes y ver las compras. No puede gestionar usuarios administrativos ni acceder a ciertos reportes sensibles. Este rol es ideal para empleados encargados del inventario y las estrategias de venta.

**Colaborador** tiene acceso de solo lectura a productos y compras. Puede ver la información pero no puede modificarla. Este rol es útil para empleados que necesitan consultar información sin riesgo de realizar cambios accidentales.

## 3.2. Dashboard Principal

Al ingresar al panel, el usuario ve el **dashboard principal** que proporciona una visión general del estado del sistema.

### 3.2.1. Estadísticas Visuales

El dashboard incluye gráficos interactivos creados con Chart.js que muestran información clave de manera visual. Los gráficos típicamente incluyen:

**Ventas por día** muestra un gráfico de líneas o barras con las ventas de los últimos 7 o 30 días, permitiendo identificar tendencias y patrones de compra.

**Productos más vendidos** presenta un gráfico de barras o circular con los productos que generan más ventas, útil para decisiones de inventario.

**Clientes frecuentes** identifica a los clientes con más compras, facilitando estrategias de fidelización.

### 3.2.2. Tarjetas de Resumen

Además de los gráficos, el dashboard muestra tarjetas con números clave como el total de ventas del día, número de compras realizadas, cantidad de productos activos, y número de clientes registrados. Estas tarjetas proporcionan información rápida sin necesidad de navegar a otros módulos.

## 3.3. Gestión de Productos

El módulo de productos es uno de los más importantes, permitiendo mantener actualizado el catálogo de la tienda.

### 3.3.1. Listado de Productos

La página de productos muestra una tabla con todos los productos registrados. Cada fila incluye el código de barras, nombre, categoría, precio, stock, estado (activo/inactivo), el usuario que lo creó, y botones de acción para editar o eliminar.

La tabla incluye funcionalidades de búsqueda y filtrado que permiten encontrar productos rápidamente por nombre, código o categoría. También se puede ordenar por cualquier columna haciendo click en el encabezado.

### 3.3.2. Agregar Nuevo Producto

Para agregar un producto, el administrador hace click en el botón **"➕ Nuevo Producto"** ubicado en la parte superior de la página. Esto abre un modal con el formulario de producto.

El formulario incluye los siguientes campos:

**Código de Barras** es obligatorio y debe ser único. El sistema incluye un botón **"📷 Escanear"** junto al campo que permite usar la cámara del dispositivo para leer el código directamente del producto. Esta funcionalidad es especialmente útil cuando se agregan productos desde una tablet o móvil. Si el scanner no está disponible o no funciona, el código puede escribirse manualmente.

**Nombre** del producto es obligatorio y debe ser descriptivo. Por ejemplo, "Arroz Blanco 1kg" en lugar de solo "Arroz".

**Descripción** es opcional pero recomendada. Permite agregar información adicional como marca, características especiales o ingredientes.

**Precio** es obligatorio y se ingresa en guaraníes. El sistema aplica automáticamente formato de miles mientras se escribe, facilitando la lectura. Por ejemplo, al escribir "12500", el sistema muestra "12.500". Al guardar, el valor se almacena correctamente sin los puntos.

**Stock** indica la cantidad disponible. Es opcional y por defecto se establece en 0. El sistema no controla automáticamente el stock (no lo reduce con las compras), por lo que debe actualizarse manualmente según las necesidades del negocio.

**Categoría** es opcional y permite clasificar los productos. Por ejemplo: "Alimentos", "Bebidas", "Limpieza", "Higiene", etc.

**Imagen** del producto es opcional pero altamente recomendada. El administrador puede subir una foto en formatos JPG, PNG, GIF o WEBP con un tamaño máximo de 5MB. La imagen se muestra en el carrito del cliente y en la vista previa del producto, mejorando significativamente la experiencia de usuario.

**Activo** es un checkbox que indica si el producto está disponible para la venta. Solo los productos marcados como activos aparecen cuando los clientes escanean códigos. Esto permite mantener productos en la base de datos sin que estén disponibles temporalmente.

Una vez completado el formulario, el administrador hace click en **"Guardar"** y el producto se agrega a la base de datos.

### 3.3.3. Editar Producto

Para modificar un producto existente, el administrador hace click en el botón de edición (✏️) en la fila correspondiente. El sistema abre el mismo modal de producto pero con todos los campos prellenados con la información actual.

El administrador puede modificar cualquier campo excepto el ID del producto. Al editar el precio, el sistema automáticamente aplica el formato de miles para facilitar la lectura. Una vez realizados los cambios, se hace click en **"Guardar"** y los cambios se aplican inmediatamente.

### 3.3.4. Eliminar Producto

El botón de eliminación (🗑️) permite borrar un producto de la base de datos. El sistema solicita confirmación antes de proceder, ya que esta acción es irreversible. Solo los usuarios con rol de Administrador pueden eliminar productos. Los Colaboradores no ven este botón.

Es importante notar que eliminar un producto que ha sido parte de compras anteriores puede afectar los reportes históricos, por lo que se recomienda usar la opción "Inactivo" en lugar de eliminar cuando sea posible.

## 3.4. Gestión de Clientes

El módulo de clientes permite administrar la base de datos de clientes registrados. Solo los usuarios con rol de **Administrador** tienen acceso a este módulo.

### 3.4.1. Listado de Clientes

La página muestra una tabla con todos los clientes registrados, incluyendo su cédula/RUC, nombre completo, teléfono, ciudad y fecha de registro. La tabla incluye búsqueda y filtrado para encontrar clientes específicos rápidamente.

### 3.4.2. Editar Cliente

El administrador puede modificar la información de un cliente haciendo click en el botón de edición. Esto abre un formulario donde se pueden actualizar el nombre, apellido, teléfono y ciudad. La cédula/RUC no puede modificarse ya que es el identificador único del cliente.

### 3.4.3. Eliminar Cliente

El botón de eliminación permite borrar un cliente del sistema. Esta acción debe usarse con precaución ya que eliminar un cliente que tiene compras registradas puede afectar la integridad de los datos históricos.

## 3.5. Gestión de Promociones

El módulo de promociones permite crear y gestionar las ofertas que se muestran en el dashboard del cliente. Los roles de **Administrador** y **Comercial** tienen acceso a este módulo.

### 3.5.1. Crear Promoción

Para crear una nueva promoción, el administrador hace click en **"Nueva Promoción"** y completa el formulario con los siguientes campos:

**Título** es el encabezado de la promoción, debe ser corto y llamativo. Por ejemplo: "¡2x1 en Gaseosas!".

**Descripción** proporciona más detalles sobre la oferta. Por ejemplo: "Lleva 2 gaseosas de 2 litros y paga solo 1. Válido hasta fin de mes."

**Imagen** es opcional pero recomendada para hacer la promoción más atractiva visualmente.

**Activa** es un checkbox que controla si la promoción se muestra a los clientes. Solo las promociones marcadas como activas aparecen en el dashboard del cliente.

### 3.5.2. Editar y Eliminar Promociones

Las promociones pueden editarse en cualquier momento para actualizar el texto o la imagen. También pueden marcarse como inactivas sin eliminarlas, permitiendo reutilizarlas en el futuro. El botón de eliminación borra permanentemente la promoción.

## 3.6. Mensajes Emergentes

Este módulo permite enviar popups automáticos a los clientes cuando ingresan al sistema. Los roles de **Administrador** y **Comercial** tienen acceso.

### 3.6.1. Crear Mensaje

Para crear un mensaje emergente, el administrador hace click en **"Nuevo Mensaje"** y completa:

**Mensaje** es el texto que se mostrará en el popup. Debe ser claro y conciso.

**Tipo** determina el estilo visual del popup. Las opciones son:
- **Oferta**: Fondo rojo/rosa, icono 🎁
- **Promoción**: Fondo verde, icono 🏷️
- **Anuncio**: Fondo azul, icono 📢
- **Alerta**: Fondo naranja, icono ⚠️

**Activo** controla si el mensaje se muestra a los clientes.

Los mensajes activos aparecen automáticamente cuando los clientes ingresan al dashboard, en el orden en que fueron creados.

### 3.6.2. Gestión de Mensajes

Los mensajes pueden editarse, desactivarse o eliminarse según sea necesario. Es recomendable mantener solo 2-3 mensajes activos simultáneamente para no abrumar a los clientes.

## 3.7. Gestión de Compras

El módulo de compras permite revisar todas las transacciones realizadas por los clientes.

### 3.7.1. Listado de Compras

La página muestra una tabla con todas las compras, incluyendo el número de compra, cliente, fecha, total y estado. El sistema permite filtrar por:

**Estado**: Finalizadas o Activas (carritos no finalizados).

**Período**: Hoy, última semana, último mes o todas.

### 3.7.2. Ver Detalle de Compra

Al hacer click en una compra, se abre un modal con el detalle completo que incluye:
- Información del cliente
- Fecha y hora exacta
- Lista de productos con cantidades y precios
- Subtotales por producto
- Total de la compra

Esta información es útil para verificar transacciones, resolver dudas de clientes o generar reportes.

## 3.8. Gestión de Usuarios Administrativos

Solo el rol de **Administrador** puede gestionar usuarios del panel.

### 3.8.1. Crear Usuario

El administrador puede crear nuevos usuarios especificando:
- **Nombre de usuario** (único)
- **Contraseña** (se almacena encriptada)
- **Rol** (Administrador, Comercial o Colaborador)
- **Nombre completo** (opcional)

### 3.8.2. Editar y Eliminar Usuarios

Los usuarios pueden editarse para cambiar su rol o contraseña. También pueden eliminarse cuando ya no necesitan acceso al sistema.

## 3.9. Reportes

El módulo de reportes (solo para Administradores) proporciona análisis detallados:

**Ventas por período** muestra gráficos y tablas de ventas diarias, semanales o mensuales.

**Productos más vendidos** identifica qué productos generan más ingresos.

**Clientes frecuentes** lista los clientes con más compras, útil para programas de fidelización.

---

# 4. Guía de Inicio Rápido

Esta sección proporciona instrucciones condensadas para empezar a usar el sistema rápidamente.

## 4.1. Para Clientes

1. **Acceda al sistema** abriendo el navegador y yendo a la URL proporcionada.
2. **Ingrese su cédula** en el campo correspondiente y haga click en "Ingresar".
3. **Complete el registro** si es su primera vez (nombre, apellido, ciudad).
4. **Escanee productos** haciendo click en el botón del scanner y apuntando la cámara al código de barras.
5. **Agregue al carrito** eligiendo "Si quiero" o especificando una cantidad.
6. **Revise su carrito** en el panel derecho y ajuste cantidades si es necesario.
7. **Finalice su compra** haciendo click en el botón verde "Finalizar Compra".

## 4.2. Para Administradores

1. **Acceda al panel** yendo a `http://tu-dominio.com/admin/`.
2. **Ingrese sus credenciales** (usuario y contraseña).
3. **Agregue productos** navegando a "Productos" y usando el scanner para los códigos de barras.
4. **Configure precios** usando el formato automático de miles (ej: 12.500).
5. **Cree promociones** en el módulo correspondiente para atraer clientes.
6. **Envíe mensajes** usando el módulo de mensajes emergentes.
7. **Revise las ventas** en el módulo de compras o en el dashboard principal.

---

# 5. Solución de Problemas

Esta sección aborda los problemas más comunes y sus soluciones.

## 5.1. Problemas de Acceso

### No puedo ingresar con mi cédula

**Causa**: Espacios extra, formato incorrecto o cédula no registrada.

**Solución**: Asegúrese de que el número no tenga espacios al inicio o final. El sistema los elimina automáticamente, pero verifique que el número sea correcto. Si es su primera vez, el sistema lo redirigirá al registro automáticamente.

### Olvidé mi contraseña de administrador

**Causa**: Contraseña perdida u olvidada.

**Solución**: Contacte al administrador principal del sistema o al proveedor técnico para restablecer la contraseña. Por razones de seguridad, las contraseñas están encriptadas y no pueden recuperarse, solo restablecerse.

## 5.2. Problemas con el Scanner

### El scanner no funciona en mi iPhone

**Causa**: Limitaciones del navegador o permisos de cámara no otorgados.

**Solución 1**: Use el campo de **entrada manual** debajo del botón del scanner. Escriba el código de barras y haga click en "Buscar".

**Solución 2**: Asegúrese de haber dado **permisos de cámara** al navegador. Vaya a Configuración > Safari > Cámara y permita el acceso.

**Solución 3**: Use el navegador **Safari** en lugar de Chrome, ya que Safari tiene mejor compatibilidad con la cámara en iOS.

### El scanner no detecta el código de barras

**Causa**: Mala iluminación, código dañado o distancia incorrecta.

**Solución**: Asegúrese de tener buena iluminación. Mantenga el código de barras en posición horizontal y a una distancia de 15-20 cm de la cámara. Si el código está dañado o borroso, use la entrada manual.

## 5.3. Problemas con Productos

### Las imágenes de los productos no se ven en el carrito

**Causa**: Imágenes no subidas o ruta incorrecta.

**Solución para clientes**: Esto es un problema de configuración del administrador. El sistema mostrará un placeholder (imagen genérica) si no hay imagen disponible.

**Solución para administradores**: Asegúrese de subir una imagen para cada producto al crearlo o editarlo. Verifique que las imágenes estén en la carpeta `uploads/productos/` del servidor.

### Producto no encontrado al escanear

**Causa**: Producto no existe en la base de datos o está marcado como inactivo.

**Solución para clientes**: Verifique que el código sea correcto o intente con la entrada manual.

**Solución para administradores**: Verifique que el producto esté registrado en el sistema con el código correcto y que esté marcado como "Activo" en la configuración del producto.

## 5.4. Problemas de Visualización

### La página se ve mal en mi celular

**Causa**: Cache del navegador desactualizado o navegador antiguo.

**Solución**: Limpie la cache del navegador (Configuración > Privacidad > Limpiar datos de navegación). Si el problema persiste, actualice su navegador o use uno más moderno como Chrome, Firefox o Safari.

### Los precios no muestran el formato de miles

**Causa**: JavaScript deshabilitado o error de carga.

**Solución**: Asegúrese de que JavaScript esté habilitado en su navegador. Recargue la página con Ctrl+F5 (Windows) o Cmd+Shift+R (Mac) para forzar la recarga de scripts.

## 5.5. Problemas de Rendimiento

### El sistema está lento

**Causa**: Conexión a internet lenta o servidor sobrecargado.

**Solución**: Verifique su conexión a internet. Si el problema persiste, contacte al administrador del sistema ya que puede ser un problema del servidor.

### Las imágenes tardan en cargar

**Causa**: Imágenes muy grandes o conexión lenta.

**Solución para administradores**: Optimice las imágenes antes de subirlas. Se recomienda usar imágenes de máximo 500KB en formato JPG o WEBP para mejor rendimiento.

---

# 6. Preguntas Frecuentes

## 6.1. Preguntas Generales

**¿Necesito crear una cuenta para comprar?**

No exactamente. Solo necesita su número de cédula o RUC. Si es su primera vez, el sistema le pedirá completar un breve registro con su nombre y ciudad, pero el proceso es rápido y simple.

**¿El sistema guarda mi información de pago?**

No. El sistema registra las compras pero no procesa pagos ni guarda información financiera. El pago se realiza fuera del sistema según el método que el establecimiento tenga configurado.

**¿Puedo usar el sistema sin internet?**

No. El sistema requiere conexión a internet constante ya que toda la información se almacena en el servidor y se actualiza en tiempo real.

## 6.2. Preguntas de Clientes

**¿Puedo ver mis compras anteriores?**

Sí. El botón "Ver Última Compra" en el carrito muestra un resumen de su compra más reciente. Para ver un historial completo, consulte con el administrador del establecimiento.

**¿Qué hago si escaneo el producto equivocado?**

Simplemente haga click en "No quiero" en la vista previa del producto. Si ya lo agregó al carrito, puede eliminarlo con el botón "×" o usar "Vaciar Carrito" para empezar de nuevo.

**¿Los precios incluyen impuestos?**

Eso depende de la configuración del establecimiento. Consulte con el personal de la tienda sobre su política de precios.

## 6.3. Preguntas de Administradores

**¿Cómo cambio la contraseña de un usuario?**

Vaya a "Usuarios" en el panel de administración, haga click en editar para el usuario correspondiente, ingrese la nueva contraseña y guarde los cambios.

**¿Puedo importar productos masivamente?**

La versión actual no incluye importación masiva por defecto. Para agregar múltiples productos, debe hacerlo uno por uno. Sin embargo, el scanner de códigos de barras acelera significativamente el proceso.

**¿El sistema controla el inventario automáticamente?**

No. El campo de stock es informativo pero el sistema no lo reduce automáticamente cuando se realizan compras. Debe actualizarse manualmente según las necesidades del negocio.

**¿Puedo personalizar los colores y el logo?**

Sí, pero requiere modificar los archivos CSS del sistema. Consulte con su proveedor técnico para realizar personalizaciones de diseño.

**¿Cómo hago backup de la base de datos?**

Esto debe hacerse desde el panel de control del servidor (Plesk, cPanel, etc.) o mediante comandos MySQL. Se recomienda realizar backups diarios automáticos. Consulte con su proveedor de hosting.

---

# 7. Información Técnica

## 7.1. Requisitos del Sistema

**Para Clientes:**
- Navegador web moderno (Chrome 90+, Firefox 88+, Safari 14+, Edge 90+)
- Conexión a internet
- Cámara funcional (para usar el scanner)
- Resolución mínima recomendada: 360x640 (móvil) o 1280x720 (desktop)

**Para Administradores:**
- Navegador web moderno
- Conexión a internet estable
- Resolución recomendada: 1366x768 o superior

## 7.2. Tecnologías Utilizadas

El sistema está construido con:
- **Backend**: PHP 8.1+
- **Base de Datos**: MySQL 8.0+
- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Librerías**: Chart.js (gráficos), HTML5-QRCode (scanner)
- **Servidor Web**: Apache 2.4+ o Nginx

## 7.3. Estructura de Archivos

```
tiendas_v3/
├── admin/              # Panel de administración
│   ├── api/           # APIs del admin
│   ├── includes/      # Componentes reutilizables
│   └── *.php          # Páginas del admin
├── cliente/           # Módulo de cliente
│   ├── api/          # APIs del cliente
│   └── *.php         # Páginas del cliente
├── config/           # Configuración
│   ├── database.php  # Conexión a BD
│   └── functions.php # Funciones auxiliares
├── assets/           # Recursos estáticos
│   ├── css/         # Estilos
│   ├── js/          # Scripts
│   └── images/      # Imágenes del sistema
├── uploads/          # Archivos subidos
│   └── productos/   # Imágenes de productos
└── index.php        # Página de inicio
```

## 7.4. Seguridad

El sistema implementa varias medidas de seguridad:
- **Contraseñas encriptadas** usando `password_hash()` de PHP
- **Prepared statements** para prevenir inyección SQL
- **Validación de entrada** en cliente y servidor
- **Control de sesiones** con tokens seguros
- **Permisos de archivos** configurados correctamente

---

# 8. Contacto y Soporte

Para soporte técnico, consultas o reportar problemas:

**Administrador del Sistema**: Contacte al responsable de TI de su establecimiento.

**Soporte Técnico**: Consulte con el proveedor que instaló el sistema.

**Documentación Adicional**: Revise los archivos `.md` incluidos en el paquete del sistema para guías específicas de instalación y configuración.

---

**Fin del Manual de Usuario**

*Este documento fue generado por Manus AI - Diciembre 2025*
