# Manual de Usuario - Panel de Administración

## 1. Introducción

Este manual detalla las funcionalidades del **Panel de Administración** del Sistema de Tiendas V3.0. Está diseñado para administradores, comerciales y colaboradores, explicando cómo gestionar el sistema de manera eficiente.

## 2. Acceso al Panel

1.  **URL de Acceso**: `http://tu-dominio.com/admin/`
2.  **Credenciales**: Ingrese su usuario y contraseña.

<img src="https://i.imgur.com/1b1b1b1.png" alt="Login de Admin" width="600"/>

## 3. Roles de Usuario

El sistema cuenta con 3 roles con diferentes niveles de acceso:

| Rol | Permisos |
|---|---|
| **Administrador** | ✅ Acceso total a todos los módulos |
| **Comercial** | ✅ Productos, promociones, mensajes, compras |
| **Colaborador** | ✅ Ver productos y compras (solo lectura) |

## 4. Dashboard Principal

Al ingresar, verá un dashboard con estadísticas clave:

-   **Gráficos interactivos**: Ventas por día, productos más vendidos, etc.
-   **Resumen rápido**: Total de ventas, clientes nuevos, etc.

<img src="https://i.imgur.com/6f6f6f6.png" alt="Dashboard de Admin" width="800"/>

## 5. Gestión de Productos

Aquí puede administrar todo el catálogo de productos.

### 5.1. Agregar un Nuevo Producto

1.  **Click en "➕ Nuevo Producto"**.
2.  **Complete el formulario**:
    -   **Código de Barras**: Escríbalo o use el botón **"📷 Escanear"** para leerlo con la cámara.
    -   **Nombre**, **Descripción**, **Precio**, **Stock**, **Categoría**.
    -   **Imagen**: Suba una foto del producto.
    -   **Activo**: Marque si el producto está disponible para la venta.
3.  **Click en "Guardar"**.

<img src="https://i.imgur.com/0h0h0h0.png" alt="Formulario de Producto con Scanner" width="700"/>

### 5.2. Editar y Eliminar Productos

-   **Editar**: Click en el ícono `✏️` para modificar un producto.
-   **Eliminar**: Click en el ícono `🗑️` para borrar un producto.

## 6. Gestión de Clientes (Solo Admin)

-   **Ver listado**: Todos los clientes registrados.
-   **Editar**: Modificar datos de un cliente.
-   **Eliminar**: Borrar un cliente del sistema.

## 7. Gestión de Promociones (Admin y Comercial)

Cree y gestione promociones que aparecen en el dashboard del cliente.

1.  **Click en "Nueva Promoción"**.
2.  **Complete el formulario**:
    -   **Título** y **Descripción**.
    -   **Imagen** (opcional).
    -   **Activa**: Marque para que sea visible.
3.  **Click en "Guardar"**.

## 8. Mensajes Emergentes (Admin y Comercial)

Envíe popups automáticos a los clientes.

1.  **Click en "Nuevo Mensaje"**.
2.  **Complete el formulario**:
    -   **Mensaje**: El texto que se mostrará.
    -   **Tipo**: Oferta, Promoción, Anuncio o Alerta.
    -   **Activo**: Marque para que se muestre.
3.  **Click en "Guardar"**.

<img src="https://i.imgur.com/4f4f4f4.png" alt="Ejemplo de Popup" width="500"/>

## 9. Gestión de Compras

Vea todas las compras realizadas por los clientes.

-   **Filtros**: Por estado (finalizadas, activas) y por fecha.
-   **Detalles**: Click en una compra para ver los productos, cantidades y subtotales.

## 10. Gestión de Usuarios (Solo Admin)

-   **Crear nuevos usuarios**: Administradores, comerciales o colaboradores.
-   **Asignar roles** y contraseñas.
-   **Editar y eliminar** usuarios.

## 11. Reportes (Solo Admin)

-   **Ventas por período**: Día, semana, mes.
-   **Productos más vendidos**.
-   **Clientes con más compras**.
