<?php
/**
 * Script de Instalación para cPanel
 * Sistema de Gestión de Agua Mineral
 */

// Configuración temporal para la instalación
$temp_config = [
    'db_host' => 'localhost',
    'db_name' => 'aguadb',
    'db_user' => 'mineral',
    'db_pass' => '@gu@miner@l'
];

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalación - Sistema de Agua Mineral</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="text-center">Instalación del Sistema de Agua Mineral</h3>
                    </div>
                    <div class="card-body">
                        <?php
                        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
                            $step = $_POST['step'] ?? 1;
                            
                            if ($step == 2) {
                                // Verificar conexión a la base de datos
                                try {
                                    $dsn = "mysql:host={$temp_config['db_host']};charset=utf8mb4";
                                    $pdo = new PDO($dsn, $temp_config['db_user'], $temp_config['db_pass']);
                                    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
                                    
                                    echo '<div class="alert alert-success">✓ Conexión a MySQL exitosa</div>';
                                    
                                    // Crear base de datos si no existe
                                    $pdo->exec("CREATE DATABASE IF NOT EXISTS {$temp_config['db_name']} CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                                    echo '<div class="alert alert-success">✓ Base de datos creada/verificada</div>';
                                    
                                    // Conectar a la base de datos específica
                                    $dsn = "mysql:host={$temp_config['db_host']};dbname={$temp_config['db_name']};charset=utf8mb4";
                                    $pdo = new PDO($dsn, $temp_config['db_user'], $temp_config['db_pass']);
                                    
                                    // Leer y ejecutar el script SQL
                                    $sql_content = file_get_contents(__DIR__ . '/sql/create_database.sql');
                                    
                                    // Dividir el contenido en consultas individuales
                                    $queries = explode(';', $sql_content);
                                    
                                    foreach ($queries as $query) {
                                        $query = trim($query);
                                        if (!empty($query) && !preg_match('/^(CREATE DATABASE|CREATE USER|GRANT|FLUSH|USE)/i', $query)) {
                                            try {
                                                $pdo->exec($query);
                                            } catch (PDOException $e) {
                                                // Ignorar errores de tablas que ya existen
                                                if (strpos($e->getMessage(), 'already exists') === false) {
                                                    echo '<div class="alert alert-warning">Advertencia: ' . $e->getMessage() . '</div>';
                                                }
                                            }
                                        }
                                    }
                                    
                                    echo '<div class="alert alert-success">✓ Tablas creadas exitosamente</div>';
                                    
                                    // Crear usuario administrador con contraseña hasheada
                                    $admin_password = password_hash('miner@l', PASSWORD_DEFAULT);
                                    $vendedor_password = password_hash('vendedor123', PASSWORD_DEFAULT);
                                    
                                    // Verificar si ya existe el usuario administrador
                                    $stmt = $pdo->prepare("SELECT COUNT(*) FROM usuarios WHERE usuario = 'agua'");
                                    $stmt->execute();
                                    
                                    if ($stmt->fetchColumn() == 0) {
                                        $stmt = $pdo->prepare("INSERT INTO usuarios (nombre, usuario, password, rol) VALUES (?, ?, ?, ?)");
                                        $stmt->execute(['Administrador del Sistema', 'agua', $admin_password, 'administrador']);
                                        echo '<div class="alert alert-success">✓ Usuario administrador creado</div>';
                                    } else {
                                        echo '<div class="alert alert-info">ℹ Usuario administrador ya existe</div>';
                                    }
                                    
                                    echo '<div class="alert alert-success"><strong>¡Instalación completada exitosamente!</strong></div>';
                                    echo '<div class="mt-3">';
                                    echo '<h5>Credenciales de acceso:</h5>';
                                    echo '<p><strong>Administrador:</strong><br>';
                                    echo 'Usuario: agua<br>';
                                    echo 'Contraseña: miner@l</p>';
                                    echo '<a href="index.php" class="btn btn-primary">Ir al Sistema</a>';
                                    echo '</div>';
                                    
                                } catch (PDOException $e) {
                                    echo '<div class="alert alert-danger">Error: ' . $e->getMessage() . '</div>';
                                    echo '<a href="install.php" class="btn btn-secondary">Volver a intentar</a>';
                                }
                            }
                        } else {
                            // Mostrar formulario de instalación
                            ?>
                            <h5>Paso 1: Verificación de requisitos</h5>
                            <div class="mb-3">
                                <?php
                                $requirements = [
                                    'PHP >= 7.4' => version_compare(PHP_VERSION, '7.4.0', '>='),
                                    'Extensión PDO' => extension_loaded('pdo'),
                                    'Extensión PDO MySQL' => extension_loaded('pdo_mysql'),
                                    'Extensión mbstring' => extension_loaded('mbstring'),
                                    'Directorio writable' => is_writable(__DIR__)
                                ];
                                
                                $all_ok = true;
                                foreach ($requirements as $req => $status) {
                                    $class = $status ? 'text-success' : 'text-danger';
                                    $icon = $status ? '✓' : '✗';
                                    echo "<div class='$class'>$icon $req</div>";
                                    if (!$status) $all_ok = false;
                                }
                                ?>
                            </div>
                            
                            <h5>Configuración de la Base de Datos</h5>
                            <div class="mb-3">
                                <p><strong>Host:</strong> <?= $temp_config['db_host'] ?></p>
                                <p><strong>Base de datos:</strong> <?= $temp_config['db_name'] ?></p>
                                <p><strong>Usuario:</strong> <?= $temp_config['db_user'] ?></p>
                                <p><strong>Contraseña:</strong> <?= str_repeat('*', strlen($temp_config['db_pass'])) ?></p>
                            </div>
                            
                            <?php if ($all_ok): ?>
                                <form method="POST">
                                    <input type="hidden" name="step" value="2">
                                    <button type="submit" class="btn btn-primary">Instalar Sistema</button>
                                </form>
                            <?php else: ?>
                                <div class="alert alert-danger">
                                    Por favor, corrija los requisitos faltantes antes de continuar.
                                </div>
                            <?php endif; ?>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
