<?php
/**
 * Archivo de Inicialización del Sistema
 * Sistema de Gestión de Agua Mineral
 */

// Iniciar sesión
session_start();

// Incluir archivos de configuración
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/Database.php';
require_once __DIR__ . '/functions.php';
require_once __DIR__ . '/flash.php';
require_once __DIR__ . '/helpers.php';

// Verificar timeout de sesión
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > SESSION_TIMEOUT)) {
    session_unset();
    session_destroy();
    redirect('../index.php?error=session_expired');
}

// Actualizar tiempo de última actividad
if (isLoggedIn()) {
    $_SESSION['last_activity'] = time();
}
?>
