<?php
/**
 * Sistema de Mensajes Flash
 * Sistema de Gestión de Agua Mineral
 */

/**
 * Establecer un mensaje flash
 */
function setFlashMessage($message, $type = 'info') {
    $_SESSION['flash_message'] = [
        'text' => $message,
        'type' => $type
    ];
}

/**
 * Obtener y limpiar mensaje flash
 */
function getFlashMessage() {
    if (isset($_SESSION['flash_message'])) {
        $message = $_SESSION['flash_message'];
        unset($_SESSION['flash_message']);
        return $message;
    }
    return null;
}

/**
 * Verificar si hay mensaje flash
 */
function hasFlashMessage() {
    return isset($_SESSION['flash_message']);
}
?>
