<?php
/**
 * Configuración específica para cPanel
 * Sistema de Gestión de Agua Mineral
 */

// Esta configuración debe ser ajustada según el hosting específico

// Configuración de base de datos para cPanel
define('CPANEL_DB_HOST', 'localhost'); // Generalmente localhost en cPanel
define('CPANEL_DB_NAME', 'aguadb');    // Nombre de la base de datos
define('CPANEL_DB_USER', 'mineral');   // Usuario de la base de datos
define('CPANEL_DB_PASS', '@gu@miner@l'); // Contraseña de la base de datos

// Configuración de rutas para cPanel
define('CPANEL_BASE_PATH', '/public_html/agua-mineral/'); // Ajustar según la instalación
define('CPANEL_BASE_URL', 'https://tudominio.com/agua-mineral/'); // Ajustar según el dominio

// Configuración de email para cPanel
define('CPANEL_SMTP_HOST', 'mail.tudominio.com'); // Servidor SMTP del hosting
define('CPANEL_SMTP_PORT', 587); // Puerto SMTP (587 o 465)
define('CPANEL_SMTP_USER', 'noreply@tudominio.com'); // Email del sistema
define('CPANEL_SMTP_PASS', 'password'); // Contraseña del email

// Configuración de archivos y permisos
define('CPANEL_UPLOAD_PATH', '/public_html/agua-mineral/uploads/');
define('CPANEL_LOG_PATH', '/public_html/agua-mineral/logs/');

// Configuración de Google Maps API
define('CPANEL_GOOGLE_MAPS_API_KEY', 'TU_API_KEY_AQUI');

// Configuración de zona horaria
date_default_timezone_set('America/Argentina/Buenos_Aires');

// Configuración de errores para producción
if (defined('PRODUCTION') && PRODUCTION) {
    error_reporting(0);
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', CPANEL_LOG_PATH . 'php_errors.log');
} else {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
}

// Configuración de sesiones
ini_set('session.cookie_httponly', 1);
ini_set('session.cookie_secure', 1); // Solo si usas HTTPS
ini_set('session.use_strict_mode', 1);

// Configuración de límites PHP
ini_set('memory_limit', '128M');
ini_set('max_execution_time', 300);
ini_set('upload_max_filesize', '10M');
ini_set('post_max_size', '10M');

/**
 * Función para verificar requisitos del sistema
 */
function checkSystemRequirements() {
    $requirements = [
        'PHP Version >= 7.4' => version_compare(PHP_VERSION, '7.4.0', '>='),
        'MySQL Extension' => extension_loaded('mysqli') || extension_loaded('pdo_mysql'),
        'JSON Extension' => extension_loaded('json'),
        'Session Support' => function_exists('session_start'),
        'File Upload Support' => ini_get('file_uploads'),
        'GD Extension' => extension_loaded('gd'),
        'cURL Extension' => extension_loaded('curl'),
        'OpenSSL Extension' => extension_loaded('openssl'),
    ];
    
    $errors = [];
    foreach ($requirements as $requirement => $met) {
        if (!$met) {
            $errors[] = $requirement;
        }
    }
    
    return $errors;
}

/**
 * Función para verificar permisos de archivos
 */
function checkFilePermissions() {
    $paths = [
        CPANEL_UPLOAD_PATH => 'Directorio de uploads',
        CPANEL_LOG_PATH => 'Directorio de logs',
        __DIR__ . '/config/' => 'Directorio de configuración'
    ];
    
    $errors = [];
    foreach ($paths as $path => $description) {
        if (!is_dir($path)) {
            if (!mkdir($path, 0755, true)) {
                $errors[] = "No se puede crear el directorio: $description ($path)";
            }
        } elseif (!is_writable($path)) {
            $errors[] = "No se puede escribir en: $description ($path)";
        }
    }
    
    return $errors;
}

/**
 * Función para verificar conexión a la base de datos
 */
function checkDatabaseConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . CPANEL_DB_HOST . ";dbname=" . CPANEL_DB_NAME . ";charset=utf8mb4",
            CPANEL_DB_USER,
            CPANEL_DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return true;
    } catch (PDOException $e) {
        return "Error de conexión: " . $e->getMessage();
    }
}

/**
 * Función para optimizar configuración de PHP
 */
function optimizePHPSettings() {
    // Configuraciones de seguridad
    ini_set('expose_php', 0);
    ini_set('allow_url_fopen', 0);
    ini_set('allow_url_include', 0);
    
    // Configuraciones de rendimiento
    ini_set('realpath_cache_size', '4096K');
    ini_set('realpath_cache_ttl', 600);
    
    // Configuraciones de sesión segura
    ini_set('session.name', 'AGUAMINERALSID');
    ini_set('session.cookie_lifetime', 0);
    ini_set('session.gc_maxlifetime', 3600);
    ini_set('session.gc_probability', 1);
    ini_set('session.gc_divisor', 100);
}

// Aplicar optimizaciones
optimizePHPSettings();

/**
 * Instrucciones de instalación para cPanel
 */
/*
INSTRUCCIONES DE INSTALACIÓN EN CPANEL:

1. PREPARACIÓN:
   - Descomprimir el archivo del sistema en el directorio deseado
   - Ajustar las constantes de configuración en este archivo
   - Verificar que el dominio apunte al directorio correcto

2. BASE DE DATOS:
   - Crear una base de datos MySQL desde cPanel
   - Crear un usuario de base de datos
   - Asignar todos los privilegios al usuario
   - Ejecutar el script SQL de instalación

3. CONFIGURACIÓN:
   - Renombrar config/database.example.php a config/database.php
   - Editar config/database.php con los datos de conexión
   - Configurar la API key de Google Maps
   - Ajustar permisos de directorios (755 para directorios, 644 para archivos)

4. SEGURIDAD:
   - Cambiar las contraseñas por defecto
   - Configurar SSL/HTTPS si está disponible
   - Revisar configuraciones de .htaccess

5. PRUEBAS:
   - Acceder a install.php para verificar la instalación
   - Probar el login con las credenciales por defecto
   - Verificar todas las funcionalidades principales

6. MANTENIMIENTO:
   - Configurar backups automáticos de la base de datos
   - Monitorear logs de errores regularmente
   - Mantener el sistema actualizado
*/
?>
