<?php
// Configuración de la base de datos
define('DB_HOST', 'localhost');
define('DB_NAME', 'posadabd');
define('DB_USER', 'posadaspgy');
define('DB_PASS', 'pos@da@2025');
define('DB_CHARSET', 'utf8mb4');

// Configuración general del sistema
define('SITE_NAME', 'Sistema de Reservas - Posada');
define('SITE_URL', 'http://localhost');
define('TIMEZONE', 'America/Asuncion');

// Configuración de sesión
ini_set('session.cookie_httponly', 1);
ini_set('session.use_only_cookies', 1);
session_start();

// Zona horaria
date_default_timezone_set(TIMEZONE);

// Función para conectar a la base de datos
function getDBConnection() {
    try {
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        return $pdo;
    } catch (PDOException $e) {
        die("Error de conexión: " . $e->getMessage());
    }
}

// Función para verificar si el usuario está logueado
function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

// Función para verificar si es administrador
function isAdmin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

// Función para verificar si es huésped
function isHuesped() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'huesped';
}

// Función para redirigir
function redirect($url) {
    header("Location: $url");
    exit();
}

// Función para sanitizar entrada
function sanitize($data) {
    return htmlspecialchars(strip_tags(trim($data)));
}

// Función para formatear fecha
function formatDate($date) {
    return date('d/m/Y', strtotime($date));
}

// Función para formatear moneda
function formatMoney($amount) {
    return '₲ ' . number_format($amount, 0, ',', '.');
}
?>
