<?php
require_once '../includes/config.php';

if (!isLoggedIn() || !isAdmin()) {
    redirect('login.php');
}

$db = getDBConnection();
$mensaje = '';

// Cambiar estado de reserva
if (isset($_POST['cambiar_estado'])) {
    $reserva_id = (int)$_POST['reserva_id'];
    $nuevo_estado = $_POST['nuevo_estado'];
    
    $stmt = $db->prepare("UPDATE reservas SET estado = ? WHERE id = ?");
    $stmt->execute([$nuevo_estado, $reserva_id]);
    $mensaje = 'Estado actualizado correctamente';
}

// Eliminar reserva
if (isset($_GET['eliminar'])) {
    $reserva_id = (int)$_GET['eliminar'];
    $stmt = $db->prepare("DELETE FROM reservas WHERE id = ?");
    $stmt->execute([$reserva_id]);
    $mensaje = 'Reserva eliminada correctamente';
}

// Obtener todas las reservas
$filtro_estado = $_GET['estado'] ?? '';
$sql = "SELECT r.*, u.nombre_completo, u.cedula_pasaporte, u.telefono, t.nombre as tarifa_nombre
        FROM reservas r
        JOIN usuarios u ON r.usuario_id = u.id
        JOIN tarifas t ON r.tarifa_id = t.id";

if ($filtro_estado) {
    $sql .= " WHERE r.estado = ?";
}

$sql .= " ORDER BY r.fecha_reserva DESC";

$stmt = $db->prepare($sql);
if ($filtro_estado) {
    $stmt->execute([$filtro_estado]);
} else {
    $stmt->execute();
}
$reservas = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gestión de Reservas - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo Posada" class="logo">
                <h1 class="site-title">Gestión de Reservas</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>

    <div class="container mt-3">
        <?php if ($mensaje): ?>
            <div class="alert alert-success"><?php echo $mensaje; ?></div>
        <?php endif; ?>

        <div class="card">
            <div class="card-header d-flex justify-between align-center">
                <h2 class="card-title">📅 Todas las Reservas</h2>
                <div>
                    <select onchange="window.location.href='?estado='+this.value" class="form-control" style="display: inline-block; width: auto;">
                        <option value="">Todos los estados</option>
                        <option value="pendiente" <?php echo $filtro_estado == 'pendiente' ? 'selected' : ''; ?>>Pendiente</option>
                        <option value="confirmada" <?php echo $filtro_estado == 'confirmada' ? 'selected' : ''; ?>>Confirmada</option>
                        <option value="en_curso" <?php echo $filtro_estado == 'en_curso' ? 'selected' : ''; ?>>En Curso</option>
                        <option value="finalizada" <?php echo $filtro_estado == 'finalizada' ? 'selected' : ''; ?>>Finalizada</option>
                        <option value="cancelada" <?php echo $filtro_estado == 'cancelada' ? 'selected' : ''; ?>>Cancelada</option>
                    </select>
                </div>
            </div>
            <div class="card-body">
                <div style="overflow-x: auto;">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Huésped</th>
                                <th>Contacto</th>
                                <th>Entrada</th>
                                <th>Salida</th>
                                <th>Días</th>
                                <th>Personas</th>
                                <th>Tarifa</th>
                                <th>Costo</th>
                                <th>Estado</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($reservas as $reserva): ?>
                                <tr>
                                    <td>#<?php echo str_pad($reserva['id'], 6, '0', STR_PAD_LEFT); ?></td>
                                    <td>
                                        <?php echo htmlspecialchars($reserva['nombre_completo']); ?><br>
                                        <small><?php echo htmlspecialchars($reserva['cedula_pasaporte']); ?></small>
                                    </td>
                                    <td><?php echo htmlspecialchars($reserva['telefono']); ?></td>
                                    <td><?php echo formatDate($reserva['fecha_entrada']); ?></td>
                                    <td><?php echo formatDate($reserva['fecha_salida']); ?></td>
                                    <td><?php echo $reserva['cantidad_dias']; ?></td>
                                    <td><?php echo $reserva['cantidad_personas']; ?></td>
                                    <td><?php echo htmlspecialchars($reserva['tarifa_nombre']); ?></td>
                                    <td><?php echo formatMoney($reserva['costo_hospedaje']); ?></td>
                                    <td>
                                        <form method="POST" style="display: inline;">
                                            <input type="hidden" name="reserva_id" value="<?php echo $reserva['id']; ?>">
                                            <select name="nuevo_estado" class="form-control" style="width: auto; font-size: 0.85rem;" onchange="this.form.submit()">
                                                <option value="pendiente" <?php echo $reserva['estado'] == 'pendiente' ? 'selected' : ''; ?>>Pendiente</option>
                                                <option value="confirmada" <?php echo $reserva['estado'] == 'confirmada' ? 'selected' : ''; ?>>Confirmada</option>
                                                <option value="en_curso" <?php echo $reserva['estado'] == 'en_curso' ? 'selected' : ''; ?>>En Curso</option>
                                                <option value="finalizada" <?php echo $reserva['estado'] == 'finalizada' ? 'selected' : ''; ?>>Finalizada</option>
                                                <option value="cancelada" <?php echo $reserva['estado'] == 'cancelada' ? 'selected' : ''; ?>>Cancelada</option>
                                            </select>
                                            <button type="submit" name="cambiar_estado" style="display: none;"></button>
                                        </form>
                                    </td>
                                    <td>
                                        <a href="gastos.php?reserva_id=<?php echo $reserva['id']; ?>" class="btn btn-sm btn-info" title="Ver gastos">💰</a>
                                        <a href="?eliminar=<?php echo $reserva['id']; ?>" class="btn btn-sm btn-danger" 
                                           onclick="return confirm('¿Está seguro de eliminar esta reserva?')" title="Eliminar">🗑️</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <footer class="footer">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p>
        </div>
    </footer>

    <script src="../assets/js/main.js"></script>
</body>
</html>
