<?php
require_once '../includes/config.php';

// Si ya está logueado, redirigir al dashboard
if (isLoggedIn() && isAdmin()) {
    redirect('dashboard.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $usuario = sanitize($_POST['usuario'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($usuario) || empty($password)) {
        $error = 'Por favor complete todos los campos';
    } else {
        $db = getDBConnection();
        
        // Buscar usuario por cédula (usamos cédula como usuario)
        $stmt = $db->prepare("SELECT * FROM usuarios WHERE cedula_pasaporte = ? AND rol = 'admin' AND habilitado = 1");
        $stmt->execute([$usuario]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            // Login exitoso
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['nombre_completo'];
            $_SESSION['user_role'] = $user['rol'];
            $_SESSION['user_cedula'] = $user['cedula_pasaporte'];
            
            redirect('dashboard.php');
        } else {
            $error = 'Usuario o contraseña incorrectos';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Administrador - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <style>
        .login-container {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-primary-light) 100%);
            padding: 20px;
        }
        
        .login-box {
            background: var(--color-bg-light);
            border-radius: var(--radius);
            box-shadow: var(--shadow-lg);
            padding: 40px;
            width: 100%;
            max-width: 450px;
        }
        
        .login-logo {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-logo img {
            max-width: 120px;
            margin-bottom: 15px;
        }
        
        .login-title {
            color: var(--color-primary);
            font-size: 1.8rem;
            margin-bottom: 10px;
        }
        
        .login-subtitle {
            color: var(--color-text-light);
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <div class="login-logo">
                <img src="../assets/images/logo.png" alt="Logo Posada">
                <h1 class="login-title">Panel de Administración</h1>
                <p class="login-subtitle">Sistema de Reservas para Posadas</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-danger">
                    <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <div class="form-group">
                    <label class="form-label">Usuario</label>
                    <input type="text" name="usuario" class="form-control" 
                           placeholder="Ingrese su usuario (Posada)" 
                           value="<?php echo htmlspecialchars($_POST['usuario'] ?? ''); ?>" 
                           required autofocus>
                    <small style="color: var(--color-text-light); display: block; margin-top: 5px;">
                        Usuario por defecto: Posada
                    </small>
                </div>
                
                <div class="form-group">
                    <label class="form-label">Contraseña</label>
                    <input type="password" name="password" class="form-control" 
                           placeholder="Ingrese su contraseña" required>
                    <small style="color: var(--color-text-light); display: block; margin-top: 5px;">
                        Contraseña por defecto: Pgy.2025
                    </small>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block btn-lg">
                    Iniciar Sesión
                </button>
            </form>
            
            <div style="text-align: center; margin-top: 30px; padding-top: 20px; border-top: 1px solid var(--color-border);">
                <a href="../index.php" style="color: var(--color-primary); text-decoration: none;">
                    ← Volver al inicio
                </a>
            </div>
        </div>
    </div>
    
    <script src="../assets/js/main.js"></script>
</body>
</html>
