<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');
$db = getDBConnection();
$mensaje = '';
$stmt = $db->query("SELECT * FROM galeria ORDER BY orden, fecha_subida DESC");
$imagenes = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Galería - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Gestión de Galería</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <div class="container mt-3">
        <?php if ($mensaje): ?><div class="alert alert-success"><?php echo $mensaje; ?></div><?php endif; ?>
        <div class="card">
            <div class="card-header"><h2 class="card-title">🖼️ Galería de Imágenes</h2></div>
            <div class="card-body">
                <p style="text-align: center; padding: 20px; color: var(--color-text-light);">
                    Las imágenes actuales se encuentran en la carpeta <code>assets/images/</code><br>
                    Para agregar nuevas imágenes, suba los archivos a esa carpeta y actualice la base de datos.
                </p>
                <div class="grid grid-3">
                    <?php
                    $imagenes_estaticas = ['logo.png', 'hero-bg.jpg', 'habitacion-1.jpg', 'exterior-1.jpg', 'comedor-1.jpg'];
                    foreach ($imagenes_estaticas as $img):
                    ?>
                        <div class="card">
                            <img src="../assets/images/<?php echo $img; ?>" alt="<?php echo $img; ?>" style="width: 100%; height: 200px; object-fit: cover; border-radius: var(--radius);">
                            <div class="card-body">
                                <p style="text-align: center; margin: 10px 0;"><?php echo $img; ?></p>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <footer class="footer"><div class="container"><p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p></div></footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
