<?php
require_once '../includes/config.php';
if (!isLoggedIn() || !isAdmin()) redirect('login.php');
$db = getDBConnection();
$mensaje = '';
if (isset($_POST['guardar'])) {
    $id = (int)($_POST['id'] ?? 0);
    $nombre = sanitize($_POST['nombre']);
    $descripcion = sanitize($_POST['descripcion']);
    $activa = isset($_POST['activa']) ? 1 : 0;
    if ($id > 0) {
        $stmt = $db->prepare("UPDATE categorias_productos SET nombre=?, descripcion=?, activa=? WHERE id=?");
        $stmt->execute([$nombre, $descripcion, $activa, $id]);
        $mensaje = 'Categoría actualizada';
    } else {
        $stmt = $db->prepare("INSERT INTO categorias_productos (nombre, descripcion, activa) VALUES (?, ?, ?)");
        $stmt->execute([$nombre, $descripcion, $activa]);
        $mensaje = 'Categoría creada';
    }
}
if (isset($_GET['eliminar'])) {
    $stmt = $db->prepare("DELETE FROM categorias_productos WHERE id = ?");
    $stmt->execute([(int)$_GET['eliminar']]);
    $mensaje = 'Categoría eliminada';
}
$stmt = $db->query("SELECT * FROM categorias_productos ORDER BY nombre");
$categorias = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Categorías - <?php echo SITE_NAME; ?></title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <div class="header-content">
            <div class="logo-container">
                <img src="../assets/images/logo.png" alt="Logo" class="logo">
                <h1 class="site-title">Gestión de Categorías</h1>
            </div>
            <nav>
                <ul class="nav-menu">
                    <li><a href="dashboard.php">← Dashboard</a></li>
                    <li><a href="logout.php">Cerrar Sesión</a></li>
                </ul>
            </nav>
        </div>
    </header>
    <div class="container mt-3">
        <?php if ($mensaje): ?><div class="alert alert-success"><?php echo $mensaje; ?></div><?php endif; ?>
        <div class="grid grid-2">
            <div class="card">
                <div class="card-header"><h3 class="card-title">Nueva Categoría</h3></div>
                <div class="card-body">
                    <form method="POST">
                        <input type="hidden" name="id">
                        <div class="form-group">
                            <label class="form-label">Nombre</label>
                            <input type="text" name="nombre" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label">Descripción</label>
                            <textarea name="descripcion" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label><input type="checkbox" name="activa" checked> Activa</label>
                        </div>
                        <button type="submit" name="guardar" class="btn btn-primary btn-block">Guardar</button>
                    </form>
                </div>
            </div>
            <div class="card">
                <div class="card-header"><h3 class="card-title">Lista de Categorías</h3></div>
                <div class="card-body">
                    <table class="table">
                        <thead><tr><th>Nombre</th><th>Estado</th><th>Acciones</th></tr></thead>
                        <tbody>
                            <?php foreach ($categorias as $c): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($c['nombre']); ?></td>
                                    <td><?php echo $c['activa'] ? '✓' : '✗'; ?></td>
                                    <td><a href="?eliminar=<?php echo $c['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('¿Eliminar?')">🗑️</a></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <footer class="footer"><div class="container"><p>&copy; <?php echo date('Y'); ?> Sistema de Reservas para Posadas.</p></div></footer>
    <script src="../assets/js/main.js"></script>
</body>
</html>
