<?php
/**
 * Archivo de Prueba de Rutas
 * Sistema de Administración de Veterinaria
 * 
 * Este archivo sirve para verificar que las rutas se calculen correctamente
 * desde cualquier ubicación del proyecto.
 * 
 * ELIMINAR ESTE ARCHIVO EN PRODUCCIÓN
 */

require_once 'config/config.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Prueba de Rutas - <?php echo APP_NAME; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <h1>Verificación de Rutas del Sistema</h1>
        <p class="text-muted">Este archivo sirve para verificar que todas las rutas se calculen correctamente.</p>
        
        <div class="alert alert-warning">
            <strong>Importante:</strong> Elimine este archivo en producción por seguridad.
        </div>
        
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0">Información del Sistema</h5>
            </div>
            <div class="card-body">
                <table class="table table-bordered">
                    <tr>
                        <th width="30%">Constante</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td><code>BASE_PATH</code></td>
                        <td><?php echo BASE_PATH; ?></td>
                    </tr>
                    <tr>
                        <td><code>BASE_URL</code></td>
                        <td><?php echo BASE_URL; ?></td>
                    </tr>
                    <tr>
                        <td><code>CONFIG_PATH</code></td>
                        <td><?php echo CONFIG_PATH; ?></td>
                    </tr>
                    <tr>
                        <td><code>INCLUDES_PATH</code></td>
                        <td><?php echo INCLUDES_PATH; ?></td>
                    </tr>
                    <tr>
                        <td><code>UPLOADS_PATH</code></td>
                        <td><?php echo UPLOADS_PATH; ?></td>
                    </tr>
                    <tr>
                        <td><code>ASSETS_PATH</code></td>
                        <td><?php echo ASSETS_PATH; ?></td>
                    </tr>
                </table>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0">Prueba de URLs</h5>
            </div>
            <div class="card-body">
                <p>Las siguientes URLs deberían funcionar correctamente:</p>
                <ul class="list-group">
                    <li class="list-group-item">
                        <strong>Login:</strong> 
                        <a href="<?php echo BASE_URL; ?>/login.php" target="_blank">
                            <?php echo BASE_URL; ?>/login.php
                        </a>
                    </li>
                    <li class="list-group-item">
                        <strong>Admin Dashboard:</strong> 
                        <a href="<?php echo BASE_URL; ?>/admin/index.php" target="_blank">
                            <?php echo BASE_URL; ?>/admin/index.php
                        </a>
                    </li>
                    <li class="list-group-item">
                        <strong>Colaborador Dashboard:</strong> 
                        <a href="<?php echo BASE_URL; ?>/colaborador/index.php" target="_blank">
                            <?php echo BASE_URL; ?>/colaborador/index.php
                        </a>
                    </li>
                    <li class="list-group-item">
                        <strong>Paciente Dashboard:</strong> 
                        <a href="<?php echo BASE_URL; ?>/paciente/index.php" target="_blank">
                            <?php echo BASE_URL; ?>/paciente/index.php
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header bg-info text-white">
                <h5 class="mb-0">Prueba de Recursos Estáticos</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <h6>Logo:</h6>
                        <img src="<?php echo BASE_URL; ?>/assets/images/logo.png" alt="Logo" class="img-fluid" style="max-height: 100px;">
                        <p class="text-muted small mt-2"><?php echo BASE_URL; ?>/assets/images/logo.png</p>
                    </div>
                    <div class="col-md-6">
                        <h6>CSS:</h6>
                        <p>
                            <a href="<?php echo BASE_URL; ?>/assets/css/style.css" target="_blank">
                                Ver style.css
                            </a>
                        </p>
                        <p class="text-muted small"><?php echo BASE_URL; ?>/assets/css/style.css</p>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header bg-secondary text-white">
                <h5 class="mb-0">Variables del Servidor</h5>
            </div>
            <div class="card-body">
                <table class="table table-sm table-bordered">
                    <tr>
                        <th width="30%">Variable</th>
                        <th>Valor</th>
                    </tr>
                    <tr>
                        <td><code>$_SERVER['SCRIPT_NAME']</code></td>
                        <td><?php echo $_SERVER['SCRIPT_NAME']; ?></td>
                    </tr>
                    <tr>
                        <td><code>$_SERVER['HTTP_HOST']</code></td>
                        <td><?php echo $_SERVER['HTTP_HOST']; ?></td>
                    </tr>
                    <tr>
                        <td><code>$_SERVER['DOCUMENT_ROOT']</code></td>
                        <td><?php echo $_SERVER['DOCUMENT_ROOT']; ?></td>
                    </tr>
                    <tr>
                        <td><code>dirname($_SERVER['SCRIPT_NAME'])</code></td>
                        <td><?php echo dirname($_SERVER['SCRIPT_NAME']); ?></td>
                    </tr>
                </table>
            </div>
        </div>
        
        <div class="alert alert-success mt-4">
            <h5>✓ Verificación Completada</h5>
            <p class="mb-0">Si puede ver esta página correctamente con el logo y los estilos, las rutas están configuradas correctamente.</p>
        </div>
        
        <div class="text-center mt-4 mb-5">
            <a href="<?php echo BASE_URL; ?>/login.php" class="btn btn-primary">
                <i class="bi bi-box-arrow-in-right"></i> Ir al Login
            </a>
        </div>
    </div>
</body>
</html>
