<?php
/**
 * Ver Detalles de Mascota - Paciente
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_rol('paciente');

$mascota_id = (int)($_GET['id'] ?? 0);
$dueno_id = $_SESSION['usuario_id'];

if ($mascota_id <= 0) {
    redirigir_con_mensaje('index.php', 'Mascota no encontrada', 'danger');
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Verificar que la mascota pertenece al dueño
    $stmt = $db->prepare("SELECT * FROM mascotas WHERE id = :id AND dueno_id = :dueno_id");
    $stmt->execute(['id' => $mascota_id, 'dueno_id' => $dueno_id]);
    $mascota = $stmt->fetch();
    
    if (!$mascota) {
        redirigir_con_mensaje('index.php', 'Mascota no encontrada', 'danger');
    }
    
    // Obtener vacunas
    $stmt = $db->prepare("SELECT v.*, u.nombre_completo as profesional_nombre
                          FROM vacunas v
                          LEFT JOIN usuarios u ON v.profesional_id = u.id
                          WHERE v.mascota_id = :mascota_id
                          ORDER BY v.fecha_aplicacion DESC");
    $stmt->execute(['mascota_id' => $mascota_id]);
    $vacunas = $stmt->fetchAll();
    
    // Obtener última visita
    $stmt = $db->prepare("SELECT v.*, u.nombre_completo as profesional_nombre
                          FROM visitas v
                          INNER JOIN usuarios u ON v.profesional_id = u.id
                          WHERE v.mascota_id = :mascota_id
                          ORDER BY v.fecha_visita DESC
                          LIMIT 1");
    $stmt->execute(['mascota_id' => $mascota_id]);
    $ultima_visita = $stmt->fetch();
    
    // Calcular edad
    $edad = '';
    if ($mascota['fecha_nacimiento']) {
        $fecha_nac = new DateTime($mascota['fecha_nacimiento']);
        $hoy = new DateTime();
        $diff = $hoy->diff($fecha_nac);
        if ($diff->y > 0) {
            $edad = $diff->y . ' año' . ($diff->y > 1 ? 's' : '');
        } else if ($diff->m > 0) {
            $edad = $diff->m . ' mes' . ($diff->m > 1 ? 'es' : '');
        } else {
            $edad = $diff->d . ' día' . ($diff->d > 1 ? 's' : '');
        }
    }
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

$titulo_pagina = 'Ficha de ' . $mascota['nombre'];

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-8">
        <h1><i class="bi bi-heart"></i> Ficha de <?php echo htmlspecialchars($mascota['nombre']); ?></h1>
    </div>
    <div class="col-md-4 text-end">
        <a href="index.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="row">
    <!-- Información de la Mascota -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-heart"></i> Información</h5>
            </div>
            <div class="card-body text-center">
                <?php if ($mascota['foto']): ?>
                    <img src="<?php echo BASE_URL; ?>/uploads/mascotas/<?php echo htmlspecialchars($mascota['foto']); ?>" 
                         class="img-fluid rounded mb-3" alt="Foto de <?php echo htmlspecialchars($mascota['nombre']); ?>"
                         style="max-height: 250px;">
                <?php else: ?>
                    <i class="bi bi-heart-fill text-muted mb-3" style="font-size: 6rem;"></i>
                <?php endif; ?>
                
                <h3><?php echo htmlspecialchars($mascota['nombre']); ?></h3>
                <p class="mb-2"><strong>Código:</strong> <code><?php echo htmlspecialchars($mascota['codigo_barras']); ?></code></p>
                <p class="mb-2"><strong>Tipo:</strong> <?php echo ucfirst($mascota['tipo_mascota']); ?></p>
                <?php if ($mascota['raza']): ?>
                    <p class="mb-2"><strong>Raza:</strong> <?php echo htmlspecialchars($mascota['raza']); ?></p>
                <?php endif; ?>
                <?php if ($edad): ?>
                    <p class="mb-2"><strong>Edad:</strong> <?php echo $edad; ?></p>
                <?php endif; ?>
                <?php if ($mascota['peso']): ?>
                    <p class="mb-2"><strong>Peso:</strong> <?php echo $mascota['peso']; ?> kg</p>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Credencial -->
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-card-heading"></i> Credencial</h5>
            </div>
            <div class="card-body text-center">
                <p class="text-muted">La credencial de su mascota contiene toda la información importante</p>
                <button class="btn btn-success" onclick="alert('Función de visualización de credencial en desarrollo')">
                    <i class="bi bi-eye"></i> Ver Credencial
                </button>
            </div>
        </div>
    </div>
    
    <!-- Vacunas y Última Visita -->
    <div class="col-md-8">
        <!-- Última Visita -->
        <?php if ($ultima_visita): ?>
            <div class="card mb-4">
                <div class="card-header bg-info text-white">
                    <h5 class="mb-0"><i class="bi bi-calendar-check"></i> Última Visita</h5>
                </div>
                <div class="card-body">
                    <p class="mb-2">
                        <strong>Fecha:</strong> <?php echo formatear_fecha($ultima_visita['fecha_visita'], true); ?>
                    </p>
                    <p class="mb-2">
                        <strong>Profesional:</strong> Dr. <?php echo htmlspecialchars($ultima_visita['profesional_nombre']); ?>
                    </p>
                    <?php if ($ultima_visita['motivo']): ?>
                        <p class="mb-2"><strong>Motivo:</strong> <?php echo htmlspecialchars($ultima_visita['motivo']); ?></p>
                    <?php endif; ?>
                    <?php if ($ultima_visita['diagnostico']): ?>
                        <p class="mb-2"><strong>Diagnóstico:</strong> <?php echo htmlspecialchars($ultima_visita['diagnostico']); ?></p>
                    <?php endif; ?>
                    <?php if ($ultima_visita['observaciones']): ?>
                        <p class="mb-2"><strong>Observaciones:</strong> <?php echo htmlspecialchars($ultima_visita['observaciones']); ?></p>
                    <?php endif; ?>
                    <?php if ($ultima_visita['proxima_cita']): ?>
                        <div class="alert alert-warning mt-3 mb-0">
                            <i class="bi bi-calendar-event"></i> 
                            <strong>Próxima cita:</strong> <?php echo formatear_fecha($ultima_visita['proxima_cita']); ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        <?php endif; ?>
        
        <!-- Calendario de Vacunación -->
        <div class="card">
            <div class="card-header bg-warning text-white">
                <h5 class="mb-0"><i class="bi bi-shield-check"></i> Calendario de Vacunación</h5>
            </div>
            <div class="card-body">
                <?php if (count($vacunas) > 0): ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Vacuna</th>
                                    <th>Fecha Aplicación</th>
                                    <th>Próxima Dosis</th>
                                    <th>Estado</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($vacunas as $vacuna): ?>
                                    <tr>
                                        <td><strong><?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></strong></td>
                                        <td><?php echo formatear_fecha($vacuna['fecha_aplicacion']); ?></td>
                                        <td>
                                            <?php if ($vacuna['proxima_dosis']): ?>
                                                <?php echo formatear_fecha($vacuna['proxima_dosis']); ?>
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if ($vacuna['proxima_dosis']): ?>
                                                <?php
                                                $proxima = new DateTime($vacuna['proxima_dosis']);
                                                $hoy = new DateTime();
                                                $vencida = $proxima < $hoy;
                                                $proxima_30 = $proxima->diff($hoy)->days <= 30 && !$vencida;
                                                ?>
                                                <?php if ($vencida): ?>
                                                    <span class="badge bg-danger">
                                                        <i class="bi bi-exclamation-triangle"></i> Vencida
                                                    </span>
                                                <?php elseif ($proxima_30): ?>
                                                    <span class="badge bg-warning">
                                                        <i class="bi bi-clock"></i> Próxima
                                                    </span>
                                                <?php else: ?>
                                                    <span class="badge bg-success">
                                                        <i class="bi bi-check-circle"></i> Al día
                                                    </span>
                                                <?php endif; ?>
                                            <?php else: ?>
                                                <span class="badge bg-success">
                                                    <i class="bi bi-check-circle"></i> Completa
                                                </span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Alertas de vacunas -->
                    <?php
                    $vacunas_vencidas = 0;
                    $vacunas_proximas = 0;
                    foreach ($vacunas as $vacuna) {
                        if ($vacuna['proxima_dosis']) {
                            $proxima = new DateTime($vacuna['proxima_dosis']);
                            $hoy = new DateTime();
                            if ($proxima < $hoy) {
                                $vacunas_vencidas++;
                            } elseif ($proxima->diff($hoy)->days <= 30) {
                                $vacunas_proximas++;
                            }
                        }
                    }
                    ?>
                    
                    <?php if ($vacunas_vencidas > 0): ?>
                        <div class="alert alert-danger mt-3">
                            <i class="bi bi-exclamation-triangle-fill"></i> 
                            <strong>¡Atención!</strong> Tiene <?php echo $vacunas_vencidas; ?> vacuna(s) vencida(s). 
                            Contacte con la veterinaria para programar una cita.
                        </div>
                    <?php endif; ?>
                    
                    <?php if ($vacunas_proximas > 0): ?>
                        <div class="alert alert-warning mt-3">
                            <i class="bi bi-clock"></i> 
                            Tiene <?php echo $vacunas_proximas; ?> vacuna(s) próxima(s) a vencer en los próximos 30 días.
                        </div>
                    <?php endif; ?>
                    
                <?php else: ?>
                    <div class="alert alert-info mb-0">
                        <i class="bi bi-info-circle"></i> No hay vacunas registradas para esta mascota
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
