<?php
/**
 * API de Cumpleaños de Mascotas
 * Sistema de Administración de Veterinaria
 */

require_once __DIR__ . '/../config/config.php';
requerir_autenticacion();

header('Content-Type: application/json');

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    echo json_encode(['error' => 'Acceso denegado']);
    exit();
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Buscar mascotas que cumplen años hoy (día y mes)
    $stmt = $db->prepare("SELECT m.id, m.nombre, m.foto, m.tipo_mascota, m.fecha_nacimiento,
                                 TIMESTAMPDIFF(YEAR, m.fecha_nacimiento, CURDATE()) as edad,
                                 d.nombre_completo as dueno_nombre,
                                 d.telefono, d.tiene_whatsapp, d.tiene_telegram
                          FROM mascotas m
                          INNER JOIN duenos d ON m.dueno_id = d.id
                          WHERE m.activo = 1
                          AND DAY(m.fecha_nacimiento) = DAY(CURDATE())
                          AND MONTH(m.fecha_nacimiento) = MONTH(CURDATE())
                          ORDER BY m.nombre ASC");
    
    $stmt->execute();
    $cumpleanos = $stmt->fetchAll();
    
    $resultados = [];
    foreach ($cumpleanos as $mascota) {
        $resultados[] = [
            'id' => $mascota['id'],
            'nombre' => $mascota['nombre'],
            'foto' => $mascota['foto'],
            'tipo' => ucfirst($mascota['tipo_mascota']),
            'edad' => (int)$mascota['edad'],
            'fecha_nacimiento' => $mascota['fecha_nacimiento'],
            'dueno_nombre' => $mascota['dueno_nombre'],
            'telefono' => $mascota['telefono'],
            'tiene_whatsapp' => (bool)$mascota['tiene_whatsapp'],
            'tiene_telegram' => (bool)$mascota['tiene_telegram']
        ];
    }
    
    echo json_encode([
        'success' => true,
        'total' => count($resultados),
        'cumpleanos' => $resultados
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'error' => 'Error al buscar cumpleaños: ' . $e->getMessage()
    ]);
}
