<?php
/**
 * Ver Detalles del Dueño
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

// Verificar que se recibió un ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: ' . BASE_URL . '/colaborador/duenos.php');
    exit();
}

$dueno_id = (int)$_GET['id'];

// Obtener datos del dueño
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT * FROM duenos WHERE id = :id");
    $stmt->execute(['id' => $dueno_id]);
    $dueno = $stmt->fetch();
    
    if (!$dueno) {
        $_SESSION['error'] = 'El dueño no existe';
        header('Location: ' . BASE_URL . '/colaborador/duenos.php');
        exit();
    }
    
    // Obtener mascotas del dueño
    $stmt = $db->prepare("SELECT * FROM mascotas WHERE dueno_id = :id ORDER BY activo DESC, nombre ASC");
    $stmt->execute(['id' => $dueno_id]);
    $mascotas = $stmt->fetchAll();
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

$titulo_pagina = 'Dueño: ' . $dueno['nombre_completo'];

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h1><i class="bi bi-person-circle"></i> <?php echo htmlspecialchars($dueno['nombre_completo']); ?></h1>
        <p class="text-muted">Cédula: <?php echo htmlspecialchars($dueno['cedula'] ?? 'No registrada'); ?></p>
    </div>
    <div class="col-md-6 text-end">
        <a href="agregar_mascota.php?dueno_id=<?php echo $dueno_id; ?>" class="btn btn-success">
            <i class="bi bi-plus-circle"></i> Agregar Mascota
        </a>
        <a href="editar_dueno.php?id=<?php echo $dueno_id; ?>" class="btn btn-warning">
            <i class="bi bi-pencil"></i> Editar
        </a>
        <a href="duenos.php" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Volver
        </a>
    </div>
</div>

<div class="row">
    <!-- Información del Dueño -->
    <div class="col-md-4">
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="bi bi-person"></i> Información Personal</h5>
            </div>
            <div class="card-body">
                <p><strong>Nombre Completo:</strong><br><?php echo htmlspecialchars($dueno['nombre_completo']); ?></p>
                <p><strong>Cédula:</strong><br><?php echo htmlspecialchars($dueno['cedula'] ?? '-'); ?></p>
                <p><strong>Teléfono:</strong><br>
                    <?php if ($dueno['tiene_whatsapp']): ?>
                        <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $dueno['telefono']); ?>" 
                           target="_blank" class="btn btn-sm btn-success">
                            <i class="bi bi-whatsapp"></i> <?php echo htmlspecialchars($dueno['telefono']); ?>
                        </a>
                    <?php elseif ($dueno['tiene_telegram']): ?>
                        <a href="https://t.me/<?php echo preg_replace('/[^0-9]/', '', $dueno['telefono']); ?>" 
                           target="_blank" class="btn btn-sm btn-info">
                            <i class="bi bi-telegram"></i> <?php echo htmlspecialchars($dueno['telefono']); ?>
                        </a>
                    <?php else: ?>
                        <?php echo htmlspecialchars($dueno['telefono']); ?>
                    <?php endif; ?>
                </p>
                <p><strong>Email:</strong><br><?php echo htmlspecialchars($dueno['email'] ?? '-'); ?></p>
                <p><strong>Dirección:</strong><br><?php echo nl2br(htmlspecialchars($dueno['direccion'] ?? '-')); ?></p>
                
                <hr>
                
                <p><strong>Usuario Portal:</strong><br><code><?php echo htmlspecialchars($dueno['usuario_paciente']); ?></code></p>
                <p><strong>Login con Cédula:</strong><br><code><?php echo htmlspecialchars($dueno['cedula']); ?></code></p>
                <p><strong>Fecha de Registro:</strong><br><?php echo $dueno['fecha_creacion'] ? date('d/m/Y H:i', strtotime($dueno['fecha_creacion'])) : 'No disponible'; ?></p>
            </div>
        </div>
    </div>
    
    <!-- Mascotas del Dueño -->
    <div class="col-md-8">
        <div class="card">
            <div class="card-header bg-success text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-heart"></i> Mascotas (<?php echo count($mascotas); ?>)</h5>
                <a href="agregar_mascota.php?dueno_id=<?php echo $dueno_id; ?>" class="btn btn-sm btn-light">
                    <i class="bi bi-plus-circle"></i> Agregar
                </a>
            </div>
            <div class="card-body">
                <?php if (count($mascotas) > 0): ?>
                    <div class="row">
                        <?php foreach ($mascotas as $mascota): ?>
                            <div class="col-md-6 mb-3">
                                <div class="card <?php echo $mascota['activo'] ? '' : 'bg-light'; ?>">
                                    <div class="card-body">
                                        <div class="d-flex align-items-start">
                                            <?php if ($mascota['foto']): ?>
                                                <img src="<?php echo BASE_URL; ?>/uploads/mascotas/<?php echo htmlspecialchars($mascota['foto']); ?>" 
                                                     alt="<?php echo htmlspecialchars($mascota['nombre']); ?>"
                                                     class="rounded-circle me-3" style="width: 60px; height: 60px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="rounded-circle bg-secondary text-white d-flex align-items-center justify-content-center me-3" 
                                                     style="width: 60px; height: 60px;">
                                                    <i class="bi bi-heart-fill fs-4"></i>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <div class="flex-grow-1">
                                                <h6 class="mb-1">
                                                    <?php echo htmlspecialchars($mascota['nombre']); ?>
                                                    <?php if (!$mascota['activo']): ?>
                                                        <span class="badge bg-secondary">Inactivo</span>
                                                    <?php endif; ?>
                                                </h6>
                                                <p class="mb-1 text-muted">
                                                    <small>
                                                        <span class="badge bg-secondary"><?php echo ucfirst($mascota['tipo_mascota']); ?></span>
                                                        <?php if ($mascota['raza']): ?>
                                                            - <?php echo htmlspecialchars($mascota['raza']); ?>
                                                        <?php endif; ?>
                                                    </small>
                                                </p>
                                                <p class="mb-1"><small><strong>Código:</strong> <?php echo htmlspecialchars($mascota['codigo_barras']); ?></small></p>
                                                
                                                <div class="btn-group btn-group-sm mt-2" role="group">
                                                    <a href="ver_mascota.php?id=<?php echo $mascota['id']; ?>" class="btn btn-outline-info">
                                                        <i class="bi bi-eye"></i> Ver
                                                    </a>
                                                    <a href="nueva_visita.php?mascota_id=<?php echo $mascota['id']; ?>" class="btn btn-outline-success">
                                                        <i class="bi bi-plus-circle"></i> Visita
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <div class="alert alert-info">
                        <i class="bi bi-info-circle"></i> Este dueño aún no tiene mascotas registradas.
                        <a href="agregar_mascota.php?dueno_id=<?php echo $dueno_id; ?>" class="alert-link">Agregar primera mascota</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?>
