<?php
/**
 * Lista de Todas las Mascotas - Colaborador
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$titulo_pagina = 'Todas las Mascotas';

// Obtener lista de mascotas
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->query("SELECT m.*, d.nombre_completo as dueno_nombre, d.telefono as dueno_telefono
                        FROM mascotas m
                        INNER JOIN duenos d ON m.dueno_id = d.id
                        ORDER BY m.nombre ASC");
    $mascotas = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h1><i class="bi bi-heart"></i> Todas las Mascotas</h1>
        <p class="text-muted">Total: <?php echo formatear_numero(count($mascotas)); ?> mascotas registradas</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="nueva_mascota.php" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Nueva Mascota
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <!-- Campo de búsqueda -->
        <div class="mb-3">
            <input type="text" class="form-control" id="buscarMascota" 
                   placeholder="Buscar por nombre, código, dueño, teléfono...">
        </div>
        
        <div class="table-responsive">
            <table class="table table-hover" id="tablaMascotas">
                <thead>
                    <tr>
                        <th>Código</th>
                        <th>Nombre</th>
                        <th>Tipo</th>
                        <th>Raza</th>
                        <th>Edad</th>
                        <th>Dueño</th>
                        <th>Teléfono</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($mascotas as $mascota): ?>
                        <?php
                        $edad = '';
                        if ($mascota['fecha_nacimiento']) {
                            $fecha_nac = new DateTime($mascota['fecha_nacimiento']);
                            $hoy = new DateTime();
                            $diff = $hoy->diff($fecha_nac);
                            if ($diff->y > 0) {
                                $edad = $diff->y . ' año' . ($diff->y > 1 ? 's' : '');
                            } else {
                                $edad = $diff->m . ' mes' . ($diff->m > 1 ? 'es' : '');
                            }
                        }
                        ?>
                        <tr>
                            <td><code><?php echo htmlspecialchars($mascota['codigo_barras']); ?></code></td>
                            <td>
                                <strong><?php echo htmlspecialchars($mascota['nombre']); ?></strong>
                                <?php if ($mascota['foto']): ?>
                                    <i class="bi bi-image text-primary" title="Tiene foto"></i>
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="badge bg-secondary"><?php echo ucfirst($mascota['tipo_mascota']); ?></span>
                            </td>
                            <td><?php echo htmlspecialchars($mascota['raza'] ?? '-'); ?></td>
                            <td><?php echo $edad ?: '-'; ?></td>
                            <td><?php echo htmlspecialchars($mascota['dueno_nombre']); ?></td>
                            <td><?php echo htmlspecialchars($mascota['dueno_telefono']); ?></td>
                            <td>
                                <?php if ($mascota['activo']): ?>
                                    <span class="badge bg-success">Activo</span>
                                <?php else: ?>
                                    <span class="badge bg-secondary">Inactivo</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="ver_mascota.php?id=<?php echo $mascota['id']; ?>" 
                                       class="btn btn-sm btn-info" title="Ver detalles">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="editar_mascota.php?id=<?php echo $mascota['id']; ?>" 
                                       class="btn btn-sm btn-warning" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="nueva_visita.php?mascota_id=<?php echo $mascota['id']; ?>" 
                                       class="btn btn-sm btn-success" title="Nueva visita">
                                        <i class="bi bi-plus-circle"></i>
                                    </a>
                                    <?php if ($mascota['activo']): ?>
                                    <a href="eliminar_mascota.php?id=<?php echo $mascota['id']; ?>" 
                                       class="btn btn-sm btn-danger" title="Eliminar"
                                       onclick="return confirm('¿Está seguro de eliminar a <?php echo htmlspecialchars($mascota['nombre']); ?>?');">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
// Implementar búsqueda en la tabla
document.getElementById('buscarMascota').addEventListener('keyup', function() {
    const filtro = this.value.toLowerCase();
    const filas = document.querySelectorAll('#tablaMascotas tbody tr');
    
    filas.forEach(function(fila) {
        const texto = fila.textContent.toLowerCase();
        fila.style.display = texto.includes(filtro) ? '' : 'none';
    });
});
</script>

<?php include '../includes/footer.php'; ?>
