<?php
/**
 * Dashboard del Colaborador
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

// Permitir acceso a administradores y colaboradores
if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$titulo_pagina = 'Dashboard - Colaborador';

try {
    $db = Database::getInstance()->getConnection();
    
    // Estadísticas del día
    $stmt = $db->query("SELECT COUNT(*) as total FROM visitas WHERE DATE(fecha_visita) = CURDATE()");
    $visitas_hoy = $stmt->fetch()['total'];
    
    $stmt = $db->query("SELECT COUNT(*) as total FROM mascotas WHERE activo = 1");
    $total_mascotas = $stmt->fetch()['total'];
    
    // Próximas citas de hoy
    $stmt = $db->query("SELECT v.*, m.nombre as mascota_nombre, m.tipo_mascota, d.nombre_completo as dueno_nombre, d.telefono
                        FROM visitas v
                        INNER JOIN mascotas m ON v.mascota_id = m.id
                        INNER JOIN duenos d ON m.dueno_id = d.id
                        WHERE v.proxima_cita = CURDATE()
                        ORDER BY v.proxima_cita ASC");
    $citas_hoy = $stmt->fetchAll();
    
    // Vacunas próximas a vencer (próximos 15 días)
    $stmt = $db->query("SELECT v.*, m.nombre as mascota_nombre, m.tipo_mascota, d.nombre_completo as dueno_nombre, d.telefono, d.tiene_whatsapp
                        FROM vacunas v
                        INNER JOIN mascotas m ON v.mascota_id = m.id
                        INNER JOIN duenos d ON m.dueno_id = d.id
                        WHERE v.proxima_dosis BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 15 DAY)
                        ORDER BY v.proxima_dosis ASC");
    $vacunas_proximas = $stmt->fetchAll();
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <h1><i class="bi bi-house"></i> Bienvenido, <?php echo htmlspecialchars($_SESSION['nombre']); ?></h1>
        <p class="text-muted">Panel de trabajo del colaborador</p>
    </div>
</div>

<!-- Accesos rápidos -->
<div class="row mb-4">
    <div class="col-md-3">
        <a href="nueva_mascota.php" class="card text-decoration-none hover-card">
            <div class="card-body text-center">
                <i class="bi bi-plus-circle fs-1 text-primary"></i>
                <h5 class="mt-2">Nueva Mascota</h5>
            </div>
        </a>
    </div>
    <div class="col-md-3">
        <a href="nueva_visita.php" class="card text-decoration-none hover-card">
            <div class="card-body text-center">
                <i class="bi bi-calendar-plus fs-1 text-success"></i>
                <h5 class="mt-2">Nueva Visita</h5>
            </div>
        </a>
    </div>
    <div class="col-md-3">
        <a href="buscar.php" class="card text-decoration-none hover-card">
            <div class="card-body text-center">
                <i class="bi bi-search fs-1 text-info"></i>
                <h5 class="mt-2">Buscar</h5>
            </div>
        </a>
    </div>
    <div class="col-md-3">
        <a href="mascotas.php" class="card text-decoration-none hover-card">
            <div class="card-body text-center">
                <i class="bi bi-heart fs-1 text-danger"></i>
                <h5 class="mt-2">Todas las Mascotas</h5>
                <p class="mb-0"><strong><?php echo formatear_numero($total_mascotas); ?></strong> registradas</p>
            </div>
        </a>
    </div>
</div>

<!-- Estadísticas del día -->
<div class="row mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-body">
                <h5 class="card-title"><i class="bi bi-calendar-check"></i> Resumen de Hoy</h5>
                <div class="row text-center">
                    <div class="col-md-4">
                        <h3 class="text-primary"><?php echo formatear_numero($visitas_hoy); ?></h3>
                        <p class="text-muted">Visitas Realizadas</p>
                    </div>
                    <div class="col-md-4">
                        <h3 class="text-success"><?php echo formatear_numero(count($citas_hoy)); ?></h3>
                        <p class="text-muted">Citas Programadas</p>
                    </div>
                    <div class="col-md-4">
                        <h3 class="text-warning"><?php echo formatear_numero(count($vacunas_proximas)); ?></h3>
                        <p class="text-muted">Vacunas Próximas (15 días)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <!-- Citas de Hoy -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="bi bi-calendar-event"></i> Citas de Hoy</h5>
            </div>
            <div class="card-body">
                <?php if (count($citas_hoy) > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($citas_hoy as $cita): ?>
                            <div class="list-group-item">
                                <div class="d-flex w-100 justify-content-between align-items-center">
                                    <div>
                                        <h6 class="mb-1">
                                            <i class="bi bi-<?php echo $cita['tipo_mascota'] === 'perro' ? 'heart' : ($cita['tipo_mascota'] === 'gato' ? 'heart-fill' : 'heart'); ?>"></i>
                                            <?php echo htmlspecialchars($cita['mascota_nombre']); ?>
                                        </h6>
                                        <p class="mb-1"><small>Dueño: <?php echo htmlspecialchars($cita['dueno_nombre']); ?></small></p>
                                        <small class="text-muted">Tel: <?php echo htmlspecialchars($cita['telefono']); ?></small>
                                    </div>
                                    <div>
                                        <a href="ver_mascota.php?id=<?php echo $cita['mascota_id']; ?>" class="btn btn-sm btn-primary">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No hay citas programadas para hoy</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Vacunas Próximas -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header bg-warning text-white">
                <h5 class="mb-0"><i class="bi bi-shield-check"></i> Vacunas Próximas (15 días)</h5>
            </div>
            <div class="card-body">
                <?php if (count($vacunas_proximas) > 0): ?>
                    <div class="list-group list-group-flush">
                        <?php foreach ($vacunas_proximas as $vacuna): ?>
                            <div class="list-group-item">
                                <div class="d-flex w-100 justify-content-between">
                                    <div>
                                        <h6 class="mb-1"><?php echo htmlspecialchars($vacuna['mascota_nombre']); ?></h6>
                                        <p class="mb-1"><small>Vacuna: <?php echo htmlspecialchars($vacuna['nombre_vacuna']); ?></small></p>
                                        <small class="text-muted">
                                            <?php echo htmlspecialchars($vacuna['dueno_nombre']); ?> - 
                                            <?php echo htmlspecialchars($vacuna['telefono']); ?>
                                            <?php if ($vacuna['tiene_whatsapp']): ?>
                                                <a href="<?php echo crear_enlace_whatsapp($vacuna['telefono']); ?>" target="_blank" class="text-success">
                                                    <i class="bi bi-whatsapp"></i>
                                                </a>
                                            <?php endif; ?>
                                        </small>
                                    </div>
                                    <div>
                                        <span class="badge bg-warning"><?php echo formatear_fecha($vacuna['proxima_dosis']); ?></span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center mb-0">No hay vacunas próximas a vencer</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
.hover-card {
    transition: transform 0.2s, box-shadow 0.2s;
}
.hover-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.2);
}
</style>

<?php include '../includes/footer.php'; ?>
