<?php
/**
 * Generar Credencial de Mascota con Código de Barras
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$mascota_id = (int)($_GET['id'] ?? 0);

if ($mascota_id <= 0) {
    die('Mascota no encontrada');
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Obtener datos de la mascota y dueño
    $stmt = $db->prepare("SELECT m.*, d.nombre_completo as dueno_nombre, d.telefono, d.direccion
                          FROM mascotas m
                          INNER JOIN duenos d ON m.dueno_id = d.id
                          WHERE m.id = :id");
    $stmt->execute(['id' => $mascota_id]);
    $mascota = $stmt->fetch();
    
    if (!$mascota) {
        die('Mascota no encontrada');
    }
    
    // Calcular edad
    $edad = '';
    if ($mascota['fecha_nacimiento']) {
        $fecha_nac = new DateTime($mascota['fecha_nacimiento']);
        $hoy = new DateTime();
        $diff = $hoy->diff($fecha_nac);
        if ($diff->y > 0) {
            $edad = $diff->y . ' año' . ($diff->y > 1 ? 's' : '');
        } else if ($diff->m > 0) {
            $edad = $diff->m . ' mes' . ($diff->m > 1 ? 'es' : '');
        }
    }
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Credencial - <?php echo htmlspecialchars($mascota['nombre']); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
    <style>
        @media print {
            .no-print {
                display: none;
            }
            body {
                background: white;
            }
        }
        
        .credencial {
            width: 85.6mm;
            height: 54mm;
            border: 2px solid #5fa89c;
            border-radius: 10px;
            padding: 10px;
            background: linear-gradient(135deg, #ffffff 0%, #f8f9fa 100%);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            margin: 20px auto;
            position: relative;
            overflow: hidden;
        }
        
        .credencial::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 15px;
            background: linear-gradient(135deg, #5fa89c 0%, #4a8a7f 100%);
        }
        
        .credencial-header {
            text-align: center;
            margin-top: 5px;
            margin-bottom: 8px;
        }
        
        .credencial-header img {
            height: 30px;
        }
        
        .credencial-body {
            display: flex;
            gap: 10px;
        }
        
        .credencial-foto {
            flex-shrink: 0;
        }
        
        .credencial-foto img {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 8px;
            border: 2px solid #5fa89c;
        }
        
        .credencial-info {
            flex-grow: 1;
            font-size: 9px;
        }
        
        .credencial-info h5 {
            font-size: 14px;
            margin: 0 0 3px 0;
            color: #5fa89c;
            font-weight: bold;
        }
        
        .credencial-info p {
            margin: 0;
            line-height: 1.3;
        }
        
        .credencial-barcode {
            text-align: center;
            margin-top: 5px;
        }
        
        .credencial-barcode svg {
            height: 30px;
        }
    </style>
</head>
<body>
    <div class="container mt-4">
        <div class="text-center mb-3 no-print">
            <h3>Credencial de Mascota</h3>
            <button onclick="window.print()" class="btn btn-primary">
                <i class="bi bi-printer"></i> Imprimir Credencial
            </button>
            <a href="ver_mascota.php?id=<?php echo $mascota_id; ?>" class="btn btn-secondary">
                <i class="bi bi-arrow-left"></i> Volver
            </a>
        </div>
        
        <div class="credencial">
            <div class="credencial-header">
                <img src="<?php echo BASE_URL; ?>/assets/images/logo.png" alt="Logo">
            </div>
            
            <div class="credencial-body">
                <div class="credencial-foto">
                    <?php if ($mascota['foto']): ?>
                        <img src="<?php echo BASE_URL; ?>/uploads/mascotas/<?php echo htmlspecialchars($mascota['foto']); ?>" 
                             alt="Foto de <?php echo htmlspecialchars($mascota['nombre']); ?>">
                    <?php else: ?>
                        <div style="width: 60px; height: 60px; background: #f0f0f0; border-radius: 8px; display: flex; align-items: center; justify-content: center; border: 2px solid #5fa89c;">
                            <i class="bi bi-heart-fill" style="font-size: 30px; color: #5fa89c;"></i>
                        </div>
                    <?php endif; ?>
                </div>
                
                <div class="credencial-info">
                    <h5><?php echo htmlspecialchars($mascota['nombre']); ?></h5>
                    <p><strong>Tipo:</strong> <?php echo ucfirst($mascota['tipo_mascota']); ?></p>
                    <?php if ($mascota['raza']): ?>
                        <p><strong>Raza:</strong> <?php echo htmlspecialchars($mascota['raza']); ?></p>
                    <?php endif; ?>
                    <?php if ($edad): ?>
                        <p><strong>Edad:</strong> <?php echo $edad; ?></p>
                    <?php endif; ?>
                    <p><strong>Dueño:</strong> <?php echo htmlspecialchars($mascota['dueno_nombre']); ?></p>
                    <p><strong>Tel:</strong> <?php echo htmlspecialchars($mascota['telefono']); ?></p>
                </div>
            </div>
            
            <div class="credencial-barcode">
                <svg id="barcode"></svg>
                <div style="font-size: 8px; margin-top: 2px;">
                    <?php echo htmlspecialchars($mascota['codigo_barras']); ?>
                </div>
            </div>
        </div>
        
        <div class="text-center text-muted no-print" style="font-size: 12px;">
            <p>Esta credencial identifica a la mascota en el sistema de la veterinaria</p>
        </div>
    </div>
    
    <script>
        JsBarcode("#barcode", "<?php echo $mascota['codigo_barras']; ?>", {
            format: "CODE128",
            width: 1.5,
            height: 30,
            displayValue: false,
            margin: 0
        });
    </script>
</body>
</html>
