<?php
/**
 * Eliminar Mascota (Soft Delete)
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

// Verificar que se recibió un ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: ' . BASE_URL . '/colaborador/mascotas.php');
    exit();
}

$mascota_id = (int)$_GET['id'];

try {
    $db = Database::getInstance()->getConnection();
    
    // Verificar que la mascota existe
    $stmt = $db->prepare("SELECT id, nombre FROM mascotas WHERE id = :id");
    $stmt->execute(['id' => $mascota_id]);
    $mascota = $stmt->fetch();
    
    if (!$mascota) {
        $_SESSION['error'] = 'La mascota no existe';
        header('Location: ' . BASE_URL . '/colaborador/mascotas.php');
        exit();
    }
    
    // Soft delete: marcar como inactivo
    $stmt = $db->prepare("UPDATE mascotas SET activo = 0 WHERE id = :id");
    $stmt->execute(['id' => $mascota_id]);
    
    $_SESSION['exito'] = 'Mascota "' . htmlspecialchars($mascota['nombre']) . '" eliminada exitosamente';
    
} catch (PDOException $e) {
    $_SESSION['error'] = 'Error al eliminar la mascota: ' . $e->getMessage();
}

header('Location: ' . BASE_URL . '/colaborador/mascotas.php');
exit();
