<?php
/**
 * Editar Mascota
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$mascota_id = (int)($_GET['id'] ?? 0);

if ($mascota_id <= 0) {
    redirigir_con_mensaje('mascotas.php', 'Mascota no encontrada', 'danger');
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Obtener datos de la mascota
    $stmt = $db->prepare("SELECT m.*, d.* FROM mascotas m INNER JOIN duenos d ON m.dueno_id = d.id WHERE m.id = :id");
    $stmt->execute(['id' => $mascota_id]);
    $mascota = $stmt->fetch();
    
    if (!$mascota) {
        redirigir_con_mensaje('mascotas.php', 'Mascota no encontrada', 'danger');
    }
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $db->beginTransaction();
        
        // Actualizar datos del dueño
        $dueno_nombre = limpiar_entrada($_POST['dueno_nombre']);
        $dueno_cedula = limpiar_entrada($_POST['dueno_cedula']);
        $dueno_direccion = limpiar_entrada($_POST['dueno_direccion']);
        $dueno_telefono = limpiar_entrada($_POST['dueno_telefono']);
        $tiene_whatsapp = isset($_POST['tiene_whatsapp']) ? 1 : 0;
        $tiene_telegram = isset($_POST['tiene_telegram']) ? 1 : 0;
        $dueno_email = limpiar_entrada($_POST['dueno_email']);
        
        $stmt = $db->prepare("UPDATE duenos SET nombre_completo = :nombre, cedula = :cedula, 
                              direccion = :direccion, telefono = :telefono, tiene_whatsapp = :whatsapp, 
                              tiene_telegram = :telegram, email = :email WHERE id = :id");
        $stmt->execute([
            'nombre' => $dueno_nombre,
            'cedula' => $dueno_cedula,
            'direccion' => $dueno_direccion,
            'telefono' => $dueno_telefono,
            'whatsapp' => $tiene_whatsapp,
            'telegram' => $tiene_telegram,
            'email' => $dueno_email,
            'id' => $mascota['dueno_id']
        ]);
        
        // Actualizar datos de la mascota
        $nombre_mascota = limpiar_entrada($_POST['nombre_mascota']);
        $tipo_mascota = limpiar_entrada($_POST['tipo_mascota']);
        $raza = limpiar_entrada($_POST['raza']);
        $fecha_nacimiento = $_POST['fecha_nacimiento'];
        $peso = !empty($_POST['peso']) ? (float)$_POST['peso'] : null;
        $activo = isset($_POST['activo']) ? 1 : 0;
        
        // Procesar foto si se subió una nueva
        $foto_path = $mascota['foto'];
        if (isset($_FILES['foto']) && $_FILES['foto']['error'] === UPLOAD_ERR_OK) {
            $resultado = subir_archivo($_FILES['foto'], 'mascotas');
            if ($resultado['success']) {
                // Eliminar foto anterior si existe
                if ($mascota['foto']) {
                    $ruta_anterior = __DIR__ . '/../uploads/' . $mascota['foto'];
                    if (file_exists($ruta_anterior)) {
                        unlink($ruta_anterior);
                    }
                }
                $foto_path = $resultado['path'];
            }
        }
        
        $stmt = $db->prepare("UPDATE mascotas SET nombre = :nombre, tipo_mascota = :tipo, raza = :raza, 
                              fecha_nacimiento = :fecha_nac, peso = :peso, foto = :foto, activo = :activo 
                              WHERE id = :id");
        $stmt->execute([
            'nombre' => $nombre_mascota,
            'tipo' => $tipo_mascota,
            'raza' => $raza,
            'fecha_nac' => $fecha_nacimiento,
            'peso' => $peso,
            'foto' => $foto_path,
            'activo' => $activo,
            'id' => $mascota_id
        ]);
        
        $db->commit();
        
        redirigir_con_mensaje('ver_mascota.php?id=' . $mascota_id, 'Mascota actualizada exitosamente', 'success');
        
    } catch (PDOException $e) {
        $db->rollBack();
        $error = "Error al actualizar la mascota: " . $e->getMessage();
    }
}

$titulo_pagina = 'Editar ' . $mascota['nombre'];

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-12">
        <h1><i class="bi bi-pencil"></i> Editar Mascota: <?php echo htmlspecialchars($mascota['nombre']); ?></h1>
    </div>
</div>

<?php if (isset($error)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle"></i> <?php echo htmlspecialchars($error); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<form method="POST" action="" enctype="multipart/form-data">
    <div class="row">
        <!-- Datos del Dueño -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-person"></i> Datos del Dueño</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label">Nombre Completo *</label>
                        <input type="text" class="form-control" name="dueno_nombre" 
                               value="<?php echo htmlspecialchars($mascota['nombre_completo']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Cédula de Identidad</label>
                        <input type="text" class="form-control" name="dueno_cedula" 
                               value="<?php echo htmlspecialchars($mascota['cedula']); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Dirección</label>
                        <textarea class="form-control" name="dueno_direccion" rows="2"><?php echo htmlspecialchars($mascota['direccion']); ?></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Teléfono *</label>
                        <input type="text" class="form-control" name="dueno_telefono" 
                               value="<?php echo htmlspecialchars($mascota['telefono']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tiene_whatsapp" id="tiene_whatsapp" 
                                   <?php echo $mascota['tiene_whatsapp'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="tiene_whatsapp">
                                <i class="bi bi-whatsapp text-success"></i> Tiene WhatsApp
                            </label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="tiene_telegram" id="tiene_telegram" 
                                   <?php echo $mascota['tiene_telegram'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="tiene_telegram">
                                <i class="bi bi-telegram text-info"></i> Tiene Telegram
                            </label>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="dueno_email" 
                               value="<?php echo htmlspecialchars($mascota['email']); ?>">
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Datos de la Mascota -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header bg-success text-white">
                    <h5 class="mb-0"><i class="bi bi-heart"></i> Datos de la Mascota</h5>
                </div>
                <div class="card-body">
                    <?php if ($mascota['foto']): ?>
                        <div class="text-center mb-3">
                            <img src="<?php echo BASE_URL; ?>/uploads/mascotas/<?php echo htmlspecialchars($mascota['foto']); ?>" 
                                 class="img-fluid rounded" style="max-height: 200px;" alt="Foto actual">
                            <p class="text-muted mt-2"><small>Foto actual</small></p>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mb-3">
                        <label class="form-label">Nombre de la Mascota *</label>
                        <input type="text" class="form-control" name="nombre_mascota" 
                               value="<?php echo htmlspecialchars($mascota['nombre']); ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Tipo de Mascota *</label>
                        <select class="form-select" name="tipo_mascota" required>
                            <option value="">Seleccione...</option>
                            <option value="perro" <?php echo $mascota['tipo_mascota'] === 'perro' ? 'selected' : ''; ?>>Perro</option>
                            <option value="gato" <?php echo $mascota['tipo_mascota'] === 'gato' ? 'selected' : ''; ?>>Gato</option>
                            <option value="ave" <?php echo $mascota['tipo_mascota'] === 'ave' ? 'selected' : ''; ?>>Ave</option>
                            <option value="conejo" <?php echo $mascota['tipo_mascota'] === 'conejo' ? 'selected' : ''; ?>>Conejo</option>
                            <option value="hamster" <?php echo $mascota['tipo_mascota'] === 'hamster' ? 'selected' : ''; ?>>Hámster</option>
                            <option value="reptil" <?php echo $mascota['tipo_mascota'] === 'reptil' ? 'selected' : ''; ?>>Reptil</option>
                            <option value="otro" <?php echo $mascota['tipo_mascota'] === 'otro' ? 'selected' : ''; ?>>Otro</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Raza</label>
                        <input type="text" class="form-control" name="raza" 
                               value="<?php echo htmlspecialchars($mascota['raza']); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Fecha de Nacimiento</label>
                        <input type="date" class="form-control" name="fecha_nacimiento" 
                               value="<?php echo $mascota['fecha_nacimiento']; ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Peso (kg)</label>
                        <input type="number" class="form-control" name="peso" step="0.01" 
                               value="<?php echo $mascota['peso']; ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nueva Fotografía</label>
                        <input type="file" class="form-control" name="foto" accept="image/*">
                        <small class="text-muted">Dejar vacío para mantener la foto actual</small>
                    </div>
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" name="activo" id="activo" 
                                   <?php echo $mascota['activo'] ? 'checked' : ''; ?>>
                            <label class="form-check-label" for="activo">
                                Mascota activa
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-body text-center">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-save"></i> Guardar Cambios
            </button>
            <a href="ver_mascota.php?id=<?php echo $mascota_id; ?>" class="btn btn-secondary btn-lg">
                <i class="bi bi-x-circle"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
