<?php
/**
 * Editar Dueño
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

// Verificar que se recibió un ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: ' . BASE_URL . '/colaborador/duenos.php');
    exit();
}

$dueno_id = (int)$_GET['id'];

// Obtener datos del dueño
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT * FROM duenos WHERE id = :id");
    $stmt->execute(['id' => $dueno_id]);
    $dueno = $stmt->fetch();
    
    if (!$dueno) {
        $_SESSION['error'] = 'El dueño no existe';
        header('Location: ' . BASE_URL . '/colaborador/duenos.php');
        exit();
    }
    
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

$titulo_pagina = 'Editar Dueño';

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $dueno_nombre = limpiar_entrada($_POST['dueno_nombre']);
        $dueno_cedula = limpiar_entrada($_POST['dueno_cedula']);
        $dueno_direccion = limpiar_entrada($_POST['dueno_direccion']);
        $dueno_telefono = limpiar_entrada($_POST['dueno_telefono']);
        $tiene_whatsapp = isset($_POST['tiene_whatsapp']) ? 1 : 0;
        $tiene_telegram = isset($_POST['tiene_telegram']) ? 1 : 0;
        $dueno_email = limpiar_entrada($_POST['dueno_email']);
        
        $stmt = $db->prepare("UPDATE duenos SET nombre_completo = :nombre, cedula = :cedula, 
                              direccion = :direccion, telefono = :telefono, tiene_whatsapp = :whatsapp, 
                              tiene_telegram = :telegram, email = :email 
                              WHERE id = :id");
        $stmt->execute([
            'nombre' => $dueno_nombre,
            'cedula' => $dueno_cedula,
            'direccion' => $dueno_direccion,
            'telefono' => $dueno_telefono,
            'whatsapp' => $tiene_whatsapp,
            'telegram' => $tiene_telegram,
            'email' => $dueno_email,
            'id' => $dueno_id
        ]);
        
        $_SESSION['exito'] = 'Dueño actualizado exitosamente';
        header('Location: ver_dueno.php?id=' . $dueno_id);
        exit();
        
    } catch (PDOException $e) {
        $error = 'Error al actualizar el dueño: ' . $e->getMessage();
    }
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-12">
        <h1><i class="bi bi-pencil"></i> Editar Dueño</h1>
        <p class="text-muted"><?php echo htmlspecialchars($dueno['nombre_completo']); ?></p>
    </div>
</div>

<?php if (isset($error)): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle"></i> <?php echo $error; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<form method="POST" action="">
    <div class="card">
        <div class="card-header bg-primary text-white">
            <h5 class="mb-0"><i class="bi bi-person"></i> Datos del Dueño</h5>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Nombre Completo *</label>
                        <input type="text" class="form-control" name="dueno_nombre" 
                               value="<?php echo htmlspecialchars($dueno['nombre_completo']); ?>" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Cédula de Identidad</label>
                        <input type="text" class="form-control" name="dueno_cedula" 
                               value="<?php echo htmlspecialchars($dueno['cedula'] ?? ''); ?>">
                    </div>
                </div>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Teléfono *</label>
                        <input type="text" class="form-control" name="dueno_telefono" 
                               value="<?php echo htmlspecialchars($dueno['telefono']); ?>" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" class="form-control" name="dueno_email" 
                               value="<?php echo htmlspecialchars($dueno['email'] ?? ''); ?>">
                    </div>
                </div>
            </div>
            
            <div class="mb-3">
                <label class="form-label">Dirección</label>
                <textarea class="form-control" name="dueno_direccion" rows="2"><?php echo htmlspecialchars($dueno['direccion'] ?? ''); ?></textarea>
            </div>
            
            <div class="row">
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="tiene_whatsapp" id="tiene_whatsapp"
                               <?php echo $dueno['tiene_whatsapp'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="tiene_whatsapp">
                            <i class="bi bi-whatsapp text-success"></i> Tiene WhatsApp
                        </label>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" name="tiene_telegram" id="tiene_telegram"
                               <?php echo $dueno['tiene_telegram'] ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="tiene_telegram">
                            <i class="bi bi-telegram text-info"></i> Tiene Telegram
                        </label>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card mt-3">
        <div class="card-body text-center">
            <button type="submit" class="btn btn-primary btn-lg">
                <i class="bi bi-save"></i> Guardar Cambios
            </button>
            <a href="ver_dueno.php?id=<?php echo $dueno_id; ?>" class="btn btn-secondary btn-lg">
                <i class="bi bi-x-circle"></i> Cancelar
            </a>
        </div>
    </div>
</form>

<?php include '../includes/footer.php'; ?>
