<?php
/**
 * Lista de Dueños - Colaborador
 * Sistema de Administración de Veterinaria
 */

require_once '../config/config.php';
requerir_autenticacion();

if (!tiene_rol('colaborador') && !tiene_rol('administrador')) {
    header('Location: ' . BASE_URL . '/index.php');
    exit();
}

$titulo_pagina = 'Gestión de Dueños';

// Obtener lista de dueños con conteo de mascotas
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->query("SELECT d.*, COUNT(m.id) as total_mascotas
                        FROM duenos d
                        LEFT JOIN mascotas m ON d.id = m.dueno_id AND m.activo = 1
                        GROUP BY d.id
                        ORDER BY d.nombre_completo ASC");
    $duenos = $stmt->fetchAll();
} catch (PDOException $e) {
    die("Error en la base de datos: " . $e->getMessage());
}

include '../includes/header.php';
?>

<div class="row mb-4">
    <div class="col-md-6">
        <h1><i class="bi bi-people"></i> Gestión de Dueños</h1>
        <p class="text-muted">Total: <?php echo formatear_numero(count($duenos)); ?> dueños registrados</p>
    </div>
    <div class="col-md-6 text-end">
        <a href="nuevo_dueno.php" class="btn btn-primary">
            <i class="bi bi-plus-circle"></i> Nuevo Dueño
        </a>
    </div>
</div>

<?php if (isset($_SESSION['exito'])): ?>
    <div class="alert alert-success alert-dismissible fade show">
        <i class="bi bi-check-circle"></i> <?php echo $_SESSION['exito']; unset($_SESSION['exito']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show">
        <i class="bi bi-exclamation-triangle"></i> <?php echo $_SESSION['error']; unset($_SESSION['error']); ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-body">
        <!-- Campo de búsqueda -->
        <div class="mb-3">
            <input type="text" class="form-control" id="buscarDueno" 
                   placeholder="Buscar por nombre, cédula, teléfono...">
        </div>
        
        <div class="table-responsive">
            <table class="table table-hover" id="tablaDuenos">
                <thead>
                    <tr>
                        <th>Nombre Completo</th>
                        <th>Cédula</th>
                        <th>Teléfono</th>
                        <th>Email</th>
                        <th>Mascotas</th>
                        <th>Contacto</th>
                        <th>Acciones</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($duenos as $dueno): ?>
                        <tr>
                            <td><strong><?php echo htmlspecialchars($dueno['nombre_completo']); ?></strong></td>
                            <td><?php echo htmlspecialchars($dueno['cedula'] ?? '-'); ?></td>
                            <td>
                                <?php if ($dueno['telefono']): ?>
                                    <?php if ($dueno['tiene_whatsapp']): ?>
                                        <a href="https://wa.me/<?php echo preg_replace('/[^0-9]/', '', $dueno['telefono']); ?>" 
                                           target="_blank" class="btn btn-sm btn-success" title="WhatsApp">
                                            <i class="bi bi-whatsapp"></i> <?php echo htmlspecialchars($dueno['telefono']); ?>
                                        </a>
                                    <?php elseif ($dueno['tiene_telegram']): ?>
                                        <a href="https://t.me/<?php echo preg_replace('/[^0-9]/', '', $dueno['telefono']); ?>" 
                                           target="_blank" class="btn btn-sm btn-info" title="Telegram">
                                            <i class="bi bi-telegram"></i> <?php echo htmlspecialchars($dueno['telefono']); ?>
                                        </a>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($dueno['telefono']); ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    -
                                <?php endif; ?>
                            </td>
                            <td><?php echo htmlspecialchars($dueno['email'] ?? '-'); ?></td>
                            <td>
                                <span class="badge bg-primary"><?php echo $dueno['total_mascotas']; ?> mascota<?php echo $dueno['total_mascotas'] != 1 ? 's' : ''; ?></span>
                            </td>
                            <td>
                                <?php if ($dueno['tiene_whatsapp']): ?>
                                    <i class="bi bi-whatsapp text-success" title="WhatsApp"></i>
                                <?php endif; ?>
                                <?php if ($dueno['tiene_telegram']): ?>
                                    <i class="bi bi-telegram text-info" title="Telegram"></i>
                                <?php endif; ?>
                            </td>
                            <td>
                                <div class="btn-group" role="group">
                                    <a href="ver_dueno.php?id=<?php echo $dueno['id']; ?>" 
                                       class="btn btn-sm btn-info" title="Ver detalles">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    <a href="editar_dueno.php?id=<?php echo $dueno['id']; ?>" 
                                       class="btn btn-sm btn-warning" title="Editar">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    <a href="agregar_mascota.php?dueno_id=<?php echo $dueno['id']; ?>" 
                                       class="btn btn-sm btn-success" title="Agregar mascota">
                                        <i class="bi bi-plus-circle"></i>
                                    </a>
                                    <?php if ($dueno['total_mascotas'] == 0): ?>
                                    <a href="eliminar_dueno.php?id=<?php echo $dueno['id']; ?>" 
                                       class="btn btn-sm btn-danger" title="Eliminar"
                                       onclick="return confirm('¿Está seguro de eliminar a <?php echo htmlspecialchars($dueno['nombre_completo']); ?>?');">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                    <?php else: ?>
                                    <button class="btn btn-sm btn-secondary" disabled title="No se puede eliminar: tiene mascotas">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
// Búsqueda en tiempo real
document.getElementById('buscarDueno').addEventListener('input', function() {
    const termino = this.value.toLowerCase();
    const filas = document.querySelectorAll('#tablaDuenos tbody tr');
    
    filas.forEach(fila => {
        const texto = fila.textContent.toLowerCase();
        fila.style.display = texto.includes(termino) ? '' : 'none';
    });
});
</script>

<?php include '../includes/footer.php'; ?>
