# Manual de Usuario – Sistema de Administración de Veterinaria

**Versión del Sistema:** 1.4.1
**Fecha del Documento:** 01 de diciembre de 2025

---

## 1. Introducción

Bienvenido al **Sistema de Administración de Veterinaria**, una solución completa diseñada para optimizar la gestión de su clínica, mejorar la atención al paciente y facilitar la comunicación con los dueños de las mascotas.

Este manual proporciona una guía detallada sobre cómo utilizar todas las funcionalidades del sistema, adaptada a cada uno de los roles de usuario.

### 1.1. Roles de Usuario

El sistema cuenta con tres perfiles de acceso, cada uno con permisos y funcionalidades específicas:

| Rol | Descripción |
| :--- | :--- |
| 👤 **Administrador** | Tiene control total sobre el sistema. Gestiona la configuración general, los usuarios colaboradores, los catálogos de precios (tratamientos, medicamentos) y accede a reportes globales. |
| 🧑‍⚕️ **Colaborador** | Es el personal de la clínica (veterinarios, asistentes). Gestiona el ciclo de vida de los pacientes: registro de dueños, mascotas, historial clínico, facturación y generación de credenciales. |
| ❤️ **Paciente (Dueño)** | Es el cliente final. Puede acceder a un portal para consultar la información de sus mascotas, ver su historial, próximas citas y promociones vigentes. |

### 1.2. Acceso al Sistema

Para ingresar, acceda a la URL de su sistema y utilice las credenciales proporcionadas. El sistema lo redirigirá automáticamente al panel correspondiente a su rol.

- **Administrador y Colaborador:** Inician sesión con un nombre de usuario y contraseña.
- **Paciente (Dueño):** Inicia sesión utilizando únicamente su número de Cédula de Identidad.

---

## 2. Módulo Administrador

El panel de administrador ofrece una vista global y control total sobre la configuración del sistema.

### 2.1. Panel Principal (Dashboard)

Al iniciar sesión, verá un resumen con estadísticas clave:
- Número total de mascotas registradas.
- Total de dueños.
- Cantidad de colaboradores activos.
- Accesos directos a las principales secciones de gestión.

### 2.2. Gestión de Colaboradores

Permite administrar las cuentas de usuario del personal de la clínica.

- **Crear Colaborador:**
  1. Vaya a `Administración > Colaboradores`.
  2. Haga clic en "Nuevo Colaborador".
  3. Complete los datos: nombre completo, nombre de usuario, contraseña y rol (colaborador).
- **Editar/Eliminar:** En la lista de colaboradores, puede modificar sus datos o desactivar su cuenta.

### 2.3. Gestión de Catálogos

Esta sección es fundamental para estandarizar los servicios y productos de la veterinaria.

- **Tratamientos:**
  - **Ubicación:** `Catálogos > Tratamientos`.
  - **Funcionalidad:** Defina los procedimientos médicos que ofrece la clínica (consultas, cirugías, etc.) y asigne un **precio base** a cada uno.
- **Medicamentos:**
  - **Ubicación:** `Catálogos > Medicamentos`.
  - **Funcionalidad:** Administre el inventario de medicamentos, incluyendo nombre, descripción, stock y **precio unitario**.
- **Promociones:**
  - **Ubicación:** `Catálogos > Promociones`.
  - **Funcionalidad:** Cree ofertas especiales para sus clientes. Puede definir:
    - **Nombre y descripción** de la promoción.
    - **Tipo de descuento:** Porcentaje (%) o Monto Fijo (Gs.).
    - **Valor del descuento**.
    - **Fechas de inicio y fin** de la vigencia.

### 2.4. Reportes

El módulo de reportes proporciona información valiosa para la toma de decisiones.

- **Ubicación:** `Reportes`.
- **Funcionalidades:**
  - **Reporte de Actividad:** Visualice un resumen de las visitas, tratamientos y facturación por rango de fechas.
  - **Reporte de Inventario:** Consulte el stock actual de medicamentos.

---

## 3. Módulo Colaborador

Este es el módulo principal para la operativa diaria de la clínica.

### 3.1. Flujo de Trabajo Recomendado

Para un registro eficiente y ordenado, siga estos pasos:

1. **Gestionar Dueño:** Primero, busque si el dueño ya existe. Si no, créelo.
2. **Agregar Mascotas:** Una vez seleccionado el dueño, agregue una o varias de sus mascotas.

### 3.2. Gestión de Dueños

- **Ubicación:** `Dueños`.
- **Funcionalidades:**
  - **Buscar Dueño:** Utilice la barra de búsqueda para encontrar un dueño por nombre o cédula.
  - **Crear Nuevo Dueño:** Si el dueño no existe, haga clic en "Nuevo Dueño" y complete sus datos (nombre, cédula, teléfono, dirección).
  - **Editar/Eliminar:** Puede actualizar la información de un dueño o eliminar su registro (esta acción es permanente).

### 3.3. Gestión de Mascotas

- **Ubicación:** `Mascotas` o desde el perfil del dueño.
- **Funcionalidades:**
  - **Agregar Mascota:** Asocie una nueva mascota a un dueño existente. Complete su perfil: nombre, foto, especie, raza, fecha de nacimiento, etc.
  - **Editar Mascota:** Actualice la información de la mascota.
  - **Eliminar Mascota (Desactivar):** Al eliminar una mascota, esta no se borra permanentemente, sino que se marca como "inactiva" (soft delete) para conservar su historial clínico.

### 3.4. Historial Clínico y Facturación

- **Nueva Visita:**
  1. Desde el perfil de la mascota, haga clic en "Nueva Visita".
  2. Registre el motivo de la consulta, diagnóstico y observaciones.
  3. Agregue los **tratamientos** y **medicamentos** aplicados. El sistema calculará el costo total automáticamente, aplicando promociones si corresponde.
- **Historial Clínico:**
  - Consulte todas las visitas anteriores de una mascota, incluyendo diagnósticos, tratamientos y fechas.

### 3.5. Alerta de Cumpleaños

El sistema muestra una alerta festiva en el dashboard cuando una de las mascotas cumple años ese día.

- **Funcionalidad:** El modal de cumpleaños incluye enlaces directos para enviar un saludo al dueño a través de:
  - **WhatsApp:** `https://wa.me/595...`
  - **Telegram:** `https://t.me/595...`

### 3.6. Credenciales y Reportes

- **Generar Credencial:**
  - Desde el perfil de la mascota, puede generar una credencial de identificación en formato PDF.
  - La credencial incluye la foto, datos de la mascota y un **código de barras** único para una rápida identificación.
- **Generar Reporte PDF:**
  - Exporte el historial clínico completo de una mascota a un archivo PDF para imprimirlo o compartirlo.

---

## 4. Módulo Paciente (Dueño)

Un portal exclusivo para que los dueños accedan a la información de sus mascotas.

### 4.1. Acceso al Portal

- El dueño debe ingresar a la URL del sistema y seleccionar la opción "Soy Paciente".
- El inicio de sesión se realiza únicamente con el **número de Cédula de Identidad** registrado en la clínica.

### 4.2. Panel Principal

El portal del paciente muestra:

- **Bienvenida:** Un saludo personalizado.
- **Mis Mascotas:** Una lista de todas sus mascotas registradas con su foto y nombre.
- **Alertas de Vacunas:** Notificaciones sobre vacunas que están próximas a vencer.
- **Próximas Citas:** Un resumen de las citas agendadas.

### 4.3. Ver Detalles de la Mascota

Haciendo clic en una mascota, el dueño puede acceder a:

- **Perfil Completo:** Foto, especie, raza, edad y peso.
- **Historial de Vacunas:** Un listado de todas las vacunas aplicadas y la fecha de la próxima dosis.
- **Historial de Visitas:** Un resumen de las consultas anteriores, con fecha y motivo.

### 4.4. Promociones Activas

- El dueño puede ver una sección con todas las **promociones y descuentos** que la veterinaria tiene vigentes, para aprovecharlas en su próxima visita.

---

## 5. Anexos

### 5.1. Credenciales por Defecto

- **Administrador:**
  - **Usuario:** `Veterinaria`
  - **Contraseña:** `m@scot@`
- **Colaborador (Ejemplo):**
  - **Usuario:** `colaborador1`
  - **Contraseña:** `vet2025`

> **Recomendación de Seguridad:** Se recomienda cambiar estas contraseñas después del primer inicio de sesión.

### 5.2. Formatos del Sistema

- **Moneda:** Todos los precios se muestran en **Guaraníes (Gs.)** con separadores de miles (ej: Gs. 150.000).
- **Fechas:** Se utiliza el formato `Día/Mes/Año` (ej: 25/12/2025).

### 5.3. Soporte Técnico

Si encuentra algún problema o tiene alguna duda que no esté resuelta en este manual, por favor contacte al equipo de desarrollo o al administrador del sistema.
