# Instrucciones de Instalación - Sistema de Administración de Veterinaria

## Paso 1: Requisitos Previos

Antes de comenzar, asegúrese de tener:

- Servidor web (Apache o Nginx)
- PHP 7.4 o superior
- MySQL 5.7 o superior (o MariaDB 10.4+)
- Extensiones de PHP: `pdo_mysql`, `gd`, `mbstring`

## Paso 2: Descomprimir el Archivo

Descomprima el archivo `veterinaria.zip` en el directorio raíz de su servidor web:

```bash
# Para Apache en Linux
unzip veterinaria.zip -d /var/www/html/

# Para XAMPP en Windows
# Descomprimir en C:\xampp\htdocs\

# Para WAMP en Windows
# Descomprimir en C:\wamp64\www\
```

## Paso 3: Crear la Base de Datos

### Opción A: Usando phpMyAdmin

1. Abra phpMyAdmin en su navegador (generalmente `http://localhost/phpmyadmin`)
2. Haga clic en "Nueva" en el panel izquierdo
3. Nombre de la base de datos: `veterinaria`
4. Cotejamiento: `utf8mb4_unicode_ci`
5. Haga clic en "Crear"

### Opción B: Usando línea de comandos

```bash
mysql -u root -p
```

Luego ejecute:

```sql
CREATE DATABASE veterinaria CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

## Paso 4: Crear el Usuario de Base de Datos

En phpMyAdmin o en la línea de comandos de MySQL:

```sql
CREATE USER 'mascotas'@'localhost' IDENTIFIED BY '@nim@les2025';
GRANT ALL PRIVILEGES ON veterinaria.* TO 'mascotas'@'localhost';
FLUSH PRIVILEGES;
```

## Paso 5: Importar el Esquema de la Base de Datos

### Opción A: Usando phpMyAdmin

1. Seleccione la base de datos `veterinaria` en el panel izquierdo
2. Haga clic en la pestaña "Importar"
3. Haga clic en "Seleccionar archivo"
4. Navegue hasta `veterinaria/database/schema.sql`
5. Haga clic en "Continuar"

### Opción B: Usando línea de comandos

```bash
mysql -u mascotas -p@nim@les2025 veterinaria < /ruta/a/veterinaria/database/schema.sql
```

## Paso 6: Configurar la Aplicación

Abra el archivo `config/config.php` y verifique que la línea de BASE_URL esté correcta:

```php
// Si instaló en la raíz del servidor
define('BASE_URL', 'http://localhost/veterinaria');

// Si instaló en un subdirectorio
define('BASE_URL', 'http://localhost/mi-carpeta/veterinaria');

// Para producción
define('BASE_URL', 'https://www.miveterinaria.com');
```

**Nota:** El sistema detecta automáticamente la URL base, pero puede ajustarla manualmente si es necesario.

## Paso 7: Configurar Permisos de Archivos

### En Linux/Mac:

```bash
cd /var/www/html/veterinaria
sudo chown -R www-data:www-data uploads/
sudo chmod -R 755 uploads/
```

### En Windows (XAMPP/WAMP):

Los permisos generalmente ya están configurados correctamente. Si tiene problemas, asegúrese de que la carpeta `uploads/` no esté marcada como "Solo lectura".

## Paso 8: Acceder al Sistema

1. Abra su navegador web
2. Vaya a la URL donde instaló la aplicación (ej. `http://localhost/veterinaria`)
3. Será redirigido automáticamente a la página de inicio de sesión

## Paso 9: Iniciar Sesión

Use las credenciales por defecto:

**Administrador:**
- Usuario: `Veterinaria`
- Contraseña: `m@scot@`

**Colaborador (ejemplo):**
- Usuario: `colaborador1`
- Contraseña: `vet2025`

## Paso 10: Cambiar Contraseñas (Recomendado)

Por seguridad, se recomienda cambiar las contraseñas por defecto después del primer acceso.

---

## Solución de Problemas Comunes

### Error: "No se puede conectar a la base de datos"

**Solución:**
1. Verifique que MySQL esté ejecutándose
2. Verifique las credenciales en `config/database.php`
3. Asegúrese de que el usuario `mascotas` tenga permisos sobre la base de datos `veterinaria`

### Error: "No se pueden subir archivos"

**Solución:**
1. Verifique los permisos de la carpeta `uploads/`
2. En Linux: `sudo chmod -R 755 uploads/`
3. Verifique que `upload_max_filesize` en `php.ini` sea al menos 5MB

### Error: "Página en blanco o error 500"

**Solución:**
1. Active la visualización de errores en `config/config.php`:
   ```php
   error_reporting(E_ALL);
   ini_set('display_errors', 1);
   ```
2. Revise los logs de error de PHP
3. Verifique que todas las extensiones de PHP estén instaladas

### Error: "Las imágenes no se muestran"

**Solución:**
1. Verifique que la constante `BASE_URL` en `config/config.php` sea correcta
2. Verifique los permisos de la carpeta `uploads/`
3. Asegúrese de que las rutas de las imágenes sean correctas

### Error: "Los estilos CSS no se cargan"

**Solución:**
1. Verifique que la carpeta `assets/` esté completa
2. Verifique la constante `BASE_URL` en `config/config.php`
3. Limpie la caché del navegador (Ctrl+F5)

---

## Configuración Avanzada

### Configurar HTTPS

Si su servidor tiene un certificado SSL:

1. Edite `config/config.php`
2. Cambie:
   ```php
   ini_set('session.cookie_secure', 1);
   ```
3. Actualice `BASE_URL` para usar `https://`

### Configurar Envío de Emails

Para habilitar el envío de emails (recordatorios, reportes):

1. Instale una librería de email (ej. PHPMailer)
2. Configure las credenciales SMTP en `config/config.php`

### Configurar Backups Automáticos

Se recomienda configurar backups automáticos de la base de datos:

```bash
# Crear un script de backup
#!/bin/bash
mysqldump -u mascotas -p@nim@les2025 veterinaria > /ruta/backups/veterinaria_$(date +%Y%m%d).sql

# Agregar a crontab para ejecutar diariamente
0 2 * * * /ruta/al/script/backup.sh
```

---

## Soporte

Si tiene problemas durante la instalación, verifique:

1. Los logs de error de PHP
2. Los logs de error de MySQL
3. Los permisos de archivos y carpetas
4. La configuración de `php.ini`

Para asistencia adicional, consulte la **Guía de Usuario** incluida en el archivo `GUIA_DE_USUARIO.md`.

---

**¡Instalación Completada!**

Su sistema de administración de veterinaria está listo para usar. Disfrute de todas las funcionalidades y mejore la gestión de su clínica veterinaria.
