# Guía de Usuario - Sistema de Administración de Veterinaria

## Tabla de Contenidos

1. [Introducción](#introducción)
2. [Acceso al Sistema](#acceso-al-sistema)
3. [Módulo Administrador](#módulo-administrador)
4. [Módulo Colaborador](#módulo-colaborador)
5. [Portal del Paciente](#portal-del-paciente)
6. [Preguntas Frecuentes](#preguntas-frecuentes)

---

## Introducción

El Sistema de Administración de Veterinaria es una aplicación web diseñada para facilitar la gestión integral de una clínica veterinaria. El sistema cuenta con tres módulos principales según el rol del usuario:

- **Administrador:** Control total del sistema, gestión de personal, tarifas y reportes financieros.
- **Colaborador:** Profesionales veterinarios que registran mascotas, realizan consultas y facturan servicios.
- **Paciente:** Dueños de mascotas que pueden consultar información de sus animales y calendario de vacunación.

---

## Acceso al Sistema

### Iniciar Sesión

1. Abra su navegador web y acceda a la URL del sistema (ej. `http://localhost/veterinaria`).
2. Ingrese su **Usuario** y **Contraseña**.
3. Haga clic en el botón **Iniciar Sesión**.

### Credenciales por Defecto

**Administrador:**
- Usuario: `Veterinaria`
- Contraseña: `m@scot@`

**Colaborador (ejemplo):**
- Usuario: `colaborador1`
- Contraseña: `vet2025`

**Nota:** Se recomienda cambiar las contraseñas por defecto después del primer acceso.

### Cerrar Sesión

Para cerrar sesión de forma segura, haga clic en el botón **Cerrar Sesión** ubicado en la barra de navegación superior.

---

## Módulo Administrador

El módulo de administrador proporciona acceso completo a todas las funcionalidades del sistema.

### Dashboard

Al iniciar sesión como administrador, verá el panel principal con estadísticas generales:

- Total de mascotas registradas
- Colaboradores activos
- Ingresos del mes
- Visitas realizadas

### Gestión de Colaboradores

**Crear un Nuevo Colaborador:**

1. Vaya a **Colaboradores** en el menú.
2. Haga clic en **Nuevo Colaborador**.
3. Complete el formulario con los datos del profesional:
   - Nombre completo
   - Usuario (para iniciar sesión)
   - Contraseña
   - Email
4. Haga clic en **Guardar**.

**Editar o Eliminar Colaboradores:**

- En la lista de colaboradores, use los botones de acción para **Editar** o **Eliminar** un registro.
- Al eliminar, el colaborador se marca como inactivo pero no se borra del sistema.

### Gestión de Tratamientos y Tarifas

**Crear un Tratamiento:**

1. Vaya a **Tratamientos** en el menú.
2. Haga clic en **Nuevo Tratamiento**.
3. Ingrese:
   - Nombre del tratamiento (ej. "Consulta General", "Baño", "Corte de Pelo")
   - Descripción
   - Precio en guaraníes
   - Tipo de mascota (opcional)
4. Haga clic en **Guardar**.

**Modificar Precios:**

- Puede editar los tratamientos existentes para actualizar precios en cualquier momento.

### Gestión de Medicamentos

Similar a los tratamientos, puede registrar medicamentos con su nombre, descripción y precio unitario.

### Promociones

**Crear una Promoción:**

1. Vaya a **Promociones**.
2. Haga clic en **Nueva Promoción**.
3. Complete:
   - Nombre de la promoción
   - Descripción
   - Descuento (porcentaje o monto fijo)
   - Fecha de inicio y fin
4. Haga clic en **Guardar**.

### Reportes y Estadísticas

**Ver Reportes:**

1. Vaya a **Reportes** en el menú.
2. Seleccione el período deseado:
   - Hoy
   - Esta semana
   - Este mes
   - Este año
   - Personalizado (seleccione fechas específicas)
3. Haga clic en **Filtrar**.

**Información Disponible:**

- Ingresos diarios
- Tratamientos más realizados
- Medicamentos más utilizados
- Estadísticas por profesional

**Exportar e Imprimir:**

- Use los botones **Exportar** e **Imprimir** para generar reportes en diferentes formatos.

---

## Módulo Colaborador

Los colaboradores (veterinarios) utilizan este módulo para la gestión diaria de las mascotas y sus consultas.

### Dashboard del Colaborador

Al iniciar sesión, verá:

- Resumen de visitas del día
- Citas programadas para hoy
- Vacunas próximas a vencer (15 días)

### Accesos Rápidos

- **Nueva Mascota:** Registrar una nueva mascota y su dueño.
- **Nueva Visita:** Registrar una consulta o visita.
- **Buscar:** Buscar mascotas por nombre, teléfono, cédula o código.
- **Todas las Mascotas:** Ver lista completa de mascotas registradas.

### Registrar una Nueva Mascota

1. Haga clic en **Nueva Mascota**.
2. Complete los datos del dueño:
   - Nombre completo
   - Cédula de identidad
   - Dirección
   - Teléfono (formato: +595 + número)
   - Marque si tiene WhatsApp o Telegram
   - Email (opcional)
3. Complete los datos de la mascota:
   - Nombre
   - Tipo (perro, gato, ave, etc.)
   - Raza
   - Fecha de nacimiento
   - Peso (opcional)
   - Fotografía (opcional)
4. Haga clic en **Registrar Mascota**.

**Nota:** Si el dueño ya existe en el sistema (por teléfono o cédula), sus datos se actualizarán y la nueva mascota se asociará a él.

### Buscar Mascotas

1. Haga clic en **Buscar** o use el buscador en cualquier página.
2. Ingrese el término de búsqueda:
   - Nombre de la mascota
   - Nombre del dueño
   - Teléfono
   - Cédula
   - Código de barras de la mascota
3. Haga clic en **Buscar**.
4. Los resultados mostrarán las mascotas que coincidan con el término.

### Ver Detalles de una Mascota

Al hacer clic en **Ver Detalles** de una mascota, podrá acceder a:

- **Información general:** Foto, nombre, tipo, raza, edad, peso.
- **Información del dueño:** Nombre, teléfono (con enlaces a WhatsApp/Telegram), dirección.
- **Historial de visitas:** Todas las consultas realizadas con fecha, motivo, diagnóstico y facturación.
- **Calendario de vacunación:** Vacunas aplicadas y próximas dosis.

**Acciones Disponibles:**

- **Editar:** Modificar datos de la mascota o del dueño.
- **Nueva Visita:** Registrar una nueva consulta.
- **Ver Credencial:** Generar e imprimir la credencial de la mascota con código de barras.

### Registrar una Nueva Visita (con Facturación)

1. Desde la ficha de la mascota, haga clic en **Nueva Visita**.
2. Complete los datos de la visita:
   - Fecha y hora
   - Peso actual (opcional)
   - Motivo de la visita
   - Diagnóstico
   - Observaciones
   - Próxima cita (opcional)
3. **Vacunación (opcional):**
   - Si aplicó una vacuna, ingrese el nombre y la fecha de la próxima dosis.
4. **Facturación:**
   - Seleccione los tratamientos realizados (ej. consulta, baño, corte de pelo).
   - Para cada tratamiento, ajuste la cantidad y el precio si es necesario.
   - Seleccione los medicamentos administrados.
   - El sistema calculará automáticamente el total.
5. Seleccione el **Estado de Pago** (Pendiente o Pagada).
6. Haga clic en **Registrar Visita y Facturar**.

**Nota:** La factura queda asociada a la visita y se puede consultar en el historial de la mascota.

### Generar Credencial de Mascota

1. Desde la ficha de la mascota, haga clic en **Ver Credencial**.
2. Se abrirá una nueva ventana con la credencial en formato imprimible.
3. La credencial incluye:
   - Foto de la mascota
   - Nombre, tipo, raza y edad
   - Datos del dueño
   - Código de barras único
4. Haga clic en **Imprimir Credencial** para imprimir o guardar como PDF.

### Generar Reporte de Visita

1. Desde el historial de visitas de una mascota, haga clic en el ícono de PDF.
2. Se generará un reporte detallado de la visita con:
   - Información de la mascota y dueño
   - Detalles de la consulta
   - Tratamientos y medicamentos aplicados
   - Total facturado
3. Puede imprimir o guardar el reporte para enviar al dueño.

### Integración con WhatsApp y Telegram

En la ficha de la mascota, si el dueño tiene WhatsApp o Telegram, verá botones de acceso directo:

- **WhatsApp:** Haga clic para abrir una conversación en WhatsApp Web o la aplicación.
- **Telegram:** Haga clic para abrir una conversación en Telegram Web o la aplicación.

Esto facilita el contacto rápido con los dueños para recordatorios de vacunas o citas.

---

## Portal del Paciente

Los dueños de mascotas pueden acceder al portal del paciente para consultar información de sus animales.

### Acceso al Portal

1. El sistema crea automáticamente un usuario para cada dueño cuando se registra una mascota.
2. Las credenciales se pueden consultar en la base de datos o solicitar al administrador.
3. Ingrese con su usuario y contraseña en la página de inicio de sesión.

### Mis Mascotas

Al iniciar sesión, verá tarjetas con todas sus mascotas registradas:

- Foto
- Nombre
- Tipo y raza
- Edad
- Alertas de vacunas próximas

Haga clic en **Ver Detalles** para acceder a la ficha completa.

### Ficha de la Mascota

En la ficha de cada mascota podrá ver:

- **Información general:** Todos los datos de la mascota.
- **Última visita:** Detalles de la última consulta realizada.
- **Calendario de vacunación:** Lista de vacunas aplicadas y próximas dosis con alertas de vencimiento.

**Alertas de Vacunas:**

- **Vencida (rojo):** La vacuna ya debió aplicarse.
- **Próxima (amarillo):** La vacuna vence en los próximos 30 días.
- **Al día (verde):** La vacuna está al día.

### Calendario de Vacunas

En el menú **Vacunas**, podrá ver un resumen de todas las vacunas de todas sus mascotas, clasificadas por estado:

- Vacunas vencidas (requieren atención inmediata)
- Vacunas próximas (próximos 30 días)
- Vacunas al día

---

## Preguntas Frecuentes

**¿Cómo cambio mi contraseña?**

Actualmente, la funcionalidad de cambio de contraseña debe ser realizada por el administrador. Contacte al personal de la veterinaria para solicitar un cambio.

**¿Puedo registrar más de una mascota para el mismo dueño?**

Sí, el sistema permite asociar múltiples mascotas a un mismo dueño. Al registrar una nueva mascota, si el teléfono o cédula del dueño ya existe, se asociará automáticamente.

**¿Cómo se genera el código de barras de la mascota?**

El código de barras se genera automáticamente al registrar una nueva mascota y es único para cada animal.

**¿Puedo modificar una visita después de registrarla?**

Actualmente, las visitas no se pueden modificar una vez registradas para mantener la integridad del historial clínico. Si necesita hacer correcciones, contacte al administrador.

**¿Los reportes se pueden exportar a Excel?**

La funcionalidad de exportación a Excel está en desarrollo. Actualmente puede imprimir los reportes o guardarlos como PDF.

**¿Qué hago si olvido mi contraseña?**

Contacte al administrador del sistema para que restablezca su contraseña.

**¿El sistema envía recordatorios automáticos de vacunas?**

Actualmente, el sistema muestra alertas de vacunas próximas en el dashboard, pero no envía notificaciones automáticas. Los colaboradores deben contactar manualmente a los dueños usando los enlaces de WhatsApp o Telegram.

**¿Puedo usar el sistema en mi teléfono móvil?**

El sistema está optimizado para computadoras de escritorio y notebooks. El uso en dispositivos móviles puede tener limitaciones de visualización.

---

## Soporte Técnico

Para asistencia técnica o consultas sobre el uso del sistema, contacte al administrador de la veterinaria.

**Versión del Sistema:** 1.0.0  
**Última Actualización:** Noviembre 2025

---

**Desarrollado con ❤️ para el cuidado de nuestras mascotas**
